/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CalDavResponseSupplier;

public class CalDavApi {
    private ApiClient apiClient;

    public CalDavApi() {
        this(new ApiClient());
    }

    @Autowired
    public CalDavApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec generateCalDavAuthRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling generateCalDavAuth", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/caldav/auth/regen", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CalDavResponseSupplier> generateCalDavAuth(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.generateCalDavAuthRequestCreation(hotelIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CalDavResponseSupplier>> generateCalDavAuthWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.generateCalDavAuthRequestCreation(hotelIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec generateCalDavAuthWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.generateCalDavAuthRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec retrieveCalDavAuthRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling retrieveCalDavAuth", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/caldav/auth", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CalDavResponseSupplier> retrieveCalDavAuth(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.retrieveCalDavAuthRequestCreation(hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CalDavResponseSupplier>> retrieveCalDavAuthWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.retrieveCalDavAuthRequestCreation(hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec retrieveCalDavAuthWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.retrieveCalDavAuthRequestCreation(hotelIdentifier, winkVersion, accept);
    }
}

