/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.DuplicateGuestRoomRequestSupplier;
import travel.wink.sdk.extranet.model.GuestRoomView;
import travel.wink.sdk.extranet.model.GuestRoomViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.UpsertGuestRoomRequestSupplier;

public class GuestRoomApi {
    private ApiClient apiClient;

    public GuestRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public GuestRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createGuestRoomRequestCreation(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertGuestRoomRequestSupplier postBody = upsertGuestRoomRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertGuestRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGuestRoomRequestSupplier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomViewSupplier> createGuestRoom(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomViewSupplier>> createGuestRoomWithHttpInfo(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createGuestRoomWithResponseSpec(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec duplicateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        DuplicateGuestRoomRequestSupplier postBody = duplicateGuestRoomRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duplicateGuestRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'duplicateGuestRoomRequestSupplier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/duplicate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomViewSupplier> duplicateGuestRoom(String hotelIdentifier, String guestRoomIdentifier, DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, duplicateGuestRoomRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomViewSupplier>> duplicateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, duplicateGuestRoomRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec duplicateGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, duplicateGuestRoomRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeMultimedia2RequestCreation(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> removeMultimedia2(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(this){};
        return this.removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> removeMultimedia2WithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(this){};
        return this.removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimedia2WithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomViewSupplier> showGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomViewSupplier>> showGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showGuestRoomsRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GuestRoomViewSupplier> showGuestRooms(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.showGuestRoomsRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GuestRoomViewSupplier>>> showGuestRoomsWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.showGuestRoomsRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGuestRoomsWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showGuestRoomsRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertGuestRoomRequestSupplier postBody = upsertGuestRoomRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertGuestRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGuestRoomRequestSupplier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomViewSupplier> updateGuestRoom(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomViewSupplier>> updateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadGuestRoomMediaRequestCreation(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomViewSupplier> uploadGuestRoomMedia(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomViewSupplier>> uploadGuestRoomMediaWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>(this){};
        return this.uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadGuestRoomMediaWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files);
    }
}

