/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.LifestylesResponseSupplier;
import travel.wink.sdk.extranet.model.UpdateLifestylesRequestSupplier;

public class LifestyleApi {
    private ApiClient apiClient;

    public LifestyleApi() {
        this(new ApiClient());
    }

    @Autowired
    public LifestyleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showLifestylesRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/lifestyles", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<LifestylesResponseSupplier> showLifestyles(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>(this){};
        return this.showLifestylesRequestCreation(hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<LifestylesResponseSupplier>> showLifestylesWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>(this){};
        return this.showLifestylesRequestCreation(hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLifestylesWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showLifestylesRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateLifestylesRequestCreation(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpdateLifestylesRequestSupplier postBody = updateLifestylesRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateLifestylesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateLifestylesRequestSupplier' when calling updateLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/lifestyles", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<LifestylesResponseSupplier> updateLifestyles(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>(this){};
        return this.updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<LifestylesResponseSupplier>> updateLifestylesWithHttpInfo(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>(this){};
        return this.updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateLifestylesWithResponseSpec(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequestSupplier, winkVersion);
    }
}

