/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.ChangePropertyNameRequestSupplier;
import travel.wink.sdk.extranet.model.GeneralManagerSupplier;
import travel.wink.sdk.extranet.model.HotelViewSupplier;
import travel.wink.sdk.extranet.model.ImproveWelcomeTextRequestSupplier;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SuggestAmenitiesRequestSupplier;
import travel.wink.sdk.extranet.model.SuggestProfileRequestSupplier;
import travel.wink.sdk.extranet.model.SuggestProfileResponseSupplier;
import travel.wink.sdk.extranet.model.SuggestWelcomeTextRequestSupplier;
import travel.wink.sdk.extranet.model.UniqueResultSupplier;
import travel.wink.sdk.extranet.model.UpdateExternalHotelStatusRequestSupplier;
import travel.wink.sdk.extranet.model.UpdatePropertyAmenitiesAndServicesRequestSupplier;
import travel.wink.sdk.extranet.model.UpsertPropertyAddressRequestSupplier;
import travel.wink.sdk.extranet.model.UpsertPropertyProfileRequestSupplier;
import travel.wink.sdk.extranet.model.UpsertReservationsDeskRequestSupplier;
import travel.wink.sdk.extranet.model.UpsertWelcomeTextRequestSupplier;

public class PropertyApi {
    private ApiClient apiClient;

    public PropertyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PropertyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec changePropertyNameRequestCreation(String hotelIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        ChangePropertyNameRequestSupplier postBody = changePropertyNameRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling changePropertyName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (changePropertyNameRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'changePropertyNameRequestSupplier' when calling changePropertyName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/change-name", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> changePropertyName(String hotelIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.changePropertyNameRequestCreation(hotelIdentifier, changePropertyNameRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> changePropertyNameWithHttpInfo(String hotelIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.changePropertyNameRequestCreation(hotelIdentifier, changePropertyNameRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec changePropertyNameWithResponseSpec(String hotelIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.changePropertyNameRequestCreation(hotelIdentifier, changePropertyNameRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec improveWelcomeTextRequestCreation(String hotelIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ImproveWelcomeTextRequestSupplier postBody = improveWelcomeTextRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling improveWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (improveWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'improveWelcomeTextRequestSupplier' when calling improveWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/welcome-text/improve", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SimpleDescriptionSupplier> improveWelcomeText(String hotelIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.improveWelcomeTextRequestCreation(hotelIdentifier, improveWelcomeTextRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SimpleDescriptionSupplier>> improveWelcomeTextWithHttpInfo(String hotelIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.improveWelcomeTextRequestCreation(hotelIdentifier, improveWelcomeTextRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec improveWelcomeTextWithResponseSpec(String hotelIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.improveWelcomeTextRequestCreation(hotelIdentifier, improveWelcomeTextRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec isHotelNameUniqueRequestCreation(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (key == null) {
            throw new WebClientResponseException("Missing the required parameter 'key' when calling isHotelNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "key", key));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/uniquename", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResultSupplier> isHotelNameUnique(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResultSupplier>> isHotelNameUniqueWithHttpInfo(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isHotelNameUniqueWithResponseSpec(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelByManagerRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelByManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> showHotelByManager(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.showHotelByManagerRequestCreation(hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> showHotelByManagerWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.showHotelByManagerRequestCreation(hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelByManagerWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showHotelByManagerRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelStatusRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UpdateExternalHotelStatusRequestSupplier> showHotelStatus(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>(this){};
        return this.showHotelStatusRequestCreation(hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateExternalHotelStatusRequestSupplier>> showHotelStatusWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>(this){};
        return this.showHotelStatusRequestCreation(hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelStatusWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showHotelStatusRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelsByManagerRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<HotelViewSupplier> showHotelsByManager(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.showHotelsByManagerRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<HotelViewSupplier>>> showHotelsByManagerWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.showHotelsByManagerRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelsByManagerWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showHotelsByManagerRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec suggestPropertyProfileRequestCreation(String hotelIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        SuggestProfileRequestSupplier postBody = suggestProfileRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling suggestPropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (suggestProfileRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestProfileRequestSupplier' when calling suggestPropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/profile/suggest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SuggestProfileResponseSupplier> suggestPropertyProfile(String hotelIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>(this){};
        return this.suggestPropertyProfileRequestCreation(hotelIdentifier, suggestProfileRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SuggestProfileResponseSupplier>> suggestPropertyProfileWithHttpInfo(String hotelIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>(this){};
        return this.suggestPropertyProfileRequestCreation(hotelIdentifier, suggestProfileRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec suggestPropertyProfileWithResponseSpec(String hotelIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.suggestPropertyProfileRequestCreation(hotelIdentifier, suggestProfileRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec suggestPropertyWelcomeTextRequestCreation(String hotelIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        SuggestWelcomeTextRequestSupplier postBody = suggestWelcomeTextRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling suggestPropertyWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (suggestWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestWelcomeTextRequestSupplier' when calling suggestPropertyWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/welcome-text/suggest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SimpleDescriptionSupplier> suggestPropertyWelcomeText(String hotelIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.suggestPropertyWelcomeTextRequestCreation(hotelIdentifier, suggestWelcomeTextRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SimpleDescriptionSupplier>> suggestPropertyWelcomeTextWithHttpInfo(String hotelIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.suggestPropertyWelcomeTextRequestCreation(hotelIdentifier, suggestWelcomeTextRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec suggestPropertyWelcomeTextWithResponseSpec(String hotelIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.suggestPropertyWelcomeTextRequestCreation(hotelIdentifier, suggestWelcomeTextRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec suggestPropertyWelcomeText1RequestCreation(String hotelIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        SuggestAmenitiesRequestSupplier postBody = suggestAmenitiesRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling suggestPropertyWelcomeText1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (suggestAmenitiesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestAmenitiesRequestSupplier' when calling suggestPropertyWelcomeText1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/services/suggest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> suggestPropertyWelcomeText1(String hotelIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.suggestPropertyWelcomeText1RequestCreation(hotelIdentifier, suggestAmenitiesRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> suggestPropertyWelcomeText1WithHttpInfo(String hotelIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.suggestPropertyWelcomeText1RequestCreation(hotelIdentifier, suggestAmenitiesRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec suggestPropertyWelcomeText1WithResponseSpec(String hotelIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.suggestPropertyWelcomeText1RequestCreation(hotelIdentifier, suggestAmenitiesRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateAddressRequestCreation(String hotelIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertPropertyAddressRequestSupplier postBody = upsertPropertyAddressRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPropertyAddressRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyAddressRequestSupplier' when calling updateAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/address", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateAddress(String hotelIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateAddressRequestCreation(hotelIdentifier, upsertPropertyAddressRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateAddressWithHttpInfo(String hotelIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateAddressRequestCreation(hotelIdentifier, upsertPropertyAddressRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAddressWithResponseSpec(String hotelIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateAddressRequestCreation(hotelIdentifier, upsertPropertyAddressRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateGeneralManagerRequestCreation(String hotelIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        GeneralManagerSupplier postBody = generalManagerSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (generalManagerSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'generalManagerSupplier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/general-manager", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateGeneralManager(String hotelIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateGeneralManagerRequestCreation(hotelIdentifier, generalManagerSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateGeneralManagerWithHttpInfo(String hotelIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateGeneralManagerRequestCreation(hotelIdentifier, generalManagerSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateGeneralManagerWithResponseSpec(String hotelIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateGeneralManagerRequestCreation(hotelIdentifier, generalManagerSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateHotelStatusRequestCreation(String hotelIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpdateExternalHotelStatusRequestSupplier postBody = updateExternalHotelStatusRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateExternalHotelStatusRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateExternalHotelStatusRequestSupplier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateHotelStatus(String hotelIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateHotelStatusRequestCreation(hotelIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateHotelStatusWithHttpInfo(String hotelIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateHotelStatusRequestCreation(hotelIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateHotelStatusWithResponseSpec(String hotelIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateHotelStatusRequestCreation(hotelIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updatePropertyProfileRequestCreation(String hotelIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertPropertyProfileRequestSupplier postBody = upsertPropertyProfileRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPropertyProfileRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyProfileRequestSupplier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/profile", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updatePropertyProfile(String hotelIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updatePropertyProfileRequestCreation(hotelIdentifier, upsertPropertyProfileRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updatePropertyProfileWithHttpInfo(String hotelIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updatePropertyProfileRequestCreation(hotelIdentifier, upsertPropertyProfileRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updatePropertyProfileWithResponseSpec(String hotelIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updatePropertyProfileRequestCreation(hotelIdentifier, upsertPropertyProfileRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateReservationsDeskRequestCreation(String hotelIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertReservationsDeskRequestSupplier postBody = upsertReservationsDeskRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateReservationsDesk", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertReservationsDeskRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertReservationsDeskRequestSupplier' when calling updateReservationsDesk", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/reservations-desk", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateReservationsDesk(String hotelIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateReservationsDeskRequestCreation(hotelIdentifier, upsertReservationsDeskRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateReservationsDeskWithHttpInfo(String hotelIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateReservationsDeskRequestCreation(hotelIdentifier, upsertReservationsDeskRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateReservationsDeskWithResponseSpec(String hotelIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateReservationsDeskRequestCreation(hotelIdentifier, upsertReservationsDeskRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateServicesRequestCreation(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpdatePropertyAmenitiesAndServicesRequestSupplier postBody = updatePropertyAmenitiesAndServicesRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updatePropertyAmenitiesAndServicesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updatePropertyAmenitiesAndServicesRequestSupplier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/services", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateServices(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateServicesRequestCreation(hotelIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateServicesWithHttpInfo(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateServicesRequestCreation(hotelIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateServicesWithResponseSpec(String hotelIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateServicesRequestCreation(hotelIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateWelcomeTextRequestCreation(String hotelIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertWelcomeTextRequestSupplier postBody = upsertWelcomeTextRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertWelcomeTextRequestSupplier' when calling updateWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/welcome-text", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateWelcomeText(String hotelIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateWelcomeTextRequestCreation(hotelIdentifier, upsertWelcomeTextRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateWelcomeTextWithHttpInfo(String hotelIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateWelcomeTextRequestCreation(hotelIdentifier, upsertWelcomeTextRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateWelcomeTextWithResponseSpec(String hotelIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateWelcomeTextRequestCreation(hotelIdentifier, upsertWelcomeTextRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadGeneralManagerProfilePictureRequestCreation(String hotelIdentifier, File _file) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (_file == null) {
            throw new WebClientResponseException("Missing the required parameter '_file' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (_file != null) {
            formParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/general-manager/upload", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> uploadGeneralManagerProfilePicture(String hotelIdentifier, File _file) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.uploadGeneralManagerProfilePictureRequestCreation(hotelIdentifier, _file).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> uploadGeneralManagerProfilePictureWithHttpInfo(String hotelIdentifier, File _file) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.uploadGeneralManagerProfilePictureRequestCreation(hotelIdentifier, _file).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadGeneralManagerProfilePictureWithResponseSpec(String hotelIdentifier, File _file) throws WebClientResponseException {
        return this.uploadGeneralManagerProfilePictureRequestCreation(hotelIdentifier, _file);
    }
}

