/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.RestaurantViewSupplier;
import travel.wink.sdk.extranet.model.UpsertRestaurantRequestSupplier;

public class RestaurantApi {
    private ApiClient apiClient;

    public RestaurantApi() {
        this(new ApiClient());
    }

    @Autowired
    public RestaurantApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRestaurantRequestCreation(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRestaurantRequestSupplier postBody = upsertRestaurantRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRestaurantRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRestaurantRequestSupplier' when calling createRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantViewSupplier> createRestaurant(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.createRestaurantRequestCreation(hotelIdentifier, upsertRestaurantRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantViewSupplier>> createRestaurantWithHttpInfo(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.createRestaurantRequestCreation(hotelIdentifier, upsertRestaurantRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRestaurantWithResponseSpec(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createRestaurantRequestCreation(hotelIdentifier, upsertRestaurantRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeMultimedia3RequestCreation(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia3", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling removeMultimedia3", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia3", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantViewSupplier> removeMultimedia3(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.removeMultimedia3RequestCreation(hotelIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantViewSupplier>> removeMultimedia3WithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.removeMultimedia3RequestCreation(hotelIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimedia3WithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeMultimedia3RequestCreation(hotelIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeRestaurantRequestCreation(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling removeRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeRestaurant(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRestaurantWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRestaurantWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantRequestCreation(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling showRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantViewSupplier> showRestaurant(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.showRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantViewSupplier>> showRestaurantWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.showRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantPairsRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurantPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showRestaurantPairs(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showRestaurantPairsRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showRestaurantPairsWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showRestaurantPairsRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantPairsWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRestaurantPairsRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantsRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurants", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RestaurantViewSupplier> showRestaurants(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.showRestaurantsRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RestaurantViewSupplier>>> showRestaurantsWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.showRestaurantsRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantsWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRestaurantsRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRestaurantRequestCreation(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRestaurantRequestSupplier postBody = upsertRestaurantRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRestaurantRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRestaurantRequestSupplier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantViewSupplier> updateRestaurant(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.updateRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantViewSupplier>> updateRestaurantWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.updateRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRestaurantWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadRestaurantMediaRequestCreation(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantViewSupplier> uploadRestaurantMedia(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.uploadRestaurantMediaRequestCreation(hotelIdentifier, restaurantIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantViewSupplier>> uploadRestaurantMediaWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>(this){};
        return this.uploadRestaurantMediaRequestCreation(hotelIdentifier, restaurantIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadRestaurantMediaWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadRestaurantMediaRequestCreation(hotelIdentifier, restaurantIdentifier, files);
    }
}

