/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.InventoryUpdateRequestSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.SalesChannelCreateRequestSupplier;
import travel.wink.sdk.extranet.model.SalesChannelSupplier;
import travel.wink.sdk.extranet.model.SalesChannelUpdateRequestSupplier;
import travel.wink.sdk.extranet.model.SelectableKeyValuePairSupplier;

public class SalesChannelsApi {
    private ApiClient apiClient;

    public SalesChannelsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestCreation(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        SalesChannelCreateRequestSupplier postBody = salesChannelCreateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelCreateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelCreateRequestSupplier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> createSalesChannel(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> createSalesChannelWithHttpInfo(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSalesChannelWithResponseSpec(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSalesChannelWithResponseSpec(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAccountsRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAccounts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> showAccounts(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showAccountsRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> showAccountsWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showAccountsRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAccountsWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAccountsRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> showSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> showSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelWithResponseSpec(String hotelIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierBundlePairs(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierBundlePairsWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsWithResponseSpec(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierPairsRequestCreation(String hotelIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierPairs(String hotelIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierPairsWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelContextRateModifierPairsWithResponseSpec(String hotelIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityRequestCreation(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> toggleSalesChannelPromoAvailability(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityWithResponseSpec(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> toggleSalesChannelPromoBundleAvailability(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoBundleAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityWithResponseSpec(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        SalesChannelUpdateRequestSupplier postBody = salesChannelUpdateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelUpdateRequestSupplier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> updateSalesChannel(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> updateSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSalesChannelWithResponseSpec(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion);
    }
}

