/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "startDate", "endDate", "descriptions", "showTitle", "showAlways"})
@JsonTypeName(value="Announcement_Supplier")
public class AnnouncementSupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_SHOW_TITLE = "showTitle";
    private Boolean showTitle = false;
    public static final String JSON_PROPERTY_SHOW_ALWAYS = "showAlways";
    private Boolean showAlways = false;

    public AnnouncementSupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public AnnouncementSupplier hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AnnouncementSupplier startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public AnnouncementSupplier endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public AnnouncementSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public AnnouncementSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public AnnouncementSupplier showTitle(Boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="showTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTitle() {
        return this.showTitle;
    }

    @JsonProperty(value="showTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowTitle(Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public AnnouncementSupplier showAlways(Boolean showAlways) {
        this.showAlways = showAlways;
        return this;
    }

    @Nullable
    @JsonProperty(value="showAlways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAlways() {
        return this.showAlways;
    }

    @JsonProperty(value="showAlways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAlways(Boolean showAlways) {
        this.showAlways = showAlways;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnouncementSupplier announcementSupplier = (AnnouncementSupplier)o;
        return Objects.equals(this.identifier, announcementSupplier.identifier) && Objects.equals(this.hotelIdentifier, announcementSupplier.hotelIdentifier) && Objects.equals(this.startDate, announcementSupplier.startDate) && Objects.equals(this.endDate, announcementSupplier.endDate) && Objects.equals(this.descriptions, announcementSupplier.descriptions) && Objects.equals(this.showTitle, announcementSupplier.showTitle) && Objects.equals(this.showAlways, announcementSupplier.showAlways);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.hotelIdentifier, this.startDate, this.endDate, this.descriptions, this.showTitle, this.showAlways);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnnouncementSupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    showTitle: ").append(this.toIndentedString(this.showTitle)).append("\n");
        sb.append("    showAlways: ").append(this.toIndentedString(this.showAlways)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

