/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;

@JsonPropertyOrder(value={"startDate", "endDate", "descriptions", "showTitle", "showAlways"})
@JsonTypeName(value="UpsertAnnouncementRequest_Supplier")
public class UpsertAnnouncementRequestSupplier {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_SHOW_TITLE = "showTitle";
    private Boolean showTitle = false;
    public static final String JSON_PROPERTY_SHOW_ALWAYS = "showAlways";
    private Boolean showAlways = false;

    public UpsertAnnouncementRequestSupplier startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public UpsertAnnouncementRequestSupplier endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public UpsertAnnouncementRequestSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public UpsertAnnouncementRequestSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public UpsertAnnouncementRequestSupplier showTitle(Boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="showTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTitle() {
        return this.showTitle;
    }

    @JsonProperty(value="showTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowTitle(Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public UpsertAnnouncementRequestSupplier showAlways(Boolean showAlways) {
        this.showAlways = showAlways;
        return this;
    }

    @Nullable
    @JsonProperty(value="showAlways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAlways() {
        return this.showAlways;
    }

    @JsonProperty(value="showAlways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAlways(Boolean showAlways) {
        this.showAlways = showAlways;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier = (UpsertAnnouncementRequestSupplier)o;
        return Objects.equals(this.startDate, upsertAnnouncementRequestSupplier.startDate) && Objects.equals(this.endDate, upsertAnnouncementRequestSupplier.endDate) && Objects.equals(this.descriptions, upsertAnnouncementRequestSupplier.descriptions) && Objects.equals(this.showTitle, upsertAnnouncementRequestSupplier.showTitle) && Objects.equals(this.showAlways, upsertAnnouncementRequestSupplier.showAlways);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.descriptions, this.showTitle, this.showAlways);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertAnnouncementRequestSupplier {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    showTitle: ").append(this.toIndentedString(this.showTitle)).append("\n");
        sb.append("    showAlways: ").append(this.toIndentedString(this.showAlways)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

