package travel.wink.hotelbeds.booking.sdk.api;

import travel.wink.hotelbeds.booking.sdk.invoker.ApiClient;

import travel.wink.hotelbeds.booking.sdk.model.BookingCancellationRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingChangeRQ;
import travel.wink.hotelbeds.booking.sdk.model.BookingChangeRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingDetailRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingListRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingRQ;
import travel.wink.hotelbeds.booking.sdk.model.BookingRS;
import java.time.LocalDate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Booking confirmation
     * The Booking operation requests a reservation confirmation for the specified ratekey or ratekeys.  BookingAPI does not support on-request confirmations. All confirmations are instant confirmations.  Timeout for this operation is 60 seconds.
     * <p><b>200</b> - When the confirmation of a rateKey is successful; the booking reference is provided, along with key information of the booking, which includes:    * Hotel confirmed   * Holder and pax confirmed   * Rate confirmed with the confirmed amounts and dates  The response also contains the price breakdown, cancellation policies, supplements, and discounts.  Please make sure to **keep the booking reference** of all bookings performed with your credentials, as they are needed for post booking operations such as modification or cancellation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later. * *Release violated*  * *There&#39;s a stop sales for the date/s*  *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of Booking operation
     * @return BookingRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bookingRequestCreation(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json", "application/xml"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<BookingRS> localVarReturnType = new ParameterizedTypeReference<BookingRS>() {};
        return apiClient.invokeAPI("/bookings", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Booking confirmation
     * The Booking operation requests a reservation confirmation for the specified ratekey or ratekeys.  BookingAPI does not support on-request confirmations. All confirmations are instant confirmations.  Timeout for this operation is 60 seconds.
     * <p><b>200</b> - When the confirmation of a rateKey is successful; the booking reference is provided, along with key information of the booking, which includes:    * Hotel confirmed   * Holder and pax confirmed   * Rate confirmed with the confirmed amounts and dates  The response also contains the price breakdown, cancellation policies, supplements, and discounts.  Please make sure to **keep the booking reference** of all bookings performed with your credentials, as they are needed for post booking operations such as modification or cancellation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later. * *Release violated*  * *There&#39;s a stop sales for the date/s*  *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of Booking operation
     * @return BookingRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingRS> booking(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingRS> localVarReturnType = new ParameterizedTypeReference<BookingRS>() {};
        return bookingRequestCreation(accept, acceptEncoding, contentType, body).bodyToMono(localVarReturnType);
    }

    /**
     * Booking confirmation
     * The Booking operation requests a reservation confirmation for the specified ratekey or ratekeys.  BookingAPI does not support on-request confirmations. All confirmations are instant confirmations.  Timeout for this operation is 60 seconds.
     * <p><b>200</b> - When the confirmation of a rateKey is successful; the booking reference is provided, along with key information of the booking, which includes:    * Hotel confirmed   * Holder and pax confirmed   * Rate confirmed with the confirmed amounts and dates  The response also contains the price breakdown, cancellation policies, supplements, and discounts.  Please make sure to **keep the booking reference** of all bookings performed with your credentials, as they are needed for post booking operations such as modification or cancellation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later. * *Release violated*  * *There&#39;s a stop sales for the date/s*  *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of Booking operation
     * @return ResponseEntity&lt;BookingRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingRS>> bookingWithHttpInfo(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingRS> localVarReturnType = new ParameterizedTypeReference<BookingRS>() {};
        return bookingRequestCreation(accept, acceptEncoding, contentType, body).toEntity(localVarReturnType);
    }

    /**
     * Booking confirmation
     * The Booking operation requests a reservation confirmation for the specified ratekey or ratekeys.  BookingAPI does not support on-request confirmations. All confirmations are instant confirmations.  Timeout for this operation is 60 seconds.
     * <p><b>200</b> - When the confirmation of a rateKey is successful; the booking reference is provided, along with key information of the booking, which includes:    * Hotel confirmed   * Holder and pax confirmed   * Rate confirmed with the confirmed amounts and dates  The response also contains the price breakdown, cancellation policies, supplements, and discounts.  Please make sure to **keep the booking reference** of all bookings performed with your credentials, as they are needed for post booking operations such as modification or cancellation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later. * *Release violated*  * *There&#39;s a stop sales for the date/s*  *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of Booking operation
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bookingWithResponseSpec(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        return bookingRequestCreation(accept, acceptEncoding, contentType, body);
    }
    /**
     * Booking cancellation
     * BookingCancellation is used either to simulate a cancellation or to perform the actual cancellation.Cancellations always take into account day and time of the destination in order to calculate what cancellation policy should be applied. Timeout for this operation is 60 seconds.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function.  Format: XXX-YYYYYY
     * @param cancellationFlag Type of cancellation method to be used.
     * @param language Language in which the description texts will be returned in the response
     * @return BookingCancellationRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bookingCancellationRequestCreation(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingId' is set
        if (bookingId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingId' when calling bookingCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingId", bookingId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "cancellationFlag", cancellationFlag));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<BookingCancellationRS> localVarReturnType = new ParameterizedTypeReference<BookingCancellationRS>() {};
        return apiClient.invokeAPI("/bookings/{bookingId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Booking cancellation
     * BookingCancellation is used either to simulate a cancellation or to perform the actual cancellation.Cancellations always take into account day and time of the destination in order to calculate what cancellation policy should be applied. Timeout for this operation is 60 seconds.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function.  Format: XXX-YYYYYY
     * @param cancellationFlag Type of cancellation method to be used.
     * @param language Language in which the description texts will be returned in the response
     * @return BookingCancellationRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingCancellationRS> bookingCancellation(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellationRS> localVarReturnType = new ParameterizedTypeReference<BookingCancellationRS>() {};
        return bookingCancellationRequestCreation(accept, acceptEncoding, bookingId, cancellationFlag, language).bodyToMono(localVarReturnType);
    }

    /**
     * Booking cancellation
     * BookingCancellation is used either to simulate a cancellation or to perform the actual cancellation.Cancellations always take into account day and time of the destination in order to calculate what cancellation policy should be applied. Timeout for this operation is 60 seconds.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function.  Format: XXX-YYYYYY
     * @param cancellationFlag Type of cancellation method to be used.
     * @param language Language in which the description texts will be returned in the response
     * @return ResponseEntity&lt;BookingCancellationRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingCancellationRS>> bookingCancellationWithHttpInfo(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellationRS> localVarReturnType = new ParameterizedTypeReference<BookingCancellationRS>() {};
        return bookingCancellationRequestCreation(accept, acceptEncoding, bookingId, cancellationFlag, language).toEntity(localVarReturnType);
    }

    /**
     * Booking cancellation
     * BookingCancellation is used either to simulate a cancellation or to perform the actual cancellation.Cancellations always take into account day and time of the destination in order to calculate what cancellation policy should be applied. Timeout for this operation is 60 seconds.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function.  Format: XXX-YYYYYY
     * @param cancellationFlag Type of cancellation method to be used.
     * @param language Language in which the description texts will be returned in the response
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bookingCancellationWithResponseSpec(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        return bookingCancellationRequestCreation(accept, acceptEncoding, bookingId, cancellationFlag, language);
    }
    /**
     * Booking change
     * The BookingChange operation is used to change or update different values of a booking.  The changes that can be performed are:  * Change clientReference * Change remarks * Change holder name and surname * Change checkIn and checkOut date * Change board plans * Change passengers name and surname * Add rooms (only from the same type already in the booking) * Remove rooms from a booking (partial cancellation) 
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  * *BOOKING CHANGE* - Error during cancellation, the booking XXX-YYYYY is locked. Please try again later.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param body Definition and examples of request body of BookingChange operation
     * @return BookingChangeRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bookingChangeRequestCreation(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingId' is set
        if (bookingId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingId' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingId", bookingId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json", "application/xml"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<BookingChangeRS> localVarReturnType = new ParameterizedTypeReference<BookingChangeRS>() {};
        return apiClient.invokeAPI("/bookings/{bookingId}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Booking change
     * The BookingChange operation is used to change or update different values of a booking.  The changes that can be performed are:  * Change clientReference * Change remarks * Change holder name and surname * Change checkIn and checkOut date * Change board plans * Change passengers name and surname * Add rooms (only from the same type already in the booking) * Remove rooms from a booking (partial cancellation) 
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  * *BOOKING CHANGE* - Error during cancellation, the booking XXX-YYYYY is locked. Please try again later.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param body Definition and examples of request body of BookingChange operation
     * @return BookingChangeRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingChangeRS> bookingChange(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingChangeRS> localVarReturnType = new ParameterizedTypeReference<BookingChangeRS>() {};
        return bookingChangeRequestCreation(accept, acceptEncoding, contentType, bookingId, body).bodyToMono(localVarReturnType);
    }

    /**
     * Booking change
     * The BookingChange operation is used to change or update different values of a booking.  The changes that can be performed are:  * Change clientReference * Change remarks * Change holder name and surname * Change checkIn and checkOut date * Change board plans * Change passengers name and surname * Add rooms (only from the same type already in the booking) * Remove rooms from a booking (partial cancellation) 
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  * *BOOKING CHANGE* - Error during cancellation, the booking XXX-YYYYY is locked. Please try again later.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param body Definition and examples of request body of BookingChange operation
     * @return ResponseEntity&lt;BookingChangeRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingChangeRS>> bookingChangeWithHttpInfo(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingChangeRS> localVarReturnType = new ParameterizedTypeReference<BookingChangeRS>() {};
        return bookingChangeRequestCreation(accept, acceptEncoding, contentType, bookingId, body).toEntity(localVarReturnType);
    }

    /**
     * Booking change
     * The BookingChange operation is used to change or update different values of a booking.  The changes that can be performed are:  * Change clientReference * Change remarks * Change holder name and surname * Change checkIn and checkOut date * Change board plans * Change passengers name and surname * Add rooms (only from the same type already in the booking) * Remove rooms from a booking (partial cancellation) 
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>402</b> - **PAYMENT** * The parameters were valid but the request failed.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  * *BOOKING CHANGE* - Error during cancellation, the booking XXX-YYYYY is locked. Please try again later.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param body Definition and examples of request body of BookingChange operation
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bookingChangeWithResponseSpec(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        return bookingChangeRequestCreation(accept, acceptEncoding, contentType, bookingId, body);
    }
    /**
     * Booking detail
     * The BookingDetail operation allows to retrieve a booking with all its details from the booking reference locator.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param language Language code that defines the language of the response. English will be used by default if this parameter is not informed.
     * @return BookingDetailRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bookingDetailRequestCreation(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingDetail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingDetail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingId' is set
        if (bookingId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingId' when calling bookingDetail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingId", bookingId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<BookingDetailRS> localVarReturnType = new ParameterizedTypeReference<BookingDetailRS>() {};
        return apiClient.invokeAPI("/bookings/{bookingId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Booking detail
     * The BookingDetail operation allows to retrieve a booking with all its details from the booking reference locator.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param language Language code that defines the language of the response. English will be used by default if this parameter is not informed.
     * @return BookingDetailRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingDetailRS> bookingDetail(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingDetailRS> localVarReturnType = new ParameterizedTypeReference<BookingDetailRS>() {};
        return bookingDetailRequestCreation(accept, acceptEncoding, bookingId, language).bodyToMono(localVarReturnType);
    }

    /**
     * Booking detail
     * The BookingDetail operation allows to retrieve a booking with all its details from the booking reference locator.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param language Language code that defines the language of the response. English will be used by default if this parameter is not informed.
     * @return ResponseEntity&lt;BookingDetailRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingDetailRS>> bookingDetailWithHttpInfo(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingDetailRS> localVarReturnType = new ParameterizedTypeReference<BookingDetailRS>() {};
        return bookingDetailRequestCreation(accept, acceptEncoding, bookingId, language).toEntity(localVarReturnType);
    }

    /**
     * Booking detail
     * The BookingDetail operation allows to retrieve a booking with all its details from the booking reference locator.
     * <p><b>200</b> - Sample
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param bookingId Booking reference number taken from the confirmation response or from the booking list function. Format: XXX-YYYYYY
     * @param language Language code that defines the language of the response. English will be used by default if this parameter is not informed.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bookingDetailWithResponseSpec(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        return bookingDetailRequestCreation(accept, acceptEncoding, bookingId, language);
    }
    /**
     * Booking list
     * The booking list operation returns a list of bookings based on the search criteria. The most important information returned for each booking in the list is:    *  Booking reference   *  Booking holder   *  Booking paxes   *  Hotel, rooms and boards confirmed   *  Booking rates    The results are returned in a paginated response that can be filtered with the use of parameters in the request.  Timeout for this operation is 60 seconds. 
     * <p><b>200</b> - Sucessful response
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param from Defines the lowest value of the range of bookings to be returned.
     * @param to Defines the highest value of the range of bookings to be returned.
     * @param start Defines the starting date of the range of bookings to be returned.
     * @param end Defines the ending date of the range of bookings to be returned. value.
     * @param filterType Parameter used to define wether **start** and **end** fields are filtering by check-in date or by booking creation date.
     * @param status Parameter used to filter results by status. Can be used to include or exclude cancelled bookings.
     * @param clientReference Parameter to filter the result by the __clientReference__ field of the booking.
     * @param creationUser Parameter to filter the result by the creationUser field of the booking.
     * @param country Parameter to filter the results by the country code of the hotel. Can include multiple values separated by commas.
     * @param destination Parameter to filter the results by the destination code of the hotel. Can include multiple values separated by commas.
     * @param hotel Parameter to filter the results by the hotel codes. Can include multiple values separated by commas.
     * @return BookingListRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bookingListRequestCreation(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'from' is set
        if (from == null) {
            throw new WebClientResponseException("Missing the required parameter 'from' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'to' is set
        if (to == null) {
            throw new WebClientResponseException("Missing the required parameter 'to' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'start' is set
        if (start == null) {
            throw new WebClientResponseException("Missing the required parameter 'start' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'end' is set
        if (end == null) {
            throw new WebClientResponseException("Missing the required parameter 'end' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "filterType", filterType));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "status", status));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "clientReference", clientReference));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "creationUser", creationUser));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "country", country));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "destination", destination));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "hotel", hotel));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "end", end));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<BookingListRS> localVarReturnType = new ParameterizedTypeReference<BookingListRS>() {};
        return apiClient.invokeAPI("/bookings", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Booking list
     * The booking list operation returns a list of bookings based on the search criteria. The most important information returned for each booking in the list is:    *  Booking reference   *  Booking holder   *  Booking paxes   *  Hotel, rooms and boards confirmed   *  Booking rates    The results are returned in a paginated response that can be filtered with the use of parameters in the request.  Timeout for this operation is 60 seconds. 
     * <p><b>200</b> - Sucessful response
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param from Defines the lowest value of the range of bookings to be returned.
     * @param to Defines the highest value of the range of bookings to be returned.
     * @param start Defines the starting date of the range of bookings to be returned.
     * @param end Defines the ending date of the range of bookings to be returned. value.
     * @param filterType Parameter used to define wether **start** and **end** fields are filtering by check-in date or by booking creation date.
     * @param status Parameter used to filter results by status. Can be used to include or exclude cancelled bookings.
     * @param clientReference Parameter to filter the result by the __clientReference__ field of the booking.
     * @param creationUser Parameter to filter the result by the creationUser field of the booking.
     * @param country Parameter to filter the results by the country code of the hotel. Can include multiple values separated by commas.
     * @param destination Parameter to filter the results by the destination code of the hotel. Can include multiple values separated by commas.
     * @param hotel Parameter to filter the results by the hotel codes. Can include multiple values separated by commas.
     * @return BookingListRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingListRS> bookingList(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        ParameterizedTypeReference<BookingListRS> localVarReturnType = new ParameterizedTypeReference<BookingListRS>() {};
        return bookingListRequestCreation(accept, acceptEncoding, contentType, from, to, start, end, filterType, status, clientReference, creationUser, country, destination, hotel).bodyToMono(localVarReturnType);
    }

    /**
     * Booking list
     * The booking list operation returns a list of bookings based on the search criteria. The most important information returned for each booking in the list is:    *  Booking reference   *  Booking holder   *  Booking paxes   *  Hotel, rooms and boards confirmed   *  Booking rates    The results are returned in a paginated response that can be filtered with the use of parameters in the request.  Timeout for this operation is 60 seconds. 
     * <p><b>200</b> - Sucessful response
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param from Defines the lowest value of the range of bookings to be returned.
     * @param to Defines the highest value of the range of bookings to be returned.
     * @param start Defines the starting date of the range of bookings to be returned.
     * @param end Defines the ending date of the range of bookings to be returned. value.
     * @param filterType Parameter used to define wether **start** and **end** fields are filtering by check-in date or by booking creation date.
     * @param status Parameter used to filter results by status. Can be used to include or exclude cancelled bookings.
     * @param clientReference Parameter to filter the result by the __clientReference__ field of the booking.
     * @param creationUser Parameter to filter the result by the creationUser field of the booking.
     * @param country Parameter to filter the results by the country code of the hotel. Can include multiple values separated by commas.
     * @param destination Parameter to filter the results by the destination code of the hotel. Can include multiple values separated by commas.
     * @param hotel Parameter to filter the results by the hotel codes. Can include multiple values separated by commas.
     * @return ResponseEntity&lt;BookingListRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingListRS>> bookingListWithHttpInfo(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        ParameterizedTypeReference<BookingListRS> localVarReturnType = new ParameterizedTypeReference<BookingListRS>() {};
        return bookingListRequestCreation(accept, acceptEncoding, contentType, from, to, start, end, filterType, status, clientReference, creationUser, country, destination, hotel).toEntity(localVarReturnType);
    }

    /**
     * Booking list
     * The booking list operation returns a list of bookings based on the search criteria. The most important information returned for each booking in the list is:    *  Booking reference   *  Booking holder   *  Booking paxes   *  Hotel, rooms and boards confirmed   *  Booking rates    The results are returned in a paginated response that can be filtered with the use of parameters in the request.  Timeout for this operation is 60 seconds. 
     * <p><b>200</b> - Sucessful response
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param from Defines the lowest value of the range of bookings to be returned.
     * @param to Defines the highest value of the range of bookings to be returned.
     * @param start Defines the starting date of the range of bookings to be returned.
     * @param end Defines the ending date of the range of bookings to be returned. value.
     * @param filterType Parameter used to define wether **start** and **end** fields are filtering by check-in date or by booking creation date.
     * @param status Parameter used to filter results by status. Can be used to include or exclude cancelled bookings.
     * @param clientReference Parameter to filter the result by the __clientReference__ field of the booking.
     * @param creationUser Parameter to filter the result by the creationUser field of the booking.
     * @param country Parameter to filter the results by the country code of the hotel. Can include multiple values separated by commas.
     * @param destination Parameter to filter the results by the destination code of the hotel. Can include multiple values separated by commas.
     * @param hotel Parameter to filter the results by the hotel codes. Can include multiple values separated by commas.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bookingListWithResponseSpec(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        return bookingListRequestCreation(accept, acceptEncoding, contentType, from, to, start, end, filterType, status, clientReference, creationUser, country, destination, hotel);
    }
    /**
     * Booking reconfirmation
     * The Reconfirmation operation allows to retrieve the reconfirmation numbers (The confirmation number of the Hotel, both for the Hotelbeds product and for that of external suppliers product) of the bookings made by the client when requested in a GET call to our endpoint.  Obtaining this reconfirmation numbers from hoteliers is an __asynchronous__ service: **reconfirmation numbers are not available at the time of the booking**, and as such they can&#39;t be informed at the time of the booking, hence the need for this operation.  The Reconfirmation operation offers a wide variety of filters to help narrowing down reconfirmation number results. Only one filter can be used at the same time. Below the four possible filters you can use:  * between two cheking dates * between two reconfirmation dates * list of clientReference ids * list of booking Ids  ## Reconfirmation Service  Additionally we offer you the capacity to receive the reconfirmation numbers automatically in our reconformation service, designed to automatically send you the reconfirmation information as soon as is available from the hoteliers in two different ways:  * [Push Service](/documentation/hotels/booking-api/reconfirmation-service/push-service/) : The messages will be automatically sent in JSON format to an endpoint of your choice. * [Email Service](/documentation/hotels/booking-api/reconfirmation-service/email-service/): The messages will be automatically sent in an email to an address of your choice.  Contact our support team at [apitude@hotelbeds.com]() to learn more about this features.
     * <p><b>200</b> - Sucessful response
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param from Lowest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param to Highest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param start Date from when the method will start checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param end Date to when the method will finish checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param filterType The parameter is used to identify if the reconfirmation numbers is by check-in date or by reconfirmation date. Values:  * CHECKIN: for the check-in date. * RECONFIRMATION: for the reconfirmation date the booking was included in Hotelbeds systems.  In case of using __filterType__ parameters, the use of __start__ and __end__ parameters is mandatory.
     * @param clientReferences Parameter to filter the results by the booking reference in client API side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @param references Parameter to filter the results by the booking reference in Hotelbeds side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bookingreconfirmationRequestCreation(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'from' is set
        if (from == null) {
            throw new WebClientResponseException("Missing the required parameter 'from' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'to' is set
        if (to == null) {
            throw new WebClientResponseException("Missing the required parameter 'to' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "end", end));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "filterType", filterType));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "clientReferences", clientReferences));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "references", references));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/bookings/reconfirmations", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Booking reconfirmation
     * The Reconfirmation operation allows to retrieve the reconfirmation numbers (The confirmation number of the Hotel, both for the Hotelbeds product and for that of external suppliers product) of the bookings made by the client when requested in a GET call to our endpoint.  Obtaining this reconfirmation numbers from hoteliers is an __asynchronous__ service: **reconfirmation numbers are not available at the time of the booking**, and as such they can&#39;t be informed at the time of the booking, hence the need for this operation.  The Reconfirmation operation offers a wide variety of filters to help narrowing down reconfirmation number results. Only one filter can be used at the same time. Below the four possible filters you can use:  * between two cheking dates * between two reconfirmation dates * list of clientReference ids * list of booking Ids  ## Reconfirmation Service  Additionally we offer you the capacity to receive the reconfirmation numbers automatically in our reconformation service, designed to automatically send you the reconfirmation information as soon as is available from the hoteliers in two different ways:  * [Push Service](/documentation/hotels/booking-api/reconfirmation-service/push-service/) : The messages will be automatically sent in JSON format to an endpoint of your choice. * [Email Service](/documentation/hotels/booking-api/reconfirmation-service/email-service/): The messages will be automatically sent in an email to an address of your choice.  Contact our support team at [apitude@hotelbeds.com]() to learn more about this features.
     * <p><b>200</b> - Sucessful response
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param from Lowest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param to Highest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param start Date from when the method will start checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param end Date to when the method will finish checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param filterType The parameter is used to identify if the reconfirmation numbers is by check-in date or by reconfirmation date. Values:  * CHECKIN: for the check-in date. * RECONFIRMATION: for the reconfirmation date the booking was included in Hotelbeds systems.  In case of using __filterType__ parameters, the use of __start__ and __end__ parameters is mandatory.
     * @param clientReferences Parameter to filter the results by the booking reference in client API side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @param references Parameter to filter the results by the booking reference in Hotelbeds side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> bookingreconfirmation(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return bookingreconfirmationRequestCreation(accept, acceptEncoding, from, to, start, end, filterType, clientReferences, references).bodyToMono(localVarReturnType);
    }

    /**
     * Booking reconfirmation
     * The Reconfirmation operation allows to retrieve the reconfirmation numbers (The confirmation number of the Hotel, both for the Hotelbeds product and for that of external suppliers product) of the bookings made by the client when requested in a GET call to our endpoint.  Obtaining this reconfirmation numbers from hoteliers is an __asynchronous__ service: **reconfirmation numbers are not available at the time of the booking**, and as such they can&#39;t be informed at the time of the booking, hence the need for this operation.  The Reconfirmation operation offers a wide variety of filters to help narrowing down reconfirmation number results. Only one filter can be used at the same time. Below the four possible filters you can use:  * between two cheking dates * between two reconfirmation dates * list of clientReference ids * list of booking Ids  ## Reconfirmation Service  Additionally we offer you the capacity to receive the reconfirmation numbers automatically in our reconformation service, designed to automatically send you the reconfirmation information as soon as is available from the hoteliers in two different ways:  * [Push Service](/documentation/hotels/booking-api/reconfirmation-service/push-service/) : The messages will be automatically sent in JSON format to an endpoint of your choice. * [Email Service](/documentation/hotels/booking-api/reconfirmation-service/email-service/): The messages will be automatically sent in an email to an address of your choice.  Contact our support team at [apitude@hotelbeds.com]() to learn more about this features.
     * <p><b>200</b> - Sucessful response
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param from Lowest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param to Highest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param start Date from when the method will start checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param end Date to when the method will finish checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param filterType The parameter is used to identify if the reconfirmation numbers is by check-in date or by reconfirmation date. Values:  * CHECKIN: for the check-in date. * RECONFIRMATION: for the reconfirmation date the booking was included in Hotelbeds systems.  In case of using __filterType__ parameters, the use of __start__ and __end__ parameters is mandatory.
     * @param clientReferences Parameter to filter the results by the booking reference in client API side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @param references Parameter to filter the results by the booking reference in Hotelbeds side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Void>> bookingreconfirmationWithHttpInfo(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return bookingreconfirmationRequestCreation(accept, acceptEncoding, from, to, start, end, filterType, clientReferences, references).toEntity(localVarReturnType);
    }

    /**
     * Booking reconfirmation
     * The Reconfirmation operation allows to retrieve the reconfirmation numbers (The confirmation number of the Hotel, both for the Hotelbeds product and for that of external suppliers product) of the bookings made by the client when requested in a GET call to our endpoint.  Obtaining this reconfirmation numbers from hoteliers is an __asynchronous__ service: **reconfirmation numbers are not available at the time of the booking**, and as such they can&#39;t be informed at the time of the booking, hence the need for this operation.  The Reconfirmation operation offers a wide variety of filters to help narrowing down reconfirmation number results. Only one filter can be used at the same time. Below the four possible filters you can use:  * between two cheking dates * between two reconfirmation dates * list of clientReference ids * list of booking Ids  ## Reconfirmation Service  Additionally we offer you the capacity to receive the reconfirmation numbers automatically in our reconformation service, designed to automatically send you the reconfirmation information as soon as is available from the hoteliers in two different ways:  * [Push Service](/documentation/hotels/booking-api/reconfirmation-service/push-service/) : The messages will be automatically sent in JSON format to an endpoint of your choice. * [Email Service](/documentation/hotels/booking-api/reconfirmation-service/email-service/): The messages will be automatically sent in an email to an address of your choice.  Contact our support team at [apitude@hotelbeds.com]() to learn more about this features.
     * <p><b>200</b> - Sucessful response
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param from Lowest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param to Highest value of the range of bookings with supplierConfirmationCodes to be returned (as in a paginated response).
     * @param start Date from when the method will start checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param end Date to when the method will finish checking reconfirmation numbers. The format must be YYYY-MM-DD. In case of using __start__ and __end__ parameters, the use of __filterType__ parameter is mandatory.
     * @param filterType The parameter is used to identify if the reconfirmation numbers is by check-in date or by reconfirmation date. Values:  * CHECKIN: for the check-in date. * RECONFIRMATION: for the reconfirmation date the booking was included in Hotelbeds systems.  In case of using __filterType__ parameters, the use of __start__ and __end__ parameters is mandatory.
     * @param clientReferences Parameter to filter the results by the booking reference in client API side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @param references Parameter to filter the results by the booking reference in Hotelbeds side.Can include multiple values separated by \&quot;,\&quot;. Max 80 values.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bookingreconfirmationWithResponseSpec(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        return bookingreconfirmationRequestCreation(accept, acceptEncoding, from, to, start, end, filterType, clientReferences, references);
    }
}
