package travel.wink.hotelbeds.booking.sdk.api;

import travel.wink.hotelbeds.booking.sdk.invoker.ApiClient;

import travel.wink.hotelbeds.booking.sdk.model.CheckRateRQ;
import travel.wink.hotelbeds.booking.sdk.model.CheckRateRS;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class CheckRateApi {
    private ApiClient apiClient;

    public CheckRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public CheckRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Check rate
     * CheckRate is an _optional_ operation used to assess and valuate the rate before the actual booking. CheckRate returns the same information as the Availability response for a hotel rate with up-to-date price, along with additional information regarding the rate: rate breakdown, rate comments and upselling options.  The CheckRate method can complement the booking process, as it returns additional information to the availability request. However, when the rateType value is &#39;RECHECK&#39;, the CheckRate method is mandatory.  Besides the details for the rate, CheckRate has the option to also return information of higher rates of the same hotel being checked. This is called Upselling.  Upselling returns additional room options, each with its own rate key, allowing you to upgrade the stay quality in room category and rate plan even after the CheckRate operation has been performed.  Timeout for this operation is 15 seconds. 
     * <p><b>200</b> - Successful operation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of CheckRate operation
     * @return CheckRateRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec checkRateRequestCreation(String accept, String acceptEncoding, String contentType, CheckRateRQ body) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling checkRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling checkRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling checkRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling checkRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json", "application/xml"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<CheckRateRS> localVarReturnType = new ParameterizedTypeReference<CheckRateRS>() {};
        return apiClient.invokeAPI("/checkrates", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Check rate
     * CheckRate is an _optional_ operation used to assess and valuate the rate before the actual booking. CheckRate returns the same information as the Availability response for a hotel rate with up-to-date price, along with additional information regarding the rate: rate breakdown, rate comments and upselling options.  The CheckRate method can complement the booking process, as it returns additional information to the availability request. However, when the rateType value is &#39;RECHECK&#39;, the CheckRate method is mandatory.  Besides the details for the rate, CheckRate has the option to also return information of higher rates of the same hotel being checked. This is called Upselling.  Upselling returns additional room options, each with its own rate key, allowing you to upgrade the stay quality in room category and rate plan even after the CheckRate operation has been performed.  Timeout for this operation is 15 seconds. 
     * <p><b>200</b> - Successful operation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of CheckRate operation
     * @return CheckRateRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CheckRateRS> checkRate(String accept, String acceptEncoding, String contentType, CheckRateRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<CheckRateRS> localVarReturnType = new ParameterizedTypeReference<CheckRateRS>() {};
        return checkRateRequestCreation(accept, acceptEncoding, contentType, body).bodyToMono(localVarReturnType);
    }

    /**
     * Check rate
     * CheckRate is an _optional_ operation used to assess and valuate the rate before the actual booking. CheckRate returns the same information as the Availability response for a hotel rate with up-to-date price, along with additional information regarding the rate: rate breakdown, rate comments and upselling options.  The CheckRate method can complement the booking process, as it returns additional information to the availability request. However, when the rateType value is &#39;RECHECK&#39;, the CheckRate method is mandatory.  Besides the details for the rate, CheckRate has the option to also return information of higher rates of the same hotel being checked. This is called Upselling.  Upselling returns additional room options, each with its own rate key, allowing you to upgrade the stay quality in room category and rate plan even after the CheckRate operation has been performed.  Timeout for this operation is 15 seconds. 
     * <p><b>200</b> - Successful operation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of CheckRate operation
     * @return ResponseEntity&lt;CheckRateRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CheckRateRS>> checkRateWithHttpInfo(String accept, String acceptEncoding, String contentType, CheckRateRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<CheckRateRS> localVarReturnType = new ParameterizedTypeReference<CheckRateRS>() {};
        return checkRateRequestCreation(accept, acceptEncoding, contentType, body).toEntity(localVarReturnType);
    }

    /**
     * Check rate
     * CheckRate is an _optional_ operation used to assess and valuate the rate before the actual booking. CheckRate returns the same information as the Availability response for a hotel rate with up-to-date price, along with additional information regarding the rate: rate breakdown, rate comments and upselling options.  The CheckRate method can complement the booking process, as it returns additional information to the availability request. However, when the rateType value is &#39;RECHECK&#39;, the CheckRate method is mandatory.  Besides the details for the rate, CheckRate has the option to also return information of higher rates of the same hotel being checked. This is called Upselling.  Upselling returns additional room options, each with its own rate key, allowing you to upgrade the stay quality in room category and rate plan even after the CheckRate operation has been performed.  Timeout for this operation is 15 seconds. 
     * <p><b>200</b> - Successful operation.
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.  *ALLOTMENT EXCEEDED*
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.  * Authorization field missing  * Request signature verification failed
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>406</b> - **NOT ACCEPTABLE** - The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.
     * <p><b>410</b> - error repeated
     * <p><b>415</b> - **UNSUPPORTED MEDIA TYPE** - Use the Content-Type header to set application/json and be sure the format of your payload matches the format
     * <p><b>429</b> - **Rate limit exceeded** - The user has sent too many requests in a given amount of time.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *PRODUCT_ERROR* - This type of error is produced due to product restrictions or due to other account set-up limitations. In all cases, the end result is that the booking cannot be confirmed. Here is a list of common product errors:  * *Insufficient allotment*: This means that the user is trying to book a room which is no longer available. This may happen if the room was still available in the Availability stage but someone else has made a reservation for this room or rooms. * *Price has increased*: The price increase between booking steps has exceeded the allowed tolerance that was set. This is a setting to protect clients from booking a room with a higher price than expected. * *Contract is closed/Office or branch not active/Cannot find channel quotation*: There are problems related to the contract. * *Stop sales*: This means that the hotel is forbidding sales on the requested dates. * *Booking confirmation error XXX-YYYYYY*: A confirmation error occurred. Please try again later.  * *Release violated*  * *There&#39;s a stop sales for the date/s*   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * @param accept Response format.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param contentType Defines request format.
     * @param body Definition and examples of request body of CheckRate operation
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec checkRateWithResponseSpec(String accept, String acceptEncoding, String contentType, CheckRateRQ body) throws WebClientResponseException {
        return checkRateRequestCreation(accept, acceptEncoding, contentType, body);
    }
}
