/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Filter for board types.
 */
@JsonPropertyOrder({
  ApiBoards.JSON_PROPERTY_BOARD,
  ApiBoards.JSON_PROPERTY_INCLUDED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiBoards {
  public static final String JSON_PROPERTY_BOARD = "board";
  private List<String> board = new ArrayList<>();

  public static final String JSON_PROPERTY_INCLUDED = "included";
  private Boolean included = false;

  public ApiBoards() {
  }

  public ApiBoards board(List<String> board) {
    
    this.board = board;
    return this;
  }

  public ApiBoards addBoardItem(String boardItem) {
    if (this.board == null) {
      this.board = new ArrayList<>();
    }
    this.board.add(boardItem);
    return this;
  }

   /**
   * List of board type codes to filter by. You can get all the possible board type code values through the board types operation of [Hotel Content API](/documentation/hotels/content-api/api-reference/).
   * @return board
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getBoard() {
    return board;
  }


  @JsonProperty(JSON_PROPERTY_BOARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBoard(List<String> board) {
    this.board = board;
  }


  public ApiBoards included(Boolean included) {
    
    this.included = included;
    return this;
  }

   /**
   * Includes or excludes the listed board types from the response.
   * @return included
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIncluded() {
    return included;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncluded(Boolean included) {
    this.included = included;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiBoards apiBoards = (ApiBoards) o;
    return Objects.equals(this.board, apiBoards.board) &&
        Objects.equals(this.included, apiBoards.included);
  }

  @Override
  public int hashCode() {
    return Objects.hash(board, included);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiBoards {\n");
    sb.append("    board: ").append(toIndentedString(board)).append("\n");
    sb.append("    included: ").append(toIndentedString(included)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

