/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import travel.wink.hotelbeds.booking.sdk.model.ApiHolder;
import travel.wink.hotelbeds.booking.sdk.model.ApiHotel;
import travel.wink.hotelbeds.booking.sdk.model.ApiModificationPolicies;
import travel.wink.hotelbeds.booking.sdk.model.ApiReceptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The Booking object. Contains all data related with the booking itself.
 */
@JsonPropertyOrder({
  ApiBooking.JSON_PROPERTY_REFERENCE,
  ApiBooking.JSON_PROPERTY_CANCELLATION_REFERENCE,
  ApiBooking.JSON_PROPERTY_CLIENT_REFERENCE,
  ApiBooking.JSON_PROPERTY_CREATION_DATE,
  ApiBooking.JSON_PROPERTY_STATUS,
  ApiBooking.JSON_PROPERTY_MODIFICATION_POLICIES,
  ApiBooking.JSON_PROPERTY_AG_COMMISION,
  ApiBooking.JSON_PROPERTY_COMMISION_V_A_T,
  ApiBooking.JSON_PROPERTY_CREATION_USER,
  ApiBooking.JSON_PROPERTY_HOLDER,
  ApiBooking.JSON_PROPERTY_REMARK,
  ApiBooking.JSON_PROPERTY_INVOICE_COMPANY,
  ApiBooking.JSON_PROPERTY_TOTAL_SELLING_RATE,
  ApiBooking.JSON_PROPERTY_TOTAL_NET,
  ApiBooking.JSON_PROPERTY_PENDING_AMOUNT,
  ApiBooking.JSON_PROPERTY_CURRENCY,
  ApiBooking.JSON_PROPERTY_HOTEL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiBooking {
  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_CANCELLATION_REFERENCE = "cancellationReference";
  private String cancellationReference;

  public static final String JSON_PROPERTY_CLIENT_REFERENCE = "clientReference";
  private String clientReference;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private LocalDate creationDate;

  /**
   * Current status of the booking.
   */
  public enum StatusEnum {
    CONFIRMED("CONFIRMED"),
    
    CANCELLED("CANCELLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_MODIFICATION_POLICIES = "modificationPolicies";
  private ApiModificationPolicies modificationPolicies;

  public static final String JSON_PROPERTY_AG_COMMISION = "agCommision";
  private String agCommision;

  public static final String JSON_PROPERTY_COMMISION_V_A_T = "commisionVAT";
  private String commisionVAT;

  public static final String JSON_PROPERTY_CREATION_USER = "creationUser";
  private String creationUser;

  public static final String JSON_PROPERTY_HOLDER = "holder";
  private ApiHolder holder;

  public static final String JSON_PROPERTY_REMARK = "remark";
  private String remark;

  public static final String JSON_PROPERTY_INVOICE_COMPANY = "invoiceCompany";
  private ApiReceptive invoiceCompany;

  public static final String JSON_PROPERTY_TOTAL_SELLING_RATE = "totalSellingRate";
  private BigDecimal totalSellingRate;

  public static final String JSON_PROPERTY_TOTAL_NET = "totalNet";
  private BigDecimal totalNet;

  public static final String JSON_PROPERTY_PENDING_AMOUNT = "pendingAmount";
  private BigDecimal pendingAmount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private ApiHotel hotel;

  public ApiBooking() {
  }

  public ApiBooking reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Booking locator. Format: XXXXXXXX-XXXXXXXX
   * @return reference
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public ApiBooking cancellationReference(String cancellationReference) {
    
    this.cancellationReference = cancellationReference;
    return this;
  }

   /**
   * Unique cancellation reference. Only appears for cancelled bookings.
   * @return cancellationReference
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellationReference() {
    return cancellationReference;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationReference(String cancellationReference) {
    this.cancellationReference = cancellationReference;
  }


  public ApiBooking clientReference(String clientReference) {
    
    this.clientReference = clientReference;
    return this;
  }

   /**
   * Client internal booking reference.
   * @return clientReference
  **/
  @jakarta.annotation.Nullable
 @Size(min=1,max=20)
  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientReference() {
    return clientReference;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientReference(String clientReference) {
    this.clientReference = clientReference;
  }


  public ApiBooking creationDate(LocalDate creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * Booking creation date.
   * @return creationDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCreationDate() {
    return creationDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(LocalDate creationDate) {
    this.creationDate = creationDate;
  }


  public ApiBooking status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Current status of the booking.
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public ApiBooking modificationPolicies(ApiModificationPolicies modificationPolicies) {
    
    this.modificationPolicies = modificationPolicies;
    return this;
  }

   /**
   * Get modificationPolicies
   * @return modificationPolicies
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFICATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiModificationPolicies getModificationPolicies() {
    return modificationPolicies;
  }


  @JsonProperty(JSON_PROPERTY_MODIFICATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationPolicies(ApiModificationPolicies modificationPolicies) {
    this.modificationPolicies = modificationPolicies;
  }


  public ApiBooking agCommision(String agCommision) {
    
    this.agCommision = agCommision;
    return this;
  }

   /**
   * Get agCommision
   * @return agCommision
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AG_COMMISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAgCommision() {
    return agCommision;
  }


  @JsonProperty(JSON_PROPERTY_AG_COMMISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgCommision(String agCommision) {
    this.agCommision = agCommision;
  }


  public ApiBooking commisionVAT(String commisionVAT) {
    
    this.commisionVAT = commisionVAT;
    return this;
  }

   /**
   * Share of the commission corresponding to the Value Added Tax.
   * @return commisionVAT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommisionVAT() {
    return commisionVAT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommisionVAT(String commisionVAT) {
    this.commisionVAT = commisionVAT;
  }


  public ApiBooking creationUser(String creationUser) {
    
    this.creationUser = creationUser;
    return this;
  }

   /**
   * The apiKey used to create the booking.
   * @return creationUser
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATION_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationUser() {
    return creationUser;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationUser(String creationUser) {
    this.creationUser = creationUser;
  }


  public ApiBooking holder(ApiHolder holder) {
    
    this.holder = holder;
    return this;
  }

   /**
   * Get holder
   * @return holder
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiHolder getHolder() {
    return holder;
  }


  @JsonProperty(JSON_PROPERTY_HOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHolder(ApiHolder holder) {
    this.holder = holder;
  }


  public ApiBooking remark(String remark) {
    
    this.remark = remark;
    return this;
  }

   /**
   * Free text that is sent to the hotelier as a comment from the client. It can be used to request or inform of special requests to hotelier like: “Non-smoking room preferred, Twin bed please, Upper floor preferred, Late arrival...”
   * @return remark
  **/
  @jakarta.annotation.Nullable
 @Size(min=0,max=2000)
  @JsonProperty(JSON_PROPERTY_REMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRemark() {
    return remark;
  }


  @JsonProperty(JSON_PROPERTY_REMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemark(String remark) {
    this.remark = remark;
  }


  public ApiBooking invoiceCompany(ApiReceptive invoiceCompany) {
    
    this.invoiceCompany = invoiceCompany;
    return this;
  }

   /**
   * Get invoiceCompany
   * @return invoiceCompany
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INVOICE_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiReceptive getInvoiceCompany() {
    return invoiceCompany;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoiceCompany(ApiReceptive invoiceCompany) {
    this.invoiceCompany = invoiceCompany;
  }


  public ApiBooking totalSellingRate(BigDecimal totalSellingRate) {
    
    this.totalSellingRate = totalSellingRate;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalSellingRate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotalSellingRate() {
    return totalSellingRate;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSellingRate(BigDecimal totalSellingRate) {
    this.totalSellingRate = totalSellingRate;
  }


  public ApiBooking totalNet(BigDecimal totalNet) {
    
    this.totalNet = totalNet;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalNet
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotalNet() {
    return totalNet;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalNet(BigDecimal totalNet) {
    this.totalNet = totalNet;
  }


  public ApiBooking pendingAmount(BigDecimal pendingAmount) {
    
    this.pendingAmount = pendingAmount;
    return this;
  }

   /**
   * Remaining amount to be paid.
   * @return pendingAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PENDING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPendingAmount() {
    return pendingAmount;
  }


  @JsonProperty(JSON_PROPERTY_PENDING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPendingAmount(BigDecimal pendingAmount) {
    this.pendingAmount = pendingAmount;
  }


  public ApiBooking currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency of the monetary amount.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public ApiBooking hotel(ApiHotel hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiHotel getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(ApiHotel hotel) {
    this.hotel = hotel;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiBooking apiBooking = (ApiBooking) o;
    return Objects.equals(this.reference, apiBooking.reference) &&
        Objects.equals(this.cancellationReference, apiBooking.cancellationReference) &&
        Objects.equals(this.clientReference, apiBooking.clientReference) &&
        Objects.equals(this.creationDate, apiBooking.creationDate) &&
        Objects.equals(this.status, apiBooking.status) &&
        Objects.equals(this.modificationPolicies, apiBooking.modificationPolicies) &&
        Objects.equals(this.agCommision, apiBooking.agCommision) &&
        Objects.equals(this.commisionVAT, apiBooking.commisionVAT) &&
        Objects.equals(this.creationUser, apiBooking.creationUser) &&
        Objects.equals(this.holder, apiBooking.holder) &&
        Objects.equals(this.remark, apiBooking.remark) &&
        Objects.equals(this.invoiceCompany, apiBooking.invoiceCompany) &&
        Objects.equals(this.totalSellingRate, apiBooking.totalSellingRate) &&
        Objects.equals(this.totalNet, apiBooking.totalNet) &&
        Objects.equals(this.pendingAmount, apiBooking.pendingAmount) &&
        Objects.equals(this.currency, apiBooking.currency) &&
        Objects.equals(this.hotel, apiBooking.hotel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reference, cancellationReference, clientReference, creationDate, status, modificationPolicies, agCommision, commisionVAT, creationUser, holder, remark, invoiceCompany, totalSellingRate, totalNet, pendingAmount, currency, hotel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiBooking {\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    cancellationReference: ").append(toIndentedString(cancellationReference)).append("\n");
    sb.append("    clientReference: ").append(toIndentedString(clientReference)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    modificationPolicies: ").append(toIndentedString(modificationPolicies)).append("\n");
    sb.append("    agCommision: ").append(toIndentedString(agCommision)).append("\n");
    sb.append("    commisionVAT: ").append(toIndentedString(commisionVAT)).append("\n");
    sb.append("    creationUser: ").append(toIndentedString(creationUser)).append("\n");
    sb.append("    holder: ").append(toIndentedString(holder)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceCompany: ").append(toIndentedString(invoiceCompany)).append("\n");
    sb.append("    totalSellingRate: ").append(toIndentedString(totalSellingRate)).append("\n");
    sb.append("    totalNet: ").append(toIndentedString(totalNet)).append("\n");
    sb.append("    pendingAmount: ").append(toIndentedString(pendingAmount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

