/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import travel.wink.hotelbeds.booking.sdk.model.ApiHolder;
import travel.wink.hotelbeds.booking.sdk.model.ApiHotelBookingList;
import travel.wink.hotelbeds.booking.sdk.model.ApiReceptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The Booking object. Contains all data related with the booking itself.
 */
@JsonPropertyOrder({
  ApiBookingList.JSON_PROPERTY_REFERENCE,
  ApiBookingList.JSON_PROPERTY_CLIENT_REFERENCE,
  ApiBookingList.JSON_PROPERTY_CREATION_DATE,
  ApiBookingList.JSON_PROPERTY_STATUS,
  ApiBookingList.JSON_PROPERTY_CREATION_USER,
  ApiBookingList.JSON_PROPERTY_HOLDER,
  ApiBookingList.JSON_PROPERTY_HOTEL,
  ApiBookingList.JSON_PROPERTY_INVOICE_COMPANY,
  ApiBookingList.JSON_PROPERTY_TOTAL_SELLING_RATE,
  ApiBookingList.JSON_PROPERTY_TOTAL_NET,
  ApiBookingList.JSON_PROPERTY_PENDING_AMOUNT,
  ApiBookingList.JSON_PROPERTY_CURRENCY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiBookingList {
  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_CLIENT_REFERENCE = "clientReference";
  private String clientReference;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private LocalDate creationDate;

  /**
   * Current status of the booking.
   */
  public enum StatusEnum {
    CONFIRMED("CONFIRMED"),
    
    CANCELLED("CANCELLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_CREATION_USER = "creationUser";
  private String creationUser;

  public static final String JSON_PROPERTY_HOLDER = "holder";
  private ApiHolder holder;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private ApiHotelBookingList hotel;

  public static final String JSON_PROPERTY_INVOICE_COMPANY = "invoiceCompany";
  private ApiReceptive invoiceCompany;

  public static final String JSON_PROPERTY_TOTAL_SELLING_RATE = "totalSellingRate";
  private String totalSellingRate;

  public static final String JSON_PROPERTY_TOTAL_NET = "totalNet";
  private String totalNet;

  public static final String JSON_PROPERTY_PENDING_AMOUNT = "pendingAmount";
  private BigDecimal pendingAmount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public ApiBookingList() {
  }

  public ApiBookingList reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Booking locator. Format: XXXXXXXX-XXXXXXXX
   * @return reference
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public ApiBookingList clientReference(String clientReference) {
    
    this.clientReference = clientReference;
    return this;
  }

   /**
   * Client internal booking reference.
   * @return clientReference
  **/
  @jakarta.annotation.Nullable
 @Size(min=1,max=20)
  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientReference() {
    return clientReference;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientReference(String clientReference) {
    this.clientReference = clientReference;
  }


  public ApiBookingList creationDate(LocalDate creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * Booking creation date.
   * @return creationDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCreationDate() {
    return creationDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(LocalDate creationDate) {
    this.creationDate = creationDate;
  }


  public ApiBookingList status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Current status of the booking.
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public ApiBookingList creationUser(String creationUser) {
    
    this.creationUser = creationUser;
    return this;
  }

   /**
   * The apiKey used to create the booking.
   * @return creationUser
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATION_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationUser() {
    return creationUser;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationUser(String creationUser) {
    this.creationUser = creationUser;
  }


  public ApiBookingList holder(ApiHolder holder) {
    
    this.holder = holder;
    return this;
  }

   /**
   * Get holder
   * @return holder
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiHolder getHolder() {
    return holder;
  }


  @JsonProperty(JSON_PROPERTY_HOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHolder(ApiHolder holder) {
    this.holder = holder;
  }


  public ApiBookingList hotel(ApiHotelBookingList hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiHotelBookingList getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(ApiHotelBookingList hotel) {
    this.hotel = hotel;
  }


  public ApiBookingList invoiceCompany(ApiReceptive invoiceCompany) {
    
    this.invoiceCompany = invoiceCompany;
    return this;
  }

   /**
   * Get invoiceCompany
   * @return invoiceCompany
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INVOICE_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiReceptive getInvoiceCompany() {
    return invoiceCompany;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoiceCompany(ApiReceptive invoiceCompany) {
    this.invoiceCompany = invoiceCompany;
  }


  public ApiBookingList totalSellingRate(String totalSellingRate) {
    
    this.totalSellingRate = totalSellingRate;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalSellingRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalSellingRate() {
    return totalSellingRate;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSellingRate(String totalSellingRate) {
    this.totalSellingRate = totalSellingRate;
  }


  public ApiBookingList totalNet(String totalNet) {
    
    this.totalNet = totalNet;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalNet
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalNet() {
    return totalNet;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalNet(String totalNet) {
    this.totalNet = totalNet;
  }


  public ApiBookingList pendingAmount(BigDecimal pendingAmount) {
    
    this.pendingAmount = pendingAmount;
    return this;
  }

   /**
   * Remaining amount to be paid.
   * @return pendingAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PENDING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPendingAmount() {
    return pendingAmount;
  }


  @JsonProperty(JSON_PROPERTY_PENDING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPendingAmount(BigDecimal pendingAmount) {
    this.pendingAmount = pendingAmount;
  }


  public ApiBookingList currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency of the monetary amount.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiBookingList apiBookingList = (ApiBookingList) o;
    return Objects.equals(this.reference, apiBookingList.reference) &&
        Objects.equals(this.clientReference, apiBookingList.clientReference) &&
        Objects.equals(this.creationDate, apiBookingList.creationDate) &&
        Objects.equals(this.status, apiBookingList.status) &&
        Objects.equals(this.creationUser, apiBookingList.creationUser) &&
        Objects.equals(this.holder, apiBookingList.holder) &&
        Objects.equals(this.hotel, apiBookingList.hotel) &&
        Objects.equals(this.invoiceCompany, apiBookingList.invoiceCompany) &&
        Objects.equals(this.totalSellingRate, apiBookingList.totalSellingRate) &&
        Objects.equals(this.totalNet, apiBookingList.totalNet) &&
        Objects.equals(this.pendingAmount, apiBookingList.pendingAmount) &&
        Objects.equals(this.currency, apiBookingList.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reference, clientReference, creationDate, status, creationUser, holder, hotel, invoiceCompany, totalSellingRate, totalNet, pendingAmount, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiBookingList {\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    clientReference: ").append(toIndentedString(clientReference)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    creationUser: ").append(toIndentedString(creationUser)).append("\n");
    sb.append("    holder: ").append(toIndentedString(holder)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    invoiceCompany: ").append(toIndentedString(invoiceCompany)).append("\n");
    sb.append("    totalSellingRate: ").append(toIndentedString(totalSellingRate)).append("\n");
    sb.append("    totalNet: ").append(toIndentedString(totalNet)).append("\n");
    sb.append("    pendingAmount: ").append(toIndentedString(pendingAmount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

