/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiPax;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Defines the room to be booked.
 */
@JsonPropertyOrder({
  ApiBookingRoom.JSON_PROPERTY_RATE_KEY,
  ApiBookingRoom.JSON_PROPERTY_PAXES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiBookingRoom {
  public static final String JSON_PROPERTY_RATE_KEY = "rateKey";
  private String rateKey;

  public static final String JSON_PROPERTY_PAXES = "paxes";
  private List<ApiPax> paxes;

  public ApiBookingRoom() {
  }

  public ApiBookingRoom rateKey(String rateKey) {
    
    this.rateKey = rateKey;
    return this;
  }

   /**
   * Internal key that represents a combination of room type, category, board and occupancy. Is returned in Availability and used to valuate a rate and confirm a booking.
   * @return rateKey
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRateKey() {
    return rateKey;
  }


  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRateKey(String rateKey) {
    this.rateKey = rateKey;
  }


  public ApiBookingRoom paxes(List<ApiPax> paxes) {
    
    this.paxes = paxes;
    return this;
  }

  public ApiBookingRoom addPaxesItem(ApiPax paxesItem) {
    if (this.paxes == null) {
      this.paxes = new ArrayList<>();
    }
    this.paxes.add(paxesItem);
    return this;
  }

   /**
   * Data of the passengers assigned to this room.
   * @return paxes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiPax> getPaxes() {
    return paxes;
  }


  @JsonProperty(JSON_PROPERTY_PAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaxes(List<ApiPax> paxes) {
    this.paxes = paxes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiBookingRoom apiBookingRoom = (ApiBookingRoom) o;
    return Objects.equals(this.rateKey, apiBookingRoom.rateKey) &&
        Objects.equals(this.paxes, apiBookingRoom.paxes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rateKey, paxes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiBookingRoom {\n");
    sb.append("    rateKey: ").append(toIndentedString(rateKey)).append("\n");
    sb.append("    paxes: ").append(toIndentedString(paxes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

