/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Set of rules that define the penalty the client will receive if the cancellation of a booking is made after a given date.
 */
@JsonPropertyOrder({
  ApiCancellationPolicy.JSON_PROPERTY_AMOUNT,
  ApiCancellationPolicy.JSON_PROPERTY_FROM,
  ApiCancellationPolicy.JSON_PROPERTY_PERCENT,
  ApiCancellationPolicy.JSON_PROPERTY_NUMBER_OF_NIGHTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiCancellationPolicy {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_FROM = "from";
  private String from;

  public static final String JSON_PROPERTY_PERCENT = "percent";
  private String percent;

  public static final String JSON_PROPERTY_NUMBER_OF_NIGHTS = "numberOfNights";
  private String numberOfNights;

  public ApiCancellationPolicy() {
  }

  public ApiCancellationPolicy amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Penalty that will be charged for cancellations after the indicated date, represented as a monetary amount.
   * @return amount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public ApiCancellationPolicy from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * Date from which the penalties are applied in ISO 8601 format (yyyy-MM-ddTHH:mm:ssZ).
   * @return from
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(String from) {
    this.from = from;
  }


  public ApiCancellationPolicy percent(String percent) {
    
    this.percent = percent;
    return this;
  }

   /**
   * Penalty that will be charged for cancellations after the indicated date, represented as a monetary amount, represented as a percentage of the total amount of the booking.
   * @return percent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPercent() {
    return percent;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercent(String percent) {
    this.percent = percent;
  }


  public ApiCancellationPolicy numberOfNights(String numberOfNights) {
    
    this.numberOfNights = numberOfNights;
    return this;
  }

   /**
   * Penalty that will be applied for cancellations after the indicated date, represented as a number of nights.
   * @return numberOfNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumberOfNights() {
    return numberOfNights;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfNights(String numberOfNights) {
    this.numberOfNights = numberOfNights;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiCancellationPolicy apiCancellationPolicy = (ApiCancellationPolicy) o;
    return Objects.equals(this.amount, apiCancellationPolicy.amount) &&
        Objects.equals(this.from, apiCancellationPolicy.from) &&
        Objects.equals(this.percent, apiCancellationPolicy.percent) &&
        Objects.equals(this.numberOfNights, apiCancellationPolicy.numberOfNights);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, from, percent, numberOfNights);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiCancellationPolicy {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    percent: ").append(toIndentedString(percent)).append("\n");
    sb.append("    numberOfNights: ").append(toIndentedString(numberOfNights)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

