/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Filters to limit Availability results by particular values.
 */
@JsonPropertyOrder({
  ApiFilter.JSON_PROPERTY_MAX_HOTELS,
  ApiFilter.JSON_PROPERTY_MAX_ROOMS,
  ApiFilter.JSON_PROPERTY_MIN_RATE,
  ApiFilter.JSON_PROPERTY_MAX_RATE,
  ApiFilter.JSON_PROPERTY_MAX_RATES_PER_ROOM,
  ApiFilter.JSON_PROPERTY_MIN_CATEGORY,
  ApiFilter.JSON_PROPERTY_MAX_CATEGORY,
  ApiFilter.JSON_PROPERTY_CONTRACT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiFilter {
  public static final String JSON_PROPERTY_MAX_HOTELS = "maxHotels";
  private Integer maxHotels;

  public static final String JSON_PROPERTY_MAX_ROOMS = "maxRooms";
  private Integer maxRooms;

  public static final String JSON_PROPERTY_MIN_RATE = "minRate";
  private String minRate;

  public static final String JSON_PROPERTY_MAX_RATE = "maxRate";
  private String maxRate;

  public static final String JSON_PROPERTY_MAX_RATES_PER_ROOM = "maxRatesPerRoom";
  private Integer maxRatesPerRoom;

  public static final String JSON_PROPERTY_MIN_CATEGORY = "minCategory";
  private Integer minCategory;

  public static final String JSON_PROPERTY_MAX_CATEGORY = "maxCategory";
  private Integer maxCategory;

  public static final String JSON_PROPERTY_CONTRACT = "contract";
  private String contract;

  public ApiFilter() {
  }

  public ApiFilter maxHotels(Integer maxHotels) {
    
    this.maxHotels = maxHotels;
    return this;
  }

   /**
   * Filter for maximum number of hotels you want to receive in the response.
   * minimum: 1
   * maximum: 2000
   * @return maxHotels
  **/
  @jakarta.annotation.Nullable
 @Min(1) @Max(2000)
  @JsonProperty(JSON_PROPERTY_MAX_HOTELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxHotels() {
    return maxHotels;
  }


  @JsonProperty(JSON_PROPERTY_MAX_HOTELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxHotels(Integer maxHotels) {
    this.maxHotels = maxHotels;
  }


  public ApiFilter maxRooms(Integer maxRooms) {
    
    this.maxRooms = maxRooms;
    return this;
  }

   /**
   * Filter for maximum number of rooms you want to receive for each hotel.
   * minimum: 1
   * maximum: 50
   * @return maxRooms
  **/
  @jakarta.annotation.Nullable
 @Min(1) @Max(50)
  @JsonProperty(JSON_PROPERTY_MAX_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxRooms() {
    return maxRooms;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRooms(Integer maxRooms) {
    this.maxRooms = maxRooms;
  }


  public ApiFilter minRate(String minRate) {
    
    this.minRate = minRate;
    return this;
  }

   /**
   * Filter for minimum hotel room price.
   * @return minRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinRate() {
    return minRate;
  }


  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinRate(String minRate) {
    this.minRate = minRate;
  }


  public ApiFilter maxRate(String maxRate) {
    
    this.maxRate = maxRate;
    return this;
  }

   /**
   * Filter for maximum hotel room price.
   * @return maxRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxRate() {
    return maxRate;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRate(String maxRate) {
    this.maxRate = maxRate;
  }


  public ApiFilter maxRatesPerRoom(Integer maxRatesPerRoom) {
    
    this.maxRatesPerRoom = maxRatesPerRoom;
    return this;
  }

   /**
   * Filter for maximum number of rates per room.
   * minimum: 1
   * @return maxRatesPerRoom
  **/
  @jakarta.annotation.Nullable
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_RATES_PER_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxRatesPerRoom() {
    return maxRatesPerRoom;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATES_PER_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRatesPerRoom(Integer maxRatesPerRoom) {
    this.maxRatesPerRoom = maxRatesPerRoom;
  }


  public ApiFilter minCategory(Integer minCategory) {
    
    this.minCategory = minCategory;
    return this;
  }

   /**
   * Filter for minimun hotel category.
   * minimum: 1
   * maximum: 5
   * @return minCategory
  **/
  @jakarta.annotation.Nullable
 @Min(1) @Max(5)
  @JsonProperty(JSON_PROPERTY_MIN_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinCategory() {
    return minCategory;
  }


  @JsonProperty(JSON_PROPERTY_MIN_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinCategory(Integer minCategory) {
    this.minCategory = minCategory;
  }


  public ApiFilter maxCategory(Integer maxCategory) {
    
    this.maxCategory = maxCategory;
    return this;
  }

   /**
   * Filter for maximum hotel category.
   * minimum: 1
   * maximum: 5
   * @return maxCategory
  **/
  @jakarta.annotation.Nullable
 @Min(1) @Max(5)
  @JsonProperty(JSON_PROPERTY_MAX_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxCategory() {
    return maxCategory;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxCategory(Integer maxCategory) {
    this.maxCategory = maxCategory;
  }


  public ApiFilter contract(String contract) {
    
    this.contract = contract;
    return this;
  }

   /**
   * Filters the results by the contract requested. (NOTE: when using this filter is mandatory to inform availabilityRQ/@aifUse attribute)
   * @return contract
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContract() {
    return contract;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContract(String contract) {
    this.contract = contract;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiFilter apiFilter = (ApiFilter) o;
    return Objects.equals(this.maxHotels, apiFilter.maxHotels) &&
        Objects.equals(this.maxRooms, apiFilter.maxRooms) &&
        Objects.equals(this.minRate, apiFilter.minRate) &&
        Objects.equals(this.maxRate, apiFilter.maxRate) &&
        Objects.equals(this.maxRatesPerRoom, apiFilter.maxRatesPerRoom) &&
        Objects.equals(this.minCategory, apiFilter.minCategory) &&
        Objects.equals(this.maxCategory, apiFilter.maxCategory) &&
        Objects.equals(this.contract, apiFilter.contract);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxHotels, maxRooms, minRate, maxRate, maxRatesPerRoom, minCategory, maxCategory, contract);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiFilter {\n");
    sb.append("    maxHotels: ").append(toIndentedString(maxHotels)).append("\n");
    sb.append("    maxRooms: ").append(toIndentedString(maxRooms)).append("\n");
    sb.append("    minRate: ").append(toIndentedString(minRate)).append("\n");
    sb.append("    maxRate: ").append(toIndentedString(maxRate)).append("\n");
    sb.append("    maxRatesPerRoom: ").append(toIndentedString(maxRatesPerRoom)).append("\n");
    sb.append("    minCategory: ").append(toIndentedString(minCategory)).append("\n");
    sb.append("    maxCategory: ").append(toIndentedString(maxCategory)).append("\n");
    sb.append("    contract: ").append(toIndentedString(contract)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

