/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Defines the geolocation data for hotel search.
 */
@JsonPropertyOrder({
  ApiGeoLocation.JSON_PROPERTY_LONGITUDE,
  ApiGeoLocation.JSON_PROPERTY_LATITUDE,
  ApiGeoLocation.JSON_PROPERTY_RADIUS,
  ApiGeoLocation.JSON_PROPERTY_UNIT,
  ApiGeoLocation.JSON_PROPERTY_SECONDARY_LATITUDE,
  ApiGeoLocation.JSON_PROPERTY_SECONDARY_LONGITUDE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiGeoLocation {
  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private String longitude;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private String latitude;

  public static final String JSON_PROPERTY_RADIUS = "radius";
  private String radius;

  /**
   * Distance unit for the radius.
   */
  public enum UnitEnum {
    MI("mi"),
    
    KM("km");

    private String value;

    UnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UnitEnum fromValue(String value) {
      for (UnitEnum b : UnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UNIT = "unit";
  private UnitEnum unit;

  public static final String JSON_PROPERTY_SECONDARY_LATITUDE = "secondaryLatitude";
  private String secondaryLatitude;

  public static final String JSON_PROPERTY_SECONDARY_LONGITUDE = "secondaryLongitude";
  private String secondaryLongitude;

  public ApiGeoLocation() {
  }

  public ApiGeoLocation longitude(String longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude coordinate for geolocation search.
   * @return longitude
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }


  public ApiGeoLocation latitude(String latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude coordinate for geolocation search.
   * @return latitude
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }


  public ApiGeoLocation radius(String radius) {
    
    this.radius = radius;
    return this;
  }

   /**
   * Radius size for circular search.
   * @return radius
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RADIUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRadius() {
    return radius;
  }


  @JsonProperty(JSON_PROPERTY_RADIUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRadius(String radius) {
    this.radius = radius;
  }


  public ApiGeoLocation unit(UnitEnum unit) {
    
    this.unit = unit;
    return this;
  }

   /**
   * Distance unit for the radius.
   * @return unit
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UnitEnum getUnit() {
    return unit;
  }


  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnit(UnitEnum unit) {
    this.unit = unit;
  }


  public ApiGeoLocation secondaryLatitude(String secondaryLatitude) {
    
    this.secondaryLatitude = secondaryLatitude;
    return this;
  }

   /**
   * Latitude coordinate for geolocation search for rectangle search. Determines bottom right point of the search area.
   * @return secondaryLatitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECONDARY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecondaryLatitude() {
    return secondaryLatitude;
  }


  @JsonProperty(JSON_PROPERTY_SECONDARY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecondaryLatitude(String secondaryLatitude) {
    this.secondaryLatitude = secondaryLatitude;
  }


  public ApiGeoLocation secondaryLongitude(String secondaryLongitude) {
    
    this.secondaryLongitude = secondaryLongitude;
    return this;
  }

   /**
   * Longitude coordinate for geolocation search for rectangle search. Determines bottom right point of the search area.
   * @return secondaryLongitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECONDARY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecondaryLongitude() {
    return secondaryLongitude;
  }


  @JsonProperty(JSON_PROPERTY_SECONDARY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecondaryLongitude(String secondaryLongitude) {
    this.secondaryLongitude = secondaryLongitude;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiGeoLocation apiGeoLocation = (ApiGeoLocation) o;
    return Objects.equals(this.longitude, apiGeoLocation.longitude) &&
        Objects.equals(this.latitude, apiGeoLocation.latitude) &&
        Objects.equals(this.radius, apiGeoLocation.radius) &&
        Objects.equals(this.unit, apiGeoLocation.unit) &&
        Objects.equals(this.secondaryLatitude, apiGeoLocation.secondaryLatitude) &&
        Objects.equals(this.secondaryLongitude, apiGeoLocation.secondaryLongitude);
  }

  @Override
  public int hashCode() {
    return Objects.hash(longitude, latitude, radius, unit, secondaryLatitude, secondaryLongitude);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiGeoLocation {\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    radius: ").append(toIndentedString(radius)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    secondaryLatitude: ").append(toIndentedString(secondaryLatitude)).append("\n");
    sb.append("    secondaryLongitude: ").append(toIndentedString(secondaryLongitude)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

