/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiCreditCard;
import travel.wink.hotelbeds.booking.sdk.model.ApiKeyword;
import travel.wink.hotelbeds.booking.sdk.model.ApiReview;
import travel.wink.hotelbeds.booking.sdk.model.ApiSupplier;
import travel.wink.hotelbeds.booking.sdk.model.ApiUpselling;
import travel.wink.hotelbeds.booking.sdk.model.Room;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information about an hotel and its associated room rates.
 */
@JsonPropertyOrder({
  ApiHotel.JSON_PROPERTY_CHECK_OUT,
  ApiHotel.JSON_PROPERTY_CHECK_IN,
  ApiHotel.JSON_PROPERTY_CODE,
  ApiHotel.JSON_PROPERTY_NAME,
  ApiHotel.JSON_PROPERTY_DESCRIPTION,
  ApiHotel.JSON_PROPERTY_EXCLUSIVE_DEAL,
  ApiHotel.JSON_PROPERTY_CATEGORY_CODE,
  ApiHotel.JSON_PROPERTY_CATEGORY_NAME,
  ApiHotel.JSON_PROPERTY_DESTINATION_CODE,
  ApiHotel.JSON_PROPERTY_DESTINATION_NAME,
  ApiHotel.JSON_PROPERTY_ZONE_CODE,
  ApiHotel.JSON_PROPERTY_ZONE_NAME,
  ApiHotel.JSON_PROPERTY_LATITUDE,
  ApiHotel.JSON_PROPERTY_LONGITUDE,
  ApiHotel.JSON_PROPERTY_MIN_RATE,
  ApiHotel.JSON_PROPERTY_MAX_RATE,
  ApiHotel.JSON_PROPERTY_TOTAL_SELLING_RATE,
  ApiHotel.JSON_PROPERTY_TOTAL_NET,
  ApiHotel.JSON_PROPERTY_PENDING_AMOUNT,
  ApiHotel.JSON_PROPERTY_CURRENCY,
  ApiHotel.JSON_PROPERTY_SUPPLIER,
  ApiHotel.JSON_PROPERTY_CLIENT_COMMENTS,
  ApiHotel.JSON_PROPERTY_CANCELLATION_AMOUNT,
  ApiHotel.JSON_PROPERTY_UPSELLING,
  ApiHotel.JSON_PROPERTY_KEYWORDS,
  ApiHotel.JSON_PROPERTY_REVIEWS,
  ApiHotel.JSON_PROPERTY_ROOMS,
  ApiHotel.JSON_PROPERTY_CREDIT_CARDS,
  ApiHotel.JSON_PROPERTY_PAYMENT_DATA_REQUIRED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiHotel {
  public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
  private LocalDate checkOut;

  public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
  private LocalDate checkIn;

  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_EXCLUSIVE_DEAL = "exclusiveDeal";
  private Integer exclusiveDeal;

  public static final String JSON_PROPERTY_CATEGORY_CODE = "categoryCode";
  private String categoryCode;

  public static final String JSON_PROPERTY_CATEGORY_NAME = "categoryName";
  private String categoryName;

  public static final String JSON_PROPERTY_DESTINATION_CODE = "destinationCode";
  private String destinationCode;

  public static final String JSON_PROPERTY_DESTINATION_NAME = "destinationName";
  private String destinationName;

  public static final String JSON_PROPERTY_ZONE_CODE = "zoneCode";
  private Integer zoneCode;

  public static final String JSON_PROPERTY_ZONE_NAME = "zoneName";
  private String zoneName;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private String latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private String longitude;

  public static final String JSON_PROPERTY_MIN_RATE = "minRate";
  private String minRate;

  public static final String JSON_PROPERTY_MAX_RATE = "maxRate";
  private String maxRate;

  public static final String JSON_PROPERTY_TOTAL_SELLING_RATE = "totalSellingRate";
  private BigDecimal totalSellingRate;

  public static final String JSON_PROPERTY_TOTAL_NET = "totalNet";
  private BigDecimal totalNet;

  public static final String JSON_PROPERTY_PENDING_AMOUNT = "pendingAmount";
  private BigDecimal pendingAmount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_SUPPLIER = "supplier";
  private ApiSupplier supplier;

  public static final String JSON_PROPERTY_CLIENT_COMMENTS = "clientComments";
  private String clientComments;

  public static final String JSON_PROPERTY_CANCELLATION_AMOUNT = "cancellationAmount";
  private String cancellationAmount;

  public static final String JSON_PROPERTY_UPSELLING = "upselling";
  private ApiUpselling upselling;

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<ApiKeyword> keywords;

  public static final String JSON_PROPERTY_REVIEWS = "reviews";
  private List<ApiReview> reviews;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<Room> rooms;

  public static final String JSON_PROPERTY_CREDIT_CARDS = "creditCards";
  private List<ApiCreditCard> creditCards;

  public static final String JSON_PROPERTY_PAYMENT_DATA_REQUIRED = "paymentDataRequired";
  private Boolean paymentDataRequired = false;

  public ApiHotel() {
  }

  public ApiHotel checkOut(LocalDate checkOut) {
    
    this.checkOut = checkOut;
    return this;
  }

   /**
   * Check-out date.
   * @return checkOut
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckOut() {
    return checkOut;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckOut(LocalDate checkOut) {
    this.checkOut = checkOut;
  }


  public ApiHotel checkIn(LocalDate checkIn) {
    
    this.checkIn = checkIn;
    return this;
  }

   /**
   * Check-in date.
   * @return checkIn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckIn() {
    return checkIn;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckIn(LocalDate checkIn) {
    this.checkIn = checkIn;
  }


  public ApiHotel code(Integer code) {
    
    this.code = code;
    return this;
  }

   /**
   * Hotelbeds internal hotel code.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public ApiHotel name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the hotel.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ApiHotel description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Hotel description.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ApiHotel exclusiveDeal(Integer exclusiveDeal) {
    
    this.exclusiveDeal = exclusiveDeal;
    return this;
  }

   /**
   * The value follows a qualitative scale, the number 1 being always the top priority/preferential, and the rest of the product defined by our commercial departments. As of today, the possible values are:   1: Identifies preferential product with exclusive guaranteed availability.   2: Identifies top hotels.   3: Identifies the rest of hotels.   In case new values are added in the future, a proper communication campaign will be carried out to inform you. 
   * @return exclusiveDeal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXCLUSIVE_DEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExclusiveDeal() {
    return exclusiveDeal;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUSIVE_DEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExclusiveDeal(Integer exclusiveDeal) {
    this.exclusiveDeal = exclusiveDeal;
  }


  public ApiHotel categoryCode(String categoryCode) {
    
    this.categoryCode = categoryCode;
    return this;
  }

   /**
   * Hotelbeds code of the hotel category.
   * @return categoryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryCode() {
    return categoryCode;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }


  public ApiHotel categoryName(String categoryName) {
    
    this.categoryName = categoryName;
    return this;
  }

   /**
   * Name of the hotel category.
   * @return categoryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryName() {
    return categoryName;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }


  public ApiHotel destinationCode(String destinationCode) {
    
    this.destinationCode = destinationCode;
    return this;
  }

   /**
   * Code of the destination of the hotel location.
   * @return destinationCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationCode() {
    return destinationCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationCode(String destinationCode) {
    this.destinationCode = destinationCode;
  }


  public ApiHotel destinationName(String destinationName) {
    
    this.destinationName = destinationName;
    return this;
  }

   /**
   * Name of the destination of the hotel location.
   * @return destinationName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationName() {
    return destinationName;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationName(String destinationName) {
    this.destinationName = destinationName;
  }


  public ApiHotel zoneCode(Integer zoneCode) {
    
    this.zoneCode = zoneCode;
    return this;
  }

   /**
   * Code of the zone of the hotel location.
   * @return zoneCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getZoneCode() {
    return zoneCode;
  }


  @JsonProperty(JSON_PROPERTY_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoneCode(Integer zoneCode) {
    this.zoneCode = zoneCode;
  }


  public ApiHotel zoneName(String zoneName) {
    
    this.zoneName = zoneName;
    return this;
  }

   /**
   * Name of the zone of the hotel location.
   * @return zoneName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ZONE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getZoneName() {
    return zoneName;
  }


  @JsonProperty(JSON_PROPERTY_ZONE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoneName(String zoneName) {
    this.zoneName = zoneName;
  }


  public ApiHotel latitude(String latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude coordinate of the hotel location.
   * @return latitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }


  public ApiHotel longitude(String longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude coordinate of the hotel location.
   * @return longitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }


  public ApiHotel minRate(String minRate) {
    
    this.minRate = minRate;
    return this;
  }

   /**
   * Minimum hotel room price.
   * @return minRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinRate() {
    return minRate;
  }


  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinRate(String minRate) {
    this.minRate = minRate;
  }


  public ApiHotel maxRate(String maxRate) {
    
    this.maxRate = maxRate;
    return this;
  }

   /**
   * Maximum hotel room price.
   * @return maxRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxRate() {
    return maxRate;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRate(String maxRate) {
    this.maxRate = maxRate;
  }


  public ApiHotel totalSellingRate(BigDecimal totalSellingRate) {
    
    this.totalSellingRate = totalSellingRate;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalSellingRate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotalSellingRate() {
    return totalSellingRate;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSellingRate(BigDecimal totalSellingRate) {
    this.totalSellingRate = totalSellingRate;
  }


  public ApiHotel totalNet(BigDecimal totalNet) {
    
    this.totalNet = totalNet;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalNet
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotalNet() {
    return totalNet;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalNet(BigDecimal totalNet) {
    this.totalNet = totalNet;
  }


  public ApiHotel pendingAmount(BigDecimal pendingAmount) {
    
    this.pendingAmount = pendingAmount;
    return this;
  }

   /**
   * Remaining amount to be paid.
   * @return pendingAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PENDING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPendingAmount() {
    return pendingAmount;
  }


  @JsonProperty(JSON_PROPERTY_PENDING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPendingAmount(BigDecimal pendingAmount) {
    this.pendingAmount = pendingAmount;
  }


  public ApiHotel currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Client currency.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public ApiHotel supplier(ApiSupplier supplier) {
    
    this.supplier = supplier;
    return this;
  }

   /**
   * Get supplier
   * @return supplier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiSupplier getSupplier() {
    return supplier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplier(ApiSupplier supplier) {
    this.supplier = supplier;
  }


  public ApiHotel clientComments(String clientComments) {
    
    this.clientComments = clientComments;
    return this;
  }

   /**
   * Get clientComments
   * @return clientComments
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLIENT_COMMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientComments() {
    return clientComments;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_COMMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientComments(String clientComments) {
    this.clientComments = clientComments;
  }


  public ApiHotel cancellationAmount(String cancellationAmount) {
    
    this.cancellationAmount = cancellationAmount;
    return this;
  }

   /**
   * Get cancellationAmount
   * @return cancellationAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellationAmount() {
    return cancellationAmount;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationAmount(String cancellationAmount) {
    this.cancellationAmount = cancellationAmount;
  }


  public ApiHotel upselling(ApiUpselling upselling) {
    
    this.upselling = upselling;
    return this;
  }

   /**
   * Get upselling
   * @return upselling
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_UPSELLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiUpselling getUpselling() {
    return upselling;
  }


  @JsonProperty(JSON_PROPERTY_UPSELLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpselling(ApiUpselling upselling) {
    this.upselling = upselling;
  }


  public ApiHotel keywords(List<ApiKeyword> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public ApiHotel addKeywordsItem(ApiKeyword keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Get keywords
   * @return keywords
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiKeyword> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeywords(List<ApiKeyword> keywords) {
    this.keywords = keywords;
  }


  public ApiHotel reviews(List<ApiReview> reviews) {
    
    this.reviews = reviews;
    return this;
  }

  public ApiHotel addReviewsItem(ApiReview reviewsItem) {
    if (this.reviews == null) {
      this.reviews = new ArrayList<>();
    }
    this.reviews.add(reviewsItem);
    return this;
  }

   /**
   * Get reviews
   * @return reviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiReview> getReviews() {
    return reviews;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviews(List<ApiReview> reviews) {
    this.reviews = reviews;
  }


  public ApiHotel rooms(List<Room> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public ApiHotel addRoomsItem(Room roomsItem) {
    if (this.rooms == null) {
      this.rooms = new ArrayList<>();
    }
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * Get rooms
   * @return rooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Room> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(List<Room> rooms) {
    this.rooms = rooms;
  }


  public ApiHotel creditCards(List<ApiCreditCard> creditCards) {
    
    this.creditCards = creditCards;
    return this;
  }

  public ApiHotel addCreditCardsItem(ApiCreditCard creditCardsItem) {
    if (this.creditCards == null) {
      this.creditCards = new ArrayList<>();
    }
    this.creditCards.add(creditCardsItem);
    return this;
  }

   /**
   * List of credit cards accepted by the hotel.
   * @return creditCards
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREDIT_CARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiCreditCard> getCreditCards() {
    return creditCards;
  }


  @JsonProperty(JSON_PROPERTY_CREDIT_CARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreditCards(List<ApiCreditCard> creditCards) {
    this.creditCards = creditCards;
  }


  public ApiHotel paymentDataRequired(Boolean paymentDataRequired) {
    
    this.paymentDataRequired = paymentDataRequired;
    return this;
  }

   /**
   * Indicates the need for payment data(i.e.: credit card details) in order to finish the booking.
   * @return paymentDataRequired
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPaymentDataRequired() {
    return paymentDataRequired;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentDataRequired(Boolean paymentDataRequired) {
    this.paymentDataRequired = paymentDataRequired;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotel apiHotel = (ApiHotel) o;
    return Objects.equals(this.checkOut, apiHotel.checkOut) &&
        Objects.equals(this.checkIn, apiHotel.checkIn) &&
        Objects.equals(this.code, apiHotel.code) &&
        Objects.equals(this.name, apiHotel.name) &&
        Objects.equals(this.description, apiHotel.description) &&
        Objects.equals(this.exclusiveDeal, apiHotel.exclusiveDeal) &&
        Objects.equals(this.categoryCode, apiHotel.categoryCode) &&
        Objects.equals(this.categoryName, apiHotel.categoryName) &&
        Objects.equals(this.destinationCode, apiHotel.destinationCode) &&
        Objects.equals(this.destinationName, apiHotel.destinationName) &&
        Objects.equals(this.zoneCode, apiHotel.zoneCode) &&
        Objects.equals(this.zoneName, apiHotel.zoneName) &&
        Objects.equals(this.latitude, apiHotel.latitude) &&
        Objects.equals(this.longitude, apiHotel.longitude) &&
        Objects.equals(this.minRate, apiHotel.minRate) &&
        Objects.equals(this.maxRate, apiHotel.maxRate) &&
        Objects.equals(this.totalSellingRate, apiHotel.totalSellingRate) &&
        Objects.equals(this.totalNet, apiHotel.totalNet) &&
        Objects.equals(this.pendingAmount, apiHotel.pendingAmount) &&
        Objects.equals(this.currency, apiHotel.currency) &&
        Objects.equals(this.supplier, apiHotel.supplier) &&
        Objects.equals(this.clientComments, apiHotel.clientComments) &&
        Objects.equals(this.cancellationAmount, apiHotel.cancellationAmount) &&
        Objects.equals(this.upselling, apiHotel.upselling) &&
        Objects.equals(this.keywords, apiHotel.keywords) &&
        Objects.equals(this.reviews, apiHotel.reviews) &&
        Objects.equals(this.rooms, apiHotel.rooms) &&
        Objects.equals(this.creditCards, apiHotel.creditCards) &&
        Objects.equals(this.paymentDataRequired, apiHotel.paymentDataRequired);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkOut, checkIn, code, name, description, exclusiveDeal, categoryCode, categoryName, destinationCode, destinationName, zoneCode, zoneName, latitude, longitude, minRate, maxRate, totalSellingRate, totalNet, pendingAmount, currency, supplier, clientComments, cancellationAmount, upselling, keywords, reviews, rooms, creditCards, paymentDataRequired);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotel {\n");
    sb.append("    checkOut: ").append(toIndentedString(checkOut)).append("\n");
    sb.append("    checkIn: ").append(toIndentedString(checkIn)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    exclusiveDeal: ").append(toIndentedString(exclusiveDeal)).append("\n");
    sb.append("    categoryCode: ").append(toIndentedString(categoryCode)).append("\n");
    sb.append("    categoryName: ").append(toIndentedString(categoryName)).append("\n");
    sb.append("    destinationCode: ").append(toIndentedString(destinationCode)).append("\n");
    sb.append("    destinationName: ").append(toIndentedString(destinationName)).append("\n");
    sb.append("    zoneCode: ").append(toIndentedString(zoneCode)).append("\n");
    sb.append("    zoneName: ").append(toIndentedString(zoneName)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    minRate: ").append(toIndentedString(minRate)).append("\n");
    sb.append("    maxRate: ").append(toIndentedString(maxRate)).append("\n");
    sb.append("    totalSellingRate: ").append(toIndentedString(totalSellingRate)).append("\n");
    sb.append("    totalNet: ").append(toIndentedString(totalNet)).append("\n");
    sb.append("    pendingAmount: ").append(toIndentedString(pendingAmount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    supplier: ").append(toIndentedString(supplier)).append("\n");
    sb.append("    clientComments: ").append(toIndentedString(clientComments)).append("\n");
    sb.append("    cancellationAmount: ").append(toIndentedString(cancellationAmount)).append("\n");
    sb.append("    upselling: ").append(toIndentedString(upselling)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    reviews: ").append(toIndentedString(reviews)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    creditCards: ").append(toIndentedString(creditCards)).append("\n");
    sb.append("    paymentDataRequired: ").append(toIndentedString(paymentDataRequired)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

