/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.RoomBookingList;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information about an hotel and its associated room rates.
 */
@JsonPropertyOrder({
  ApiHotelBookingList.JSON_PROPERTY_CHECK_OUT,
  ApiHotelBookingList.JSON_PROPERTY_CHECK_IN,
  ApiHotelBookingList.JSON_PROPERTY_CODE,
  ApiHotelBookingList.JSON_PROPERTY_NAME,
  ApiHotelBookingList.JSON_PROPERTY_DESTINATION_CODE,
  ApiHotelBookingList.JSON_PROPERTY_CANCELLATION_AMOUNT,
  ApiHotelBookingList.JSON_PROPERTY_ROOMS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiHotelBookingList {
  public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
  private LocalDate checkOut;

  public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
  private LocalDate checkIn;

  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESTINATION_CODE = "destinationCode";
  private String destinationCode;

  public static final String JSON_PROPERTY_CANCELLATION_AMOUNT = "cancellationAmount";
  private String cancellationAmount;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<RoomBookingList> rooms;

  public ApiHotelBookingList() {
  }

  public ApiHotelBookingList checkOut(LocalDate checkOut) {
    
    this.checkOut = checkOut;
    return this;
  }

   /**
   * Check-out date.
   * @return checkOut
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckOut() {
    return checkOut;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckOut(LocalDate checkOut) {
    this.checkOut = checkOut;
  }


  public ApiHotelBookingList checkIn(LocalDate checkIn) {
    
    this.checkIn = checkIn;
    return this;
  }

   /**
   * Check-in date.
   * @return checkIn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckIn() {
    return checkIn;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckIn(LocalDate checkIn) {
    this.checkIn = checkIn;
  }


  public ApiHotelBookingList code(Integer code) {
    
    this.code = code;
    return this;
  }

   /**
   * Hotelbeds internal hotel code.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public ApiHotelBookingList name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the hotel.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ApiHotelBookingList destinationCode(String destinationCode) {
    
    this.destinationCode = destinationCode;
    return this;
  }

   /**
   * Code of the destination of the hotel location.
   * @return destinationCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationCode() {
    return destinationCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationCode(String destinationCode) {
    this.destinationCode = destinationCode;
  }


  public ApiHotelBookingList cancellationAmount(String cancellationAmount) {
    
    this.cancellationAmount = cancellationAmount;
    return this;
  }

   /**
   * Get cancellationAmount
   * @return cancellationAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellationAmount() {
    return cancellationAmount;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationAmount(String cancellationAmount) {
    this.cancellationAmount = cancellationAmount;
  }


  public ApiHotelBookingList rooms(List<RoomBookingList> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public ApiHotelBookingList addRoomsItem(RoomBookingList roomsItem) {
    if (this.rooms == null) {
      this.rooms = new ArrayList<>();
    }
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * Get rooms
   * @return rooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomBookingList> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(List<RoomBookingList> rooms) {
    this.rooms = rooms;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelBookingList apiHotelBookingList = (ApiHotelBookingList) o;
    return Objects.equals(this.checkOut, apiHotelBookingList.checkOut) &&
        Objects.equals(this.checkIn, apiHotelBookingList.checkIn) &&
        Objects.equals(this.code, apiHotelBookingList.code) &&
        Objects.equals(this.name, apiHotelBookingList.name) &&
        Objects.equals(this.destinationCode, apiHotelBookingList.destinationCode) &&
        Objects.equals(this.cancellationAmount, apiHotelBookingList.cancellationAmount) &&
        Objects.equals(this.rooms, apiHotelBookingList.rooms);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkOut, checkIn, code, name, destinationCode, cancellationAmount, rooms);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelBookingList {\n");
    sb.append("    checkOut: ").append(toIndentedString(checkOut)).append("\n");
    sb.append("    checkIn: ").append(toIndentedString(checkIn)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    destinationCode: ").append(toIndentedString(destinationCode)).append("\n");
    sb.append("    cancellationAmount: ").append(toIndentedString(cancellationAmount)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

