/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiCreditCard;
import travel.wink.hotelbeds.booking.sdk.model.ApiModificationPolicies;
import travel.wink.hotelbeds.booking.sdk.model.ApiUpsellingCheckRate;
import travel.wink.hotelbeds.booking.sdk.model.RoomCheckRate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information about an hotel and its associated room rates.
 */
@JsonPropertyOrder({
  ApiHotelCheckRate.JSON_PROPERTY_CHECK_OUT,
  ApiHotelCheckRate.JSON_PROPERTY_CHECK_IN,
  ApiHotelCheckRate.JSON_PROPERTY_CODE,
  ApiHotelCheckRate.JSON_PROPERTY_NAME,
  ApiHotelCheckRate.JSON_PROPERTY_DESCRIPTION,
  ApiHotelCheckRate.JSON_PROPERTY_CATEGORY_CODE,
  ApiHotelCheckRate.JSON_PROPERTY_CATEGORY_NAME,
  ApiHotelCheckRate.JSON_PROPERTY_DESTINATION_CODE,
  ApiHotelCheckRate.JSON_PROPERTY_DESTINATION_NAME,
  ApiHotelCheckRate.JSON_PROPERTY_ZONE_CODE,
  ApiHotelCheckRate.JSON_PROPERTY_ZONE_NAME,
  ApiHotelCheckRate.JSON_PROPERTY_LATITUDE,
  ApiHotelCheckRate.JSON_PROPERTY_LONGITUDE,
  ApiHotelCheckRate.JSON_PROPERTY_MIN_RATE,
  ApiHotelCheckRate.JSON_PROPERTY_MAX_RATE,
  ApiHotelCheckRate.JSON_PROPERTY_TOTAL_SELLING_RATE,
  ApiHotelCheckRate.JSON_PROPERTY_TOTAL_NET,
  ApiHotelCheckRate.JSON_PROPERTY_GIATA,
  ApiHotelCheckRate.JSON_PROPERTY_CURRENCY,
  ApiHotelCheckRate.JSON_PROPERTY_UPSELLING,
  ApiHotelCheckRate.JSON_PROPERTY_ROOMS,
  ApiHotelCheckRate.JSON_PROPERTY_CREDIT_CARDS,
  ApiHotelCheckRate.JSON_PROPERTY_PAYMENT_DATA_REQUIRED,
  ApiHotelCheckRate.JSON_PROPERTY_MODIFICATION_POLICIES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiHotelCheckRate {
  public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
  private LocalDate checkOut;

  public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
  private LocalDate checkIn;

  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_CATEGORY_CODE = "categoryCode";
  private String categoryCode;

  public static final String JSON_PROPERTY_CATEGORY_NAME = "categoryName";
  private String categoryName;

  public static final String JSON_PROPERTY_DESTINATION_CODE = "destinationCode";
  private String destinationCode;

  public static final String JSON_PROPERTY_DESTINATION_NAME = "destinationName";
  private String destinationName;

  public static final String JSON_PROPERTY_ZONE_CODE = "zoneCode";
  private Integer zoneCode;

  public static final String JSON_PROPERTY_ZONE_NAME = "zoneName";
  private String zoneName;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private String latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private String longitude;

  public static final String JSON_PROPERTY_MIN_RATE = "minRate";
  private String minRate;

  public static final String JSON_PROPERTY_MAX_RATE = "maxRate";
  private String maxRate;

  public static final String JSON_PROPERTY_TOTAL_SELLING_RATE = "totalSellingRate";
  private String totalSellingRate;

  public static final String JSON_PROPERTY_TOTAL_NET = "totalNet";
  private String totalNet;

  public static final String JSON_PROPERTY_GIATA = "giata";
  private String giata;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_UPSELLING = "upselling";
  private ApiUpsellingCheckRate upselling;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<RoomCheckRate> rooms;

  public static final String JSON_PROPERTY_CREDIT_CARDS = "creditCards";
  private List<ApiCreditCard> creditCards;

  public static final String JSON_PROPERTY_PAYMENT_DATA_REQUIRED = "paymentDataRequired";
  private Boolean paymentDataRequired = false;

  public static final String JSON_PROPERTY_MODIFICATION_POLICIES = "modificationPolicies";
  private ApiModificationPolicies modificationPolicies;

  public ApiHotelCheckRate() {
  }

  public ApiHotelCheckRate checkOut(LocalDate checkOut) {
    
    this.checkOut = checkOut;
    return this;
  }

   /**
   * Check-out date.
   * @return checkOut
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckOut() {
    return checkOut;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckOut(LocalDate checkOut) {
    this.checkOut = checkOut;
  }


  public ApiHotelCheckRate checkIn(LocalDate checkIn) {
    
    this.checkIn = checkIn;
    return this;
  }

   /**
   * Check-in date.
   * @return checkIn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckIn() {
    return checkIn;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckIn(LocalDate checkIn) {
    this.checkIn = checkIn;
  }


  public ApiHotelCheckRate code(Integer code) {
    
    this.code = code;
    return this;
  }

   /**
   * Hotelbeds internal hotel code.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public ApiHotelCheckRate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the hotel.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ApiHotelCheckRate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Hotel description.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ApiHotelCheckRate categoryCode(String categoryCode) {
    
    this.categoryCode = categoryCode;
    return this;
  }

   /**
   * Hotelbeds code of the hotel category.
   * @return categoryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryCode() {
    return categoryCode;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }


  public ApiHotelCheckRate categoryName(String categoryName) {
    
    this.categoryName = categoryName;
    return this;
  }

   /**
   * Name of the hotel category.
   * @return categoryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryName() {
    return categoryName;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }


  public ApiHotelCheckRate destinationCode(String destinationCode) {
    
    this.destinationCode = destinationCode;
    return this;
  }

   /**
   * Code of the destination of the hotel location.
   * @return destinationCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationCode() {
    return destinationCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationCode(String destinationCode) {
    this.destinationCode = destinationCode;
  }


  public ApiHotelCheckRate destinationName(String destinationName) {
    
    this.destinationName = destinationName;
    return this;
  }

   /**
   * Name of the destination of the hotel location.
   * @return destinationName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationName() {
    return destinationName;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationName(String destinationName) {
    this.destinationName = destinationName;
  }


  public ApiHotelCheckRate zoneCode(Integer zoneCode) {
    
    this.zoneCode = zoneCode;
    return this;
  }

   /**
   * Code of the zone of the hotel location.
   * @return zoneCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getZoneCode() {
    return zoneCode;
  }


  @JsonProperty(JSON_PROPERTY_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoneCode(Integer zoneCode) {
    this.zoneCode = zoneCode;
  }


  public ApiHotelCheckRate zoneName(String zoneName) {
    
    this.zoneName = zoneName;
    return this;
  }

   /**
   * Name of the zone of the hotel location.
   * @return zoneName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ZONE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getZoneName() {
    return zoneName;
  }


  @JsonProperty(JSON_PROPERTY_ZONE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoneName(String zoneName) {
    this.zoneName = zoneName;
  }


  public ApiHotelCheckRate latitude(String latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude coordinate of the hotel location.
   * @return latitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }


  public ApiHotelCheckRate longitude(String longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude coordinate of the hotel location.
   * @return longitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }


  public ApiHotelCheckRate minRate(String minRate) {
    
    this.minRate = minRate;
    return this;
  }

   /**
   * Minimum hotel room price.
   * @return minRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinRate() {
    return minRate;
  }


  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinRate(String minRate) {
    this.minRate = minRate;
  }


  public ApiHotelCheckRate maxRate(String maxRate) {
    
    this.maxRate = maxRate;
    return this;
  }

   /**
   * Maximum hotel room price.
   * @return maxRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxRate() {
    return maxRate;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRate(String maxRate) {
    this.maxRate = maxRate;
  }


  public ApiHotelCheckRate totalSellingRate(String totalSellingRate) {
    
    this.totalSellingRate = totalSellingRate;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalSellingRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalSellingRate() {
    return totalSellingRate;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSellingRate(String totalSellingRate) {
    this.totalSellingRate = totalSellingRate;
  }


  public ApiHotelCheckRate totalNet(String totalNet) {
    
    this.totalNet = totalNet;
    return this;
  }

   /**
   * Total amount of the booking.
   * @return totalNet
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalNet() {
    return totalNet;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalNet(String totalNet) {
    this.totalNet = totalNet;
  }


  public ApiHotelCheckRate giata(String giata) {
    
    this.giata = giata;
    return this;
  }

   /**
   * Giata hotel code.
   * @return giata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GIATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGiata() {
    return giata;
  }


  @JsonProperty(JSON_PROPERTY_GIATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGiata(String giata) {
    this.giata = giata;
  }


  public ApiHotelCheckRate currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Client currency.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public ApiHotelCheckRate upselling(ApiUpsellingCheckRate upselling) {
    
    this.upselling = upselling;
    return this;
  }

   /**
   * Get upselling
   * @return upselling
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_UPSELLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiUpsellingCheckRate getUpselling() {
    return upselling;
  }


  @JsonProperty(JSON_PROPERTY_UPSELLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpselling(ApiUpsellingCheckRate upselling) {
    this.upselling = upselling;
  }


  public ApiHotelCheckRate rooms(List<RoomCheckRate> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public ApiHotelCheckRate addRoomsItem(RoomCheckRate roomsItem) {
    if (this.rooms == null) {
      this.rooms = new ArrayList<>();
    }
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * Get rooms
   * @return rooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomCheckRate> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(List<RoomCheckRate> rooms) {
    this.rooms = rooms;
  }


  public ApiHotelCheckRate creditCards(List<ApiCreditCard> creditCards) {
    
    this.creditCards = creditCards;
    return this;
  }

  public ApiHotelCheckRate addCreditCardsItem(ApiCreditCard creditCardsItem) {
    if (this.creditCards == null) {
      this.creditCards = new ArrayList<>();
    }
    this.creditCards.add(creditCardsItem);
    return this;
  }

   /**
   * List of credit cards accepted by the hotel.
   * @return creditCards
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREDIT_CARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiCreditCard> getCreditCards() {
    return creditCards;
  }


  @JsonProperty(JSON_PROPERTY_CREDIT_CARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreditCards(List<ApiCreditCard> creditCards) {
    this.creditCards = creditCards;
  }


  public ApiHotelCheckRate paymentDataRequired(Boolean paymentDataRequired) {
    
    this.paymentDataRequired = paymentDataRequired;
    return this;
  }

   /**
   * Indicates the need for payment data(i.e.: credit card details) in order to finish the booking.
   * @return paymentDataRequired
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPaymentDataRequired() {
    return paymentDataRequired;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentDataRequired(Boolean paymentDataRequired) {
    this.paymentDataRequired = paymentDataRequired;
  }


  public ApiHotelCheckRate modificationPolicies(ApiModificationPolicies modificationPolicies) {
    
    this.modificationPolicies = modificationPolicies;
    return this;
  }

   /**
   * Get modificationPolicies
   * @return modificationPolicies
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFICATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiModificationPolicies getModificationPolicies() {
    return modificationPolicies;
  }


  @JsonProperty(JSON_PROPERTY_MODIFICATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationPolicies(ApiModificationPolicies modificationPolicies) {
    this.modificationPolicies = modificationPolicies;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelCheckRate apiHotelCheckRate = (ApiHotelCheckRate) o;
    return Objects.equals(this.checkOut, apiHotelCheckRate.checkOut) &&
        Objects.equals(this.checkIn, apiHotelCheckRate.checkIn) &&
        Objects.equals(this.code, apiHotelCheckRate.code) &&
        Objects.equals(this.name, apiHotelCheckRate.name) &&
        Objects.equals(this.description, apiHotelCheckRate.description) &&
        Objects.equals(this.categoryCode, apiHotelCheckRate.categoryCode) &&
        Objects.equals(this.categoryName, apiHotelCheckRate.categoryName) &&
        Objects.equals(this.destinationCode, apiHotelCheckRate.destinationCode) &&
        Objects.equals(this.destinationName, apiHotelCheckRate.destinationName) &&
        Objects.equals(this.zoneCode, apiHotelCheckRate.zoneCode) &&
        Objects.equals(this.zoneName, apiHotelCheckRate.zoneName) &&
        Objects.equals(this.latitude, apiHotelCheckRate.latitude) &&
        Objects.equals(this.longitude, apiHotelCheckRate.longitude) &&
        Objects.equals(this.minRate, apiHotelCheckRate.minRate) &&
        Objects.equals(this.maxRate, apiHotelCheckRate.maxRate) &&
        Objects.equals(this.totalSellingRate, apiHotelCheckRate.totalSellingRate) &&
        Objects.equals(this.totalNet, apiHotelCheckRate.totalNet) &&
        Objects.equals(this.giata, apiHotelCheckRate.giata) &&
        Objects.equals(this.currency, apiHotelCheckRate.currency) &&
        Objects.equals(this.upselling, apiHotelCheckRate.upselling) &&
        Objects.equals(this.rooms, apiHotelCheckRate.rooms) &&
        Objects.equals(this.creditCards, apiHotelCheckRate.creditCards) &&
        Objects.equals(this.paymentDataRequired, apiHotelCheckRate.paymentDataRequired) &&
        Objects.equals(this.modificationPolicies, apiHotelCheckRate.modificationPolicies);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkOut, checkIn, code, name, description, categoryCode, categoryName, destinationCode, destinationName, zoneCode, zoneName, latitude, longitude, minRate, maxRate, totalSellingRate, totalNet, giata, currency, upselling, rooms, creditCards, paymentDataRequired, modificationPolicies);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelCheckRate {\n");
    sb.append("    checkOut: ").append(toIndentedString(checkOut)).append("\n");
    sb.append("    checkIn: ").append(toIndentedString(checkIn)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    categoryCode: ").append(toIndentedString(categoryCode)).append("\n");
    sb.append("    categoryName: ").append(toIndentedString(categoryName)).append("\n");
    sb.append("    destinationCode: ").append(toIndentedString(destinationCode)).append("\n");
    sb.append("    destinationName: ").append(toIndentedString(destinationName)).append("\n");
    sb.append("    zoneCode: ").append(toIndentedString(zoneCode)).append("\n");
    sb.append("    zoneName: ").append(toIndentedString(zoneName)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    minRate: ").append(toIndentedString(minRate)).append("\n");
    sb.append("    maxRate: ").append(toIndentedString(maxRate)).append("\n");
    sb.append("    totalSellingRate: ").append(toIndentedString(totalSellingRate)).append("\n");
    sb.append("    totalNet: ").append(toIndentedString(totalNet)).append("\n");
    sb.append("    giata: ").append(toIndentedString(giata)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    upselling: ").append(toIndentedString(upselling)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    creditCards: ").append(toIndentedString(creditCards)).append("\n");
    sb.append("    paymentDataRequired: ").append(toIndentedString(paymentDataRequired)).append("\n");
    sb.append("    modificationPolicies: ").append(toIndentedString(modificationPolicies)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

