/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiHotel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Hotel availability information.
 */
@JsonPropertyOrder({
  ApiHotels.JSON_PROPERTY_CHECK_IN,
  ApiHotels.JSON_PROPERTY_CHECK_OUT,
  ApiHotels.JSON_PROPERTY_HOTELS,
  ApiHotels.JSON_PROPERTY_TOTAL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiHotels {
  public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
  private LocalDate checkIn;

  public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
  private LocalDate checkOut;

  public static final String JSON_PROPERTY_HOTELS = "hotels";
  private List<ApiHotel> hotels;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private Integer total;

  public ApiHotels() {
  }

  public ApiHotels checkIn(LocalDate checkIn) {
    
    this.checkIn = checkIn;
    return this;
  }

   /**
   * Check-in date in the current availability response.
   * @return checkIn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckIn() {
    return checkIn;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckIn(LocalDate checkIn) {
    this.checkIn = checkIn;
  }


  public ApiHotels checkOut(LocalDate checkOut) {
    
    this.checkOut = checkOut;
    return this;
  }

   /**
   * Check-out date in the current availability response.
   * @return checkOut
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckOut() {
    return checkOut;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckOut(LocalDate checkOut) {
    this.checkOut = checkOut;
  }


  public ApiHotels hotels(List<ApiHotel> hotels) {
    
    this.hotels = hotels;
    return this;
  }

  public ApiHotels addHotelsItem(ApiHotel hotelsItem) {
    if (this.hotels == null) {
      this.hotels = new ArrayList<>();
    }
    this.hotels.add(hotelsItem);
    return this;
  }

   /**
   * Information regarding the hotels.
   * @return hotels
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotel> getHotels() {
    return hotels;
  }


  @JsonProperty(JSON_PROPERTY_HOTELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotels(List<ApiHotel> hotels) {
    this.hotels = hotels;
  }


  public ApiHotels total(Integer total) {
    
    this.total = total;
    return this;
  }

   /**
   * Total of hotels returned in the current availability response.
   * @return total
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(Integer total) {
    this.total = total;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotels apiHotels = (ApiHotels) o;
    return Objects.equals(this.checkIn, apiHotels.checkIn) &&
        Objects.equals(this.checkOut, apiHotels.checkOut) &&
        Objects.equals(this.hotels, apiHotels.hotels) &&
        Objects.equals(this.total, apiHotels.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkIn, checkOut, hotels, total);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotels {\n");
    sb.append("    checkIn: ").append(toIndentedString(checkIn)).append("\n");
    sb.append("    checkOut: ").append(toIndentedString(checkOut)).append("\n");
    sb.append("    hotels: ").append(toIndentedString(hotels)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

