/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaxAvail;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Definition of passengers groups and how they are distributed in different rooms.
 */
@JsonPropertyOrder({
  ApiOccupancy.JSON_PROPERTY_ROOMS,
  ApiOccupancy.JSON_PROPERTY_ADULTS,
  ApiOccupancy.JSON_PROPERTY_CHILDREN,
  ApiOccupancy.JSON_PROPERTY_PAXES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiOccupancy {
  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_PAXES = "paxes";
  private List<ApiPaxAvail> paxes;

  public ApiOccupancy() {
  }

  public ApiOccupancy rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of requested rooms of this occupancy.
   * minimum: 1
   * @return rooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public ApiOccupancy adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Number of adult passengers for this room.
   * minimum: 1
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public ApiOccupancy children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * number of child passengers for this room.
   * minimum: 0
   * @return children
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public ApiOccupancy paxes(List<ApiPaxAvail> paxes) {
    
    this.paxes = paxes;
    return this;
  }

  public ApiOccupancy addPaxesItem(ApiPaxAvail paxesItem) {
    if (this.paxes == null) {
      this.paxes = new ArrayList<>();
    }
    this.paxes.add(paxesItem);
    return this;
  }

   /**
   * List of paxes for the room.
   * @return paxes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiPaxAvail> getPaxes() {
    return paxes;
  }


  @JsonProperty(JSON_PROPERTY_PAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaxes(List<ApiPaxAvail> paxes) {
    this.paxes = paxes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiOccupancy apiOccupancy = (ApiOccupancy) o;
    return Objects.equals(this.rooms, apiOccupancy.rooms) &&
        Objects.equals(this.adults, apiOccupancy.adults) &&
        Objects.equals(this.children, apiOccupancy.children) &&
        Objects.equals(this.paxes, apiOccupancy.paxes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rooms, adults, children, paxes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiOccupancy {\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    paxes: ").append(toIndentedString(paxes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

