/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Passenger information.
 */
@JsonPropertyOrder({
  ApiPax.JSON_PROPERTY_ROOM_ID,
  ApiPax.JSON_PROPERTY_TYPE,
  ApiPax.JSON_PROPERTY_AGE,
  ApiPax.JSON_PROPERTY_NAME,
  ApiPax.JSON_PROPERTY_SURNAME
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiPax {
  public static final String JSON_PROPERTY_ROOM_ID = "roomId";
  private Integer roomId;

  /**
   * Passenger type, defines if the passenger is adult or child.
   */
  public enum TypeEnum {
    AD("AD"),
    
    CH("CH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_AGE = "age";
  private Integer age;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SURNAME = "surname";
  private String surname;

  public ApiPax() {
  }

  public ApiPax roomId(Integer roomId) {
    
    this.roomId = roomId;
    return this;
  }

   /**
   * Get roomId
   * minimum: 1
   * @return roomId
  **/
  @jakarta.annotation.Nullable
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ROOM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRoomId() {
    return roomId;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomId(Integer roomId) {
    this.roomId = roomId;
  }


  public ApiPax type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Passenger type, defines if the passenger is adult or child.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ApiPax age(Integer age) {
    
    this.age = age;
    return this;
  }

   /**
   * Age of the passenger (required for children passengers). Please make sure to use the same ages in confirmation step to those you used in the availability step; the ages cannot be changed once the booking flow has started
   * minimum: 0
   * maximum: 99
   * @return age
  **/
  @jakarta.annotation.Nullable
 @Min(0) @Max(99)
  @JsonProperty(JSON_PROPERTY_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAge() {
    return age;
  }


  @JsonProperty(JSON_PROPERTY_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAge(Integer age) {
    this.age = age;
  }


  public ApiPax name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the passenger.
   * @return name
  **/
  @jakarta.annotation.Nullable
 @Size(min=1,max=50)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ApiPax surname(String surname) {
    
    this.surname = surname;
    return this;
  }

   /**
   * Surname of the passenger.
   * @return surname
  **/
  @jakarta.annotation.Nullable
 @Size(min=0,max=50)
  @JsonProperty(JSON_PROPERTY_SURNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSurname() {
    return surname;
  }


  @JsonProperty(JSON_PROPERTY_SURNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSurname(String surname) {
    this.surname = surname;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiPax apiPax = (ApiPax) o;
    return Objects.equals(this.roomId, apiPax.roomId) &&
        Objects.equals(this.type, apiPax.type) &&
        Objects.equals(this.age, apiPax.age) &&
        Objects.equals(this.name, apiPax.name) &&
        Objects.equals(this.surname, apiPax.surname);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roomId, type, age, name, surname);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiPax {\n");
    sb.append("    roomId: ").append(toIndentedString(roomId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    age: ").append(toIndentedString(age)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    surname: ").append(toIndentedString(surname)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

