/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Credit card information.
 */
@JsonPropertyOrder({
  ApiPaymentCard.JSON_PROPERTY_CARD_TYPE,
  ApiPaymentCard.JSON_PROPERTY_CARD_NUMBER,
  ApiPaymentCard.JSON_PROPERTY_CARD_HOLDER_NAME,
  ApiPaymentCard.JSON_PROPERTY_EXPIRY_DATE,
  ApiPaymentCard.JSON_PROPERTY_CARD_C_V_C
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiPaymentCard {
  /**
   * Credit card type.
   */
  public enum CardTypeEnum {
    AMEX("AMEX"),
    
    EURO6000("EURO6000"),
    
    JCB("JCB"),
    
    DINERS("DINERS"),
    
    MASTERCARD("MASTERCARD"),
    
    VISA("VISA"),
    
    MAESTRO("MAESTRO"),
    
    SWITCH("SWITCH"),
    
    SOLO_GB("SOLO_GB"),
    
    AIRPLUS("AIRPLUS"),
    
    EURO60002("EURO6000"),
    
    CHINAUNIONPAY("CHINAUNIONPAY"),
    
    DISCOVER("DISCOVER");

    private String value;

    CardTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CardTypeEnum fromValue(String value) {
      for (CardTypeEnum b : CardTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CARD_TYPE = "cardType";
  private CardTypeEnum cardType;

  public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
  private String cardNumber;

  public static final String JSON_PROPERTY_CARD_HOLDER_NAME = "cardHolderName";
  private String cardHolderName;

  public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
  private String expiryDate;

  public static final String JSON_PROPERTY_CARD_C_V_C = "cardCVC";
  private String cardCVC;

  public ApiPaymentCard() {
  }

  public ApiPaymentCard cardType(CardTypeEnum cardType) {
    
    this.cardType = cardType;
    return this;
  }

   /**
   * Credit card type.
   * @return cardType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CARD_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CardTypeEnum getCardType() {
    return cardType;
  }


  @JsonProperty(JSON_PROPERTY_CARD_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardType(CardTypeEnum cardType) {
    this.cardType = cardType;
  }


  public ApiPaymentCard cardNumber(String cardNumber) {
    
    this.cardNumber = cardNumber;
    return this;
  }

   /**
   * Credit card number (without spaces).
   * @return cardNumber
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCardNumber() {
    return cardNumber;
  }


  @JsonProperty(JSON_PROPERTY_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardNumber(String cardNumber) {
    this.cardNumber = cardNumber;
  }


  public ApiPaymentCard cardHolderName(String cardHolderName) {
    
    this.cardHolderName = cardHolderName;
    return this;
  }

   /**
   * Name of the credit card holder exactly as it appears on the credit card.
   * @return cardHolderName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CARD_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCardHolderName() {
    return cardHolderName;
  }


  @JsonProperty(JSON_PROPERTY_CARD_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardHolderName(String cardHolderName) {
    this.cardHolderName = cardHolderName;
  }


  public ApiPaymentCard expiryDate(String expiryDate) {
    
    this.expiryDate = expiryDate;
    return this;
  }

   /**
   * Expiration date of the credit card;
   * @return expiryDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXPIRY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExpiryDate() {
    return expiryDate;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpiryDate(String expiryDate) {
    this.expiryDate = expiryDate;
  }


  public ApiPaymentCard cardCVC(String cardCVC) {
    
    this.cardCVC = cardCVC;
    return this;
  }

   /**
   * CVC security code of the credit card.
   * @return cardCVC
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CARD_C_V_C)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCardCVC() {
    return cardCVC;
  }


  @JsonProperty(JSON_PROPERTY_CARD_C_V_C)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardCVC(String cardCVC) {
    this.cardCVC = cardCVC;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiPaymentCard apiPaymentCard = (ApiPaymentCard) o;
    return Objects.equals(this.cardType, apiPaymentCard.cardType) &&
        Objects.equals(this.cardNumber, apiPaymentCard.cardNumber) &&
        Objects.equals(this.cardHolderName, apiPaymentCard.cardHolderName) &&
        Objects.equals(this.expiryDate, apiPaymentCard.expiryDate) &&
        Objects.equals(this.cardCVC, apiPaymentCard.cardCVC);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardType, cardNumber, cardHolderName, expiryDate, cardCVC);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiPaymentCard {\n");
    sb.append("    cardType: ").append(toIndentedString(cardType)).append("\n");
    sb.append("    cardNumber: ").append(toIndentedString(cardNumber)).append("\n");
    sb.append("    cardHolderName: ").append(toIndentedString(cardHolderName)).append("\n");
    sb.append("    expiryDate: ").append(toIndentedString(expiryDate)).append("\n");
    sb.append("    cardCVC: ").append(toIndentedString(cardCVC)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

