/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.booking.sdk.model.ApiBillingAddress;
import travel.wink.hotelbeds.booking.sdk.model.ApiBookingDevice;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaymentCard;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaymentContactData;
import travel.wink.hotelbeds.booking.sdk.model.ThreeDsData;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payment information. This is mandatory for rates with clients accounts setup as credit card payment.
 */
@JsonPropertyOrder({
  ApiPaymentData.JSON_PROPERTY_PAYMENT_CARD,
  ApiPaymentData.JSON_PROPERTY_CONTACT_DATA,
  ApiPaymentData.JSON_PROPERTY_BILLING_ADDRESS,
  ApiPaymentData.JSON_PROPERTY_THREE_DS_DATA,
  ApiPaymentData.JSON_PROPERTY_WEB_PARTNER,
  ApiPaymentData.JSON_PROPERTY_DEVICE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiPaymentData {
  public static final String JSON_PROPERTY_PAYMENT_CARD = "paymentCard";
  private ApiPaymentCard paymentCard;

  public static final String JSON_PROPERTY_CONTACT_DATA = "contactData";
  private ApiPaymentContactData contactData;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private ApiBillingAddress billingAddress;

  public static final String JSON_PROPERTY_THREE_DS_DATA = "threeDsData";
  private ThreeDsData threeDsData;

  public static final String JSON_PROPERTY_WEB_PARTNER = "webPartner";
  private Integer webPartner;

  public static final String JSON_PROPERTY_DEVICE = "device";
  private ApiBookingDevice device;

  public ApiPaymentData() {
  }

  public ApiPaymentData paymentCard(ApiPaymentCard paymentCard) {
    
    this.paymentCard = paymentCard;
    return this;
  }

   /**
   * Get paymentCard
   * @return paymentCard
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT_CARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApiPaymentCard getPaymentCard() {
    return paymentCard;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_CARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentCard(ApiPaymentCard paymentCard) {
    this.paymentCard = paymentCard;
  }


  public ApiPaymentData contactData(ApiPaymentContactData contactData) {
    
    this.contactData = contactData;
    return this;
  }

   /**
   * Get contactData
   * @return contactData
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT_DATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApiPaymentContactData getContactData() {
    return contactData;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_DATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactData(ApiPaymentContactData contactData) {
    this.contactData = contactData;
  }


  public ApiPaymentData billingAddress(ApiBillingAddress billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiBillingAddress getBillingAddress() {
    return billingAddress;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(ApiBillingAddress billingAddress) {
    this.billingAddress = billingAddress;
  }


  public ApiPaymentData threeDsData(ThreeDsData threeDsData) {
    
    this.threeDsData = threeDsData;
    return this;
  }

   /**
   * Get threeDsData
   * @return threeDsData
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THREE_DS_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDsData getThreeDsData() {
    return threeDsData;
  }


  @JsonProperty(JSON_PROPERTY_THREE_DS_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDsData(ThreeDsData threeDsData) {
    this.threeDsData = threeDsData;
  }


  public ApiPaymentData webPartner(Integer webPartner) {
    
    this.webPartner = webPartner;
    return this;
  }

   /**
   * Identifies web partners bookings. Only required when using the end user&#39;s credit card.
   * @return webPartner
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEB_PARTNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWebPartner() {
    return webPartner;
  }


  @JsonProperty(JSON_PROPERTY_WEB_PARTNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebPartner(Integer webPartner) {
    this.webPartner = webPartner;
  }


  public ApiPaymentData device(ApiBookingDevice device) {
    
    this.device = device;
    return this;
  }

   /**
   * Get device
   * @return device
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DEVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiBookingDevice getDevice() {
    return device;
  }


  @JsonProperty(JSON_PROPERTY_DEVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDevice(ApiBookingDevice device) {
    this.device = device;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiPaymentData apiPaymentData = (ApiPaymentData) o;
    return Objects.equals(this.paymentCard, apiPaymentData.paymentCard) &&
        Objects.equals(this.contactData, apiPaymentData.contactData) &&
        Objects.equals(this.billingAddress, apiPaymentData.billingAddress) &&
        Objects.equals(this.threeDsData, apiPaymentData.threeDsData) &&
        Objects.equals(this.webPartner, apiPaymentData.webPartner) &&
        Objects.equals(this.device, apiPaymentData.device);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentCard, contactData, billingAddress, threeDsData, webPartner, device);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiPaymentData {\n");
    sb.append("    paymentCard: ").append(toIndentedString(paymentCard)).append("\n");
    sb.append("    contactData: ").append(toIndentedString(contactData)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    threeDsData: ").append(toIndentedString(threeDsData)).append("\n");
    sb.append("    webPartner: ").append(toIndentedString(webPartner)).append("\n");
    sb.append("    device: ").append(toIndentedString(device)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

