/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiCancellationPolicy;
import travel.wink.hotelbeds.booking.sdk.model.ApiDailyRate;
import travel.wink.hotelbeds.booking.sdk.model.ApiOffer;
import travel.wink.hotelbeds.booking.sdk.model.ApiPromotion;
import travel.wink.hotelbeds.booking.sdk.model.ApiShiftRate;
import travel.wink.hotelbeds.booking.sdk.model.ApiTaxes;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Definition of a rate.
 */
@JsonPropertyOrder({
  ApiRate.JSON_PROPERTY_RATE_KEY,
  ApiRate.JSON_PROPERTY_RATE_CLASS,
  ApiRate.JSON_PROPERTY_RATE_TYPE,
  ApiRate.JSON_PROPERTY_NET,
  ApiRate.JSON_PROPERTY_DISCOUNT,
  ApiRate.JSON_PROPERTY_DISCOUNT_P_C_T,
  ApiRate.JSON_PROPERTY_SELLING_RATE,
  ApiRate.JSON_PROPERTY_HOTEL_MANDATORY,
  ApiRate.JSON_PROPERTY_ALLOTMENT,
  ApiRate.JSON_PROPERTY_COMMISSION,
  ApiRate.JSON_PROPERTY_COMMISSION_V_A_T,
  ApiRate.JSON_PROPERTY_COMMISSION_P_C_T,
  ApiRate.JSON_PROPERTY_RATE_COMMENTS_ID,
  ApiRate.JSON_PROPERTY_RATE_COMMENTS,
  ApiRate.JSON_PROPERTY_PACKAGING,
  ApiRate.JSON_PROPERTY_BOARD_CODE,
  ApiRate.JSON_PROPERTY_BOARD_NAME,
  ApiRate.JSON_PROPERTY_ROOMS,
  ApiRate.JSON_PROPERTY_ADULTS,
  ApiRate.JSON_PROPERTY_CHILDREN,
  ApiRate.JSON_PROPERTY_CHILDREN_AGES,
  ApiRate.JSON_PROPERTY_RATEUP,
  ApiRate.JSON_PROPERTY_BRAND,
  ApiRate.JSON_PROPERTY_RESIDENT,
  ApiRate.JSON_PROPERTY_CANCELLATION_POLICIES,
  ApiRate.JSON_PROPERTY_TAXES,
  ApiRate.JSON_PROPERTY_PROMOTIONS,
  ApiRate.JSON_PROPERTY_OFFERS,
  ApiRate.JSON_PROPERTY_SHIFT_RATES,
  ApiRate.JSON_PROPERTY_DAILY_RATES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiRate {
  public static final String JSON_PROPERTY_RATE_KEY = "rateKey";
  private String rateKey;

  public static final String JSON_PROPERTY_RATE_CLASS = "rateClass";
  private String rateClass;

  /**
   * Determines if can booked directly (BOOKABLE) or if it needs to be checked with the ‘CheckRate’ operation (RECHECK).
   */
  public enum RateTypeEnum {
    BOOKABLE("BOOKABLE"),
    
    RECHECK("RECHECK");

    private String value;

    RateTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateTypeEnum fromValue(String value) {
      for (RateTypeEnum b : RateTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_TYPE = "rateType";
  private RateTypeEnum rateType;

  public static final String JSON_PROPERTY_NET = "net";
  private String net;

  public static final String JSON_PROPERTY_DISCOUNT = "discount";
  private String discount;

  public static final String JSON_PROPERTY_DISCOUNT_P_C_T = "discountPCT";
  private String discountPCT;

  public static final String JSON_PROPERTY_SELLING_RATE = "sellingRate";
  private String sellingRate;

  public static final String JSON_PROPERTY_HOTEL_MANDATORY = "hotelMandatory";
  private Boolean hotelMandatory = false;

  public static final String JSON_PROPERTY_ALLOTMENT = "allotment";
  private Integer allotment;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private String commission;

  public static final String JSON_PROPERTY_COMMISSION_V_A_T = "commissionVAT";
  private String commissionVAT;

  public static final String JSON_PROPERTY_COMMISSION_P_C_T = "commissionPCT";
  private String commissionPCT;

  public static final String JSON_PROPERTY_RATE_COMMENTS_ID = "rateCommentsId";
  private String rateCommentsId;

  public static final String JSON_PROPERTY_RATE_COMMENTS = "rateComments";
  private String rateComments;

  public static final String JSON_PROPERTY_PACKAGING = "packaging";
  private Boolean packaging = false;

  public static final String JSON_PROPERTY_BOARD_CODE = "boardCode";
  private String boardCode;

  public static final String JSON_PROPERTY_BOARD_NAME = "boardName";
  private String boardName;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_CHILDREN_AGES = "childrenAges";
  private String childrenAges;

  public static final String JSON_PROPERTY_RATEUP = "rateup";
  private String rateup;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_RESIDENT = "resident";
  private Boolean resident = false;

  public static final String JSON_PROPERTY_CANCELLATION_POLICIES = "cancellationPolicies";
  private List<ApiCancellationPolicy> cancellationPolicies;

  public static final String JSON_PROPERTY_TAXES = "taxes";
  private ApiTaxes taxes;

  public static final String JSON_PROPERTY_PROMOTIONS = "promotions";
  private List<ApiPromotion> promotions;

  public static final String JSON_PROPERTY_OFFERS = "offers";
  private List<ApiOffer> offers;

  public static final String JSON_PROPERTY_SHIFT_RATES = "shiftRates";
  private List<ApiShiftRate> shiftRates;

  public static final String JSON_PROPERTY_DAILY_RATES = "dailyRates";
  private List<ApiDailyRate> dailyRates;

  public ApiRate() {
  }

  public ApiRate rateKey(String rateKey) {
    
    this.rateKey = rateKey;
    return this;
  }

   /**
   * Internal key that represents a combination of room type, category, board and occupancy. Is returned in Availability and used to valuate a rate and confirm a booking.
   * @return rateKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateKey() {
    return rateKey;
  }


  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateKey(String rateKey) {
    this.rateKey = rateKey;
  }


  public ApiRate rateClass(String rateClass) {
    
    this.rateClass = rateClass;
    return this;
  }

   /**
   * Class of the rate.
   * @return rateClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateClass() {
    return rateClass;
  }


  @JsonProperty(JSON_PROPERTY_RATE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateClass(String rateClass) {
    this.rateClass = rateClass;
  }


  public ApiRate rateType(RateTypeEnum rateType) {
    
    this.rateType = rateType;
    return this;
  }

   /**
   * Determines if can booked directly (BOOKABLE) or if it needs to be checked with the ‘CheckRate’ operation (RECHECK).
   * @return rateType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateTypeEnum getRateType() {
    return rateType;
  }


  @JsonProperty(JSON_PROPERTY_RATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateType(RateTypeEnum rateType) {
    this.rateType = rateType;
  }


  public ApiRate net(String net) {
    
    this.net = net;
    return this;
  }

   /**
   * Net price of the rate.
   * @return net
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNet() {
    return net;
  }


  @JsonProperty(JSON_PROPERTY_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNet(String net) {
    this.net = net;
  }


  public ApiRate discount(String discount) {
    
    this.discount = discount;
    return this;
  }

   /**
   * Profit margin that the agency would take if it sells at that recommended price.
   * @return discount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscount() {
    return discount;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscount(String discount) {
    this.discount = discount;
  }


  public ApiRate discountPCT(String discountPCT) {
    
    this.discountPCT = discountPCT;
    return this;
  }

   /**
   * Percentual share of the price corresponding to the profit margin the agency would take if it sells at that recommended price.
   * @return discountPCT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNT_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscountPCT() {
    return discountPCT;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscountPCT(String discountPCT) {
    this.discountPCT = discountPCT;
  }


  public ApiRate sellingRate(String sellingRate) {
    
    this.sellingRate = sellingRate;
    return this;
  }

   /**
   * Gross price of the room in case it is included.
   * @return sellingRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSellingRate() {
    return sellingRate;
  }


  @JsonProperty(JSON_PROPERTY_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellingRate(String sellingRate) {
    this.sellingRate = sellingRate;
  }


  public ApiRate hotelMandatory(Boolean hotelMandatory) {
    
    this.hotelMandatory = hotelMandatory;
    return this;
  }

   /**
   * Identifies if the rate price is recommended.
   * @return hotelMandatory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelMandatory() {
    return hotelMandatory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelMandatory(Boolean hotelMandatory) {
    this.hotelMandatory = hotelMandatory;
  }


  public ApiRate allotment(Integer allotment) {
    
    this.allotment = allotment;
    return this;
  }

   /**
   * Number of rooms available for a particular room type.
   * @return allotment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLOTMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAllotment() {
    return allotment;
  }


  @JsonProperty(JSON_PROPERTY_ALLOTMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllotment(Integer allotment) {
    this.allotment = allotment;
  }


  public ApiRate commission(String commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Profit margin the agency takes (commissionable model).
   * @return commission
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(String commission) {
    this.commission = commission;
  }


  public ApiRate commissionVAT(String commissionVAT) {
    
    this.commissionVAT = commissionVAT;
    return this;
  }

   /**
   * Share of the commission corresponding to the Value Added Tax.
   * @return commissionVAT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommissionVAT() {
    return commissionVAT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionVAT(String commissionVAT) {
    this.commissionVAT = commissionVAT;
  }


  public ApiRate commissionPCT(String commissionPCT) {
    
    this.commissionPCT = commissionPCT;
    return this;
  }

   /**
   * Percentual share of the price corresponding to commision.
   * @return commissionPCT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommissionPCT() {
    return commissionPCT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionPCT(String commissionPCT) {
    this.commissionPCT = commissionPCT;
  }


  public ApiRate rateCommentsId(String rateCommentsId) {
    
    this.rateCommentsId = rateCommentsId;
    return this;
  }

   /**
   * Comments associated to this rate (more information on [Hotel Content API](/documentation/hotels/content-api/api-reference/) ).
   * @return rateCommentsId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_COMMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateCommentsId() {
    return rateCommentsId;
  }


  @JsonProperty(JSON_PROPERTY_RATE_COMMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateCommentsId(String rateCommentsId) {
    this.rateCommentsId = rateCommentsId;
  }


  public ApiRate rateComments(String rateComments) {
    
    this.rateComments = rateComments;
    return this;
  }

   /**
   * Rate comments that contain important information.
   * @return rateComments
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_COMMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateComments() {
    return rateComments;
  }


  @JsonProperty(JSON_PROPERTY_RATE_COMMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateComments(String rateComments) {
    this.rateComments = rateComments;
  }


  public ApiRate packaging(Boolean packaging) {
    
    this.packaging = packaging;
    return this;
  }

   /**
   * Defines if the rate is for packaging.
   * @return packaging
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PACKAGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPackaging() {
    return packaging;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackaging(Boolean packaging) {
    this.packaging = packaging;
  }


  public ApiRate boardCode(String boardCode) {
    
    this.boardCode = boardCode;
    return this;
  }

   /**
   * Internal board code.
   * @return boardCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOARD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBoardCode() {
    return boardCode;
  }


  @JsonProperty(JSON_PROPERTY_BOARD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardCode(String boardCode) {
    this.boardCode = boardCode;
  }


  public ApiRate boardName(String boardName) {
    
    this.boardName = boardName;
    return this;
  }

   /**
   * Board name/description.
   * @return boardName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOARD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBoardName() {
    return boardName;
  }


  @JsonProperty(JSON_PROPERTY_BOARD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardName(String boardName) {
    this.boardName = boardName;
  }


  public ApiRate rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of rooms requested.
   * @return rooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public ApiRate adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Number of adults requested for each room.
   * @return adults
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public ApiRate children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Number of children requested for each room.
   * @return children
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public ApiRate childrenAges(String childrenAges) {
    
    this.childrenAges = childrenAges;
    return this;
  }

   /**
   * Ages of the children (if any).
   * @return childrenAges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILDREN_AGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChildrenAges() {
    return childrenAges;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN_AGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildrenAges(String childrenAges) {
    this.childrenAges = childrenAges;
  }


  public ApiRate rateup(String rateup) {
    
    this.rateup = rateup;
    return this;
  }

   /**
   * Difference between original rate price and upselling rate price.
   * @return rateup
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATEUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateup() {
    return rateup;
  }


  @JsonProperty(JSON_PROPERTY_RATEUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateup(String rateup) {
    this.rateup = rateup;
  }


  public ApiRate brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Brand of the hotel.
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public ApiRate resident(Boolean resident) {
    
    this.resident = resident;
    return this;
  }

   /**
   * Indicates if the rate is only for residents (only appears when resident rates are requested).
   * @return resident
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResident() {
    return resident;
  }


  @JsonProperty(JSON_PROPERTY_RESIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResident(Boolean resident) {
    this.resident = resident;
  }


  public ApiRate cancellationPolicies(List<ApiCancellationPolicy> cancellationPolicies) {
    
    this.cancellationPolicies = cancellationPolicies;
    return this;
  }

  public ApiRate addCancellationPoliciesItem(ApiCancellationPolicy cancellationPoliciesItem) {
    if (this.cancellationPolicies == null) {
      this.cancellationPolicies = new ArrayList<>();
    }
    this.cancellationPolicies.add(cancellationPoliciesItem);
    return this;
  }

   /**
   * List of cancellation policies on the rate.
   * @return cancellationPolicies
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiCancellationPolicy> getCancellationPolicies() {
    return cancellationPolicies;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicies(List<ApiCancellationPolicy> cancellationPolicies) {
    this.cancellationPolicies = cancellationPolicies;
  }


  public ApiRate taxes(ApiTaxes taxes) {
    
    this.taxes = taxes;
    return this;
  }

   /**
   * Get taxes
   * @return taxes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiTaxes getTaxes() {
    return taxes;
  }


  @JsonProperty(JSON_PROPERTY_TAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxes(ApiTaxes taxes) {
    this.taxes = taxes;
  }


  public ApiRate promotions(List<ApiPromotion> promotions) {
    
    this.promotions = promotions;
    return this;
  }

  public ApiRate addPromotionsItem(ApiPromotion promotionsItem) {
    if (this.promotions == null) {
      this.promotions = new ArrayList<>();
    }
    this.promotions.add(promotionsItem);
    return this;
  }

   /**
   * List of promotions on the rate.
   * @return promotions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PROMOTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiPromotion> getPromotions() {
    return promotions;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotions(List<ApiPromotion> promotions) {
    this.promotions = promotions;
  }


  public ApiRate offers(List<ApiOffer> offers) {
    
    this.offers = offers;
    return this;
  }

  public ApiRate addOffersItem(ApiOffer offersItem) {
    if (this.offers == null) {
      this.offers = new ArrayList<>();
    }
    this.offers.add(offersItem);
    return this;
  }

   /**
   * List of offers on the rate.
   * @return offers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiOffer> getOffers() {
    return offers;
  }


  @JsonProperty(JSON_PROPERTY_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOffers(List<ApiOffer> offers) {
    this.offers = offers;
  }


  public ApiRate shiftRates(List<ApiShiftRate> shiftRates) {
    
    this.shiftRates = shiftRates;
    return this;
  }

  public ApiRate addShiftRatesItem(ApiShiftRate shiftRatesItem) {
    if (this.shiftRates == null) {
      this.shiftRates = new ArrayList<>();
    }
    this.shiftRates.add(shiftRatesItem);
    return this;
  }

   /**
   * Information about rates for alternative dates.
   * @return shiftRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SHIFT_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiShiftRate> getShiftRates() {
    return shiftRates;
  }


  @JsonProperty(JSON_PROPERTY_SHIFT_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShiftRates(List<ApiShiftRate> shiftRates) {
    this.shiftRates = shiftRates;
  }


  public ApiRate dailyRates(List<ApiDailyRate> dailyRates) {
    
    this.dailyRates = dailyRates;
    return this;
  }

  public ApiRate addDailyRatesItem(ApiDailyRate dailyRatesItem) {
    if (this.dailyRates == null) {
      this.dailyRates = new ArrayList<>();
    }
    this.dailyRates.add(dailyRatesItem);
    return this;
  }

   /**
   * Breakdown of the rate for each day of the stay.
   * @return dailyRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAILY_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiDailyRate> getDailyRates() {
    return dailyRates;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRates(List<ApiDailyRate> dailyRates) {
    this.dailyRates = dailyRates;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiRate apiRate = (ApiRate) o;
    return Objects.equals(this.rateKey, apiRate.rateKey) &&
        Objects.equals(this.rateClass, apiRate.rateClass) &&
        Objects.equals(this.rateType, apiRate.rateType) &&
        Objects.equals(this.net, apiRate.net) &&
        Objects.equals(this.discount, apiRate.discount) &&
        Objects.equals(this.discountPCT, apiRate.discountPCT) &&
        Objects.equals(this.sellingRate, apiRate.sellingRate) &&
        Objects.equals(this.hotelMandatory, apiRate.hotelMandatory) &&
        Objects.equals(this.allotment, apiRate.allotment) &&
        Objects.equals(this.commission, apiRate.commission) &&
        Objects.equals(this.commissionVAT, apiRate.commissionVAT) &&
        Objects.equals(this.commissionPCT, apiRate.commissionPCT) &&
        Objects.equals(this.rateCommentsId, apiRate.rateCommentsId) &&
        Objects.equals(this.rateComments, apiRate.rateComments) &&
        Objects.equals(this.packaging, apiRate.packaging) &&
        Objects.equals(this.boardCode, apiRate.boardCode) &&
        Objects.equals(this.boardName, apiRate.boardName) &&
        Objects.equals(this.rooms, apiRate.rooms) &&
        Objects.equals(this.adults, apiRate.adults) &&
        Objects.equals(this.children, apiRate.children) &&
        Objects.equals(this.childrenAges, apiRate.childrenAges) &&
        Objects.equals(this.rateup, apiRate.rateup) &&
        Objects.equals(this.brand, apiRate.brand) &&
        Objects.equals(this.resident, apiRate.resident) &&
        Objects.equals(this.cancellationPolicies, apiRate.cancellationPolicies) &&
        Objects.equals(this.taxes, apiRate.taxes) &&
        Objects.equals(this.promotions, apiRate.promotions) &&
        Objects.equals(this.offers, apiRate.offers) &&
        Objects.equals(this.shiftRates, apiRate.shiftRates) &&
        Objects.equals(this.dailyRates, apiRate.dailyRates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rateKey, rateClass, rateType, net, discount, discountPCT, sellingRate, hotelMandatory, allotment, commission, commissionVAT, commissionPCT, rateCommentsId, rateComments, packaging, boardCode, boardName, rooms, adults, children, childrenAges, rateup, brand, resident, cancellationPolicies, taxes, promotions, offers, shiftRates, dailyRates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiRate {\n");
    sb.append("    rateKey: ").append(toIndentedString(rateKey)).append("\n");
    sb.append("    rateClass: ").append(toIndentedString(rateClass)).append("\n");
    sb.append("    rateType: ").append(toIndentedString(rateType)).append("\n");
    sb.append("    net: ").append(toIndentedString(net)).append("\n");
    sb.append("    discount: ").append(toIndentedString(discount)).append("\n");
    sb.append("    discountPCT: ").append(toIndentedString(discountPCT)).append("\n");
    sb.append("    sellingRate: ").append(toIndentedString(sellingRate)).append("\n");
    sb.append("    hotelMandatory: ").append(toIndentedString(hotelMandatory)).append("\n");
    sb.append("    allotment: ").append(toIndentedString(allotment)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    commissionVAT: ").append(toIndentedString(commissionVAT)).append("\n");
    sb.append("    commissionPCT: ").append(toIndentedString(commissionPCT)).append("\n");
    sb.append("    rateCommentsId: ").append(toIndentedString(rateCommentsId)).append("\n");
    sb.append("    rateComments: ").append(toIndentedString(rateComments)).append("\n");
    sb.append("    packaging: ").append(toIndentedString(packaging)).append("\n");
    sb.append("    boardCode: ").append(toIndentedString(boardCode)).append("\n");
    sb.append("    boardName: ").append(toIndentedString(boardName)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    childrenAges: ").append(toIndentedString(childrenAges)).append("\n");
    sb.append("    rateup: ").append(toIndentedString(rateup)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    resident: ").append(toIndentedString(resident)).append("\n");
    sb.append("    cancellationPolicies: ").append(toIndentedString(cancellationPolicies)).append("\n");
    sb.append("    taxes: ").append(toIndentedString(taxes)).append("\n");
    sb.append("    promotions: ").append(toIndentedString(promotions)).append("\n");
    sb.append("    offers: ").append(toIndentedString(offers)).append("\n");
    sb.append("    shiftRates: ").append(toIndentedString(shiftRates)).append("\n");
    sb.append("    dailyRates: ").append(toIndentedString(dailyRates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

