/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiCancellationPolicyCheckRate;
import travel.wink.hotelbeds.booking.sdk.model.ApiOffer;
import travel.wink.hotelbeds.booking.sdk.model.ApiPromotion;
import travel.wink.hotelbeds.booking.sdk.model.ApiRateBreakDown;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Definition of a rate.
 */
@JsonPropertyOrder({
  ApiRateCheckRate.JSON_PROPERTY_RATE_KEY,
  ApiRateCheckRate.JSON_PROPERTY_RATE_CLASS,
  ApiRateCheckRate.JSON_PROPERTY_RATE_TYPE,
  ApiRateCheckRate.JSON_PROPERTY_NET,
  ApiRateCheckRate.JSON_PROPERTY_DISCOUNT,
  ApiRateCheckRate.JSON_PROPERTY_DISCOUNT_P_C_T,
  ApiRateCheckRate.JSON_PROPERTY_SELLING_RATE,
  ApiRateCheckRate.JSON_PROPERTY_HOTEL_MANDATORY,
  ApiRateCheckRate.JSON_PROPERTY_ALLOTMENT,
  ApiRateCheckRate.JSON_PROPERTY_COMMISSION,
  ApiRateCheckRate.JSON_PROPERTY_COMMISSION_V_A_T,
  ApiRateCheckRate.JSON_PROPERTY_COMMISSION_P_C_T,
  ApiRateCheckRate.JSON_PROPERTY_RATE_COMMENTS,
  ApiRateCheckRate.JSON_PROPERTY_PACKAGING,
  ApiRateCheckRate.JSON_PROPERTY_BOARD_CODE,
  ApiRateCheckRate.JSON_PROPERTY_BOARD_NAME,
  ApiRateCheckRate.JSON_PROPERTY_RATE_BREAK_DOWN,
  ApiRateCheckRate.JSON_PROPERTY_ROOMS,
  ApiRateCheckRate.JSON_PROPERTY_ADULTS,
  ApiRateCheckRate.JSON_PROPERTY_CHILDREN,
  ApiRateCheckRate.JSON_PROPERTY_RESIDENT,
  ApiRateCheckRate.JSON_PROPERTY_CANCELLATION_POLICIES,
  ApiRateCheckRate.JSON_PROPERTY_PROMOTIONS,
  ApiRateCheckRate.JSON_PROPERTY_OFFERS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiRateCheckRate {
  public static final String JSON_PROPERTY_RATE_KEY = "rateKey";
  private String rateKey;

  public static final String JSON_PROPERTY_RATE_CLASS = "rateClass";
  private String rateClass;

  /**
   * Determines if can booked directly (BOOKABLE) or if it needs to be checked with the ‘CheckRate’ operation (RECHECK).
   */
  public enum RateTypeEnum {
    BOOKABLE("BOOKABLE"),
    
    RECHECK("RECHECK");

    private String value;

    RateTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateTypeEnum fromValue(String value) {
      for (RateTypeEnum b : RateTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_TYPE = "rateType";
  private RateTypeEnum rateType;

  public static final String JSON_PROPERTY_NET = "net";
  private String net;

  public static final String JSON_PROPERTY_DISCOUNT = "discount";
  private String discount;

  public static final String JSON_PROPERTY_DISCOUNT_P_C_T = "discountPCT";
  private String discountPCT;

  public static final String JSON_PROPERTY_SELLING_RATE = "sellingRate";
  private String sellingRate;

  public static final String JSON_PROPERTY_HOTEL_MANDATORY = "hotelMandatory";
  private Boolean hotelMandatory = false;

  public static final String JSON_PROPERTY_ALLOTMENT = "allotment";
  private Integer allotment;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private String commission;

  public static final String JSON_PROPERTY_COMMISSION_V_A_T = "commissionVAT";
  private String commissionVAT;

  public static final String JSON_PROPERTY_COMMISSION_P_C_T = "commissionPCT";
  private String commissionPCT;

  public static final String JSON_PROPERTY_RATE_COMMENTS = "rateComments";
  private String rateComments;

  public static final String JSON_PROPERTY_PACKAGING = "packaging";
  private Boolean packaging = false;

  public static final String JSON_PROPERTY_BOARD_CODE = "boardCode";
  private String boardCode;

  public static final String JSON_PROPERTY_BOARD_NAME = "boardName";
  private String boardName;

  public static final String JSON_PROPERTY_RATE_BREAK_DOWN = "rateBreakDown";
  private ApiRateBreakDown rateBreakDown;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_RESIDENT = "resident";
  private Boolean resident = false;

  public static final String JSON_PROPERTY_CANCELLATION_POLICIES = "cancellationPolicies";
  private List<ApiCancellationPolicyCheckRate> cancellationPolicies;

  public static final String JSON_PROPERTY_PROMOTIONS = "promotions";
  private List<ApiPromotion> promotions;

  public static final String JSON_PROPERTY_OFFERS = "offers";
  private List<ApiOffer> offers;

  public ApiRateCheckRate() {
  }

  public ApiRateCheckRate rateKey(String rateKey) {
    
    this.rateKey = rateKey;
    return this;
  }

   /**
   * Internal key that represents a combination of room type, category, board and occupancy. Is returned in Availability and used to valuate a rate and confirm a booking.
   * @return rateKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateKey() {
    return rateKey;
  }


  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateKey(String rateKey) {
    this.rateKey = rateKey;
  }


  public ApiRateCheckRate rateClass(String rateClass) {
    
    this.rateClass = rateClass;
    return this;
  }

   /**
   * Class of the rate.
   * @return rateClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateClass() {
    return rateClass;
  }


  @JsonProperty(JSON_PROPERTY_RATE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateClass(String rateClass) {
    this.rateClass = rateClass;
  }


  public ApiRateCheckRate rateType(RateTypeEnum rateType) {
    
    this.rateType = rateType;
    return this;
  }

   /**
   * Determines if can booked directly (BOOKABLE) or if it needs to be checked with the ‘CheckRate’ operation (RECHECK).
   * @return rateType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateTypeEnum getRateType() {
    return rateType;
  }


  @JsonProperty(JSON_PROPERTY_RATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateType(RateTypeEnum rateType) {
    this.rateType = rateType;
  }


  public ApiRateCheckRate net(String net) {
    
    this.net = net;
    return this;
  }

   /**
   * Net price of the rate.
   * @return net
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNet() {
    return net;
  }


  @JsonProperty(JSON_PROPERTY_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNet(String net) {
    this.net = net;
  }


  public ApiRateCheckRate discount(String discount) {
    
    this.discount = discount;
    return this;
  }

   /**
   * Profit margin that the agency would take if it sells at that recommended price.
   * @return discount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscount() {
    return discount;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscount(String discount) {
    this.discount = discount;
  }


  public ApiRateCheckRate discountPCT(String discountPCT) {
    
    this.discountPCT = discountPCT;
    return this;
  }

   /**
   * Percentual share of the price corresponding to the profit margin the agency would take if it sells at that recommended price.
   * @return discountPCT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNT_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscountPCT() {
    return discountPCT;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscountPCT(String discountPCT) {
    this.discountPCT = discountPCT;
  }


  public ApiRateCheckRate sellingRate(String sellingRate) {
    
    this.sellingRate = sellingRate;
    return this;
  }

   /**
   * Gross price of the room in case it is included.
   * @return sellingRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSellingRate() {
    return sellingRate;
  }


  @JsonProperty(JSON_PROPERTY_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellingRate(String sellingRate) {
    this.sellingRate = sellingRate;
  }


  public ApiRateCheckRate hotelMandatory(Boolean hotelMandatory) {
    
    this.hotelMandatory = hotelMandatory;
    return this;
  }

   /**
   * Identifies if the rate price is recommended.
   * @return hotelMandatory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelMandatory() {
    return hotelMandatory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelMandatory(Boolean hotelMandatory) {
    this.hotelMandatory = hotelMandatory;
  }


  public ApiRateCheckRate allotment(Integer allotment) {
    
    this.allotment = allotment;
    return this;
  }

   /**
   * Number of rooms available for a particular room type.
   * @return allotment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLOTMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAllotment() {
    return allotment;
  }


  @JsonProperty(JSON_PROPERTY_ALLOTMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllotment(Integer allotment) {
    this.allotment = allotment;
  }


  public ApiRateCheckRate commission(String commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Profit margin the agency takes (commissionable model).
   * @return commission
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(String commission) {
    this.commission = commission;
  }


  public ApiRateCheckRate commissionVAT(String commissionVAT) {
    
    this.commissionVAT = commissionVAT;
    return this;
  }

   /**
   * Share of the commission corresponding to the Value Added Tax.
   * @return commissionVAT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommissionVAT() {
    return commissionVAT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionVAT(String commissionVAT) {
    this.commissionVAT = commissionVAT;
  }


  public ApiRateCheckRate commissionPCT(String commissionPCT) {
    
    this.commissionPCT = commissionPCT;
    return this;
  }

   /**
   * Percentual share of the price corresponding to commision.
   * @return commissionPCT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommissionPCT() {
    return commissionPCT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionPCT(String commissionPCT) {
    this.commissionPCT = commissionPCT;
  }


  public ApiRateCheckRate rateComments(String rateComments) {
    
    this.rateComments = rateComments;
    return this;
  }

   /**
   * Rate comments that contain important information.
   * @return rateComments
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_COMMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateComments() {
    return rateComments;
  }


  @JsonProperty(JSON_PROPERTY_RATE_COMMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateComments(String rateComments) {
    this.rateComments = rateComments;
  }


  public ApiRateCheckRate packaging(Boolean packaging) {
    
    this.packaging = packaging;
    return this;
  }

   /**
   * Defines if the rate is for packaging.
   * @return packaging
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PACKAGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPackaging() {
    return packaging;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackaging(Boolean packaging) {
    this.packaging = packaging;
  }


  public ApiRateCheckRate boardCode(String boardCode) {
    
    this.boardCode = boardCode;
    return this;
  }

   /**
   * Internal board code.
   * @return boardCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOARD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBoardCode() {
    return boardCode;
  }


  @JsonProperty(JSON_PROPERTY_BOARD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardCode(String boardCode) {
    this.boardCode = boardCode;
  }


  public ApiRateCheckRate boardName(String boardName) {
    
    this.boardName = boardName;
    return this;
  }

   /**
   * Board name/description.
   * @return boardName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOARD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBoardName() {
    return boardName;
  }


  @JsonProperty(JSON_PROPERTY_BOARD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardName(String boardName) {
    this.boardName = boardName;
  }


  public ApiRateCheckRate rateBreakDown(ApiRateBreakDown rateBreakDown) {
    
    this.rateBreakDown = rateBreakDown;
    return this;
  }

   /**
   * Get rateBreakDown
   * @return rateBreakDown
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_BREAK_DOWN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiRateBreakDown getRateBreakDown() {
    return rateBreakDown;
  }


  @JsonProperty(JSON_PROPERTY_RATE_BREAK_DOWN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateBreakDown(ApiRateBreakDown rateBreakDown) {
    this.rateBreakDown = rateBreakDown;
  }


  public ApiRateCheckRate rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of rooms requested.
   * @return rooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public ApiRateCheckRate adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Number of adults requested for each room.
   * @return adults
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public ApiRateCheckRate children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Number of children requested for each room.
   * @return children
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public ApiRateCheckRate resident(Boolean resident) {
    
    this.resident = resident;
    return this;
  }

   /**
   * Indicates if the rate is only for residents (only appears when resident rates are requested).
   * @return resident
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResident() {
    return resident;
  }


  @JsonProperty(JSON_PROPERTY_RESIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResident(Boolean resident) {
    this.resident = resident;
  }


  public ApiRateCheckRate cancellationPolicies(List<ApiCancellationPolicyCheckRate> cancellationPolicies) {
    
    this.cancellationPolicies = cancellationPolicies;
    return this;
  }

  public ApiRateCheckRate addCancellationPoliciesItem(ApiCancellationPolicyCheckRate cancellationPoliciesItem) {
    if (this.cancellationPolicies == null) {
      this.cancellationPolicies = new ArrayList<>();
    }
    this.cancellationPolicies.add(cancellationPoliciesItem);
    return this;
  }

   /**
   * List of cancellation policies on the rate.
   * @return cancellationPolicies
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiCancellationPolicyCheckRate> getCancellationPolicies() {
    return cancellationPolicies;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicies(List<ApiCancellationPolicyCheckRate> cancellationPolicies) {
    this.cancellationPolicies = cancellationPolicies;
  }


  public ApiRateCheckRate promotions(List<ApiPromotion> promotions) {
    
    this.promotions = promotions;
    return this;
  }

  public ApiRateCheckRate addPromotionsItem(ApiPromotion promotionsItem) {
    if (this.promotions == null) {
      this.promotions = new ArrayList<>();
    }
    this.promotions.add(promotionsItem);
    return this;
  }

   /**
   * List of promotions on the rate.
   * @return promotions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PROMOTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiPromotion> getPromotions() {
    return promotions;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotions(List<ApiPromotion> promotions) {
    this.promotions = promotions;
  }


  public ApiRateCheckRate offers(List<ApiOffer> offers) {
    
    this.offers = offers;
    return this;
  }

  public ApiRateCheckRate addOffersItem(ApiOffer offersItem) {
    if (this.offers == null) {
      this.offers = new ArrayList<>();
    }
    this.offers.add(offersItem);
    return this;
  }

   /**
   * List of offers on the rate.
   * @return offers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiOffer> getOffers() {
    return offers;
  }


  @JsonProperty(JSON_PROPERTY_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOffers(List<ApiOffer> offers) {
    this.offers = offers;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiRateCheckRate apiRateCheckRate = (ApiRateCheckRate) o;
    return Objects.equals(this.rateKey, apiRateCheckRate.rateKey) &&
        Objects.equals(this.rateClass, apiRateCheckRate.rateClass) &&
        Objects.equals(this.rateType, apiRateCheckRate.rateType) &&
        Objects.equals(this.net, apiRateCheckRate.net) &&
        Objects.equals(this.discount, apiRateCheckRate.discount) &&
        Objects.equals(this.discountPCT, apiRateCheckRate.discountPCT) &&
        Objects.equals(this.sellingRate, apiRateCheckRate.sellingRate) &&
        Objects.equals(this.hotelMandatory, apiRateCheckRate.hotelMandatory) &&
        Objects.equals(this.allotment, apiRateCheckRate.allotment) &&
        Objects.equals(this.commission, apiRateCheckRate.commission) &&
        Objects.equals(this.commissionVAT, apiRateCheckRate.commissionVAT) &&
        Objects.equals(this.commissionPCT, apiRateCheckRate.commissionPCT) &&
        Objects.equals(this.rateComments, apiRateCheckRate.rateComments) &&
        Objects.equals(this.packaging, apiRateCheckRate.packaging) &&
        Objects.equals(this.boardCode, apiRateCheckRate.boardCode) &&
        Objects.equals(this.boardName, apiRateCheckRate.boardName) &&
        Objects.equals(this.rateBreakDown, apiRateCheckRate.rateBreakDown) &&
        Objects.equals(this.rooms, apiRateCheckRate.rooms) &&
        Objects.equals(this.adults, apiRateCheckRate.adults) &&
        Objects.equals(this.children, apiRateCheckRate.children) &&
        Objects.equals(this.resident, apiRateCheckRate.resident) &&
        Objects.equals(this.cancellationPolicies, apiRateCheckRate.cancellationPolicies) &&
        Objects.equals(this.promotions, apiRateCheckRate.promotions) &&
        Objects.equals(this.offers, apiRateCheckRate.offers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rateKey, rateClass, rateType, net, discount, discountPCT, sellingRate, hotelMandatory, allotment, commission, commissionVAT, commissionPCT, rateComments, packaging, boardCode, boardName, rateBreakDown, rooms, adults, children, resident, cancellationPolicies, promotions, offers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiRateCheckRate {\n");
    sb.append("    rateKey: ").append(toIndentedString(rateKey)).append("\n");
    sb.append("    rateClass: ").append(toIndentedString(rateClass)).append("\n");
    sb.append("    rateType: ").append(toIndentedString(rateType)).append("\n");
    sb.append("    net: ").append(toIndentedString(net)).append("\n");
    sb.append("    discount: ").append(toIndentedString(discount)).append("\n");
    sb.append("    discountPCT: ").append(toIndentedString(discountPCT)).append("\n");
    sb.append("    sellingRate: ").append(toIndentedString(sellingRate)).append("\n");
    sb.append("    hotelMandatory: ").append(toIndentedString(hotelMandatory)).append("\n");
    sb.append("    allotment: ").append(toIndentedString(allotment)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    commissionVAT: ").append(toIndentedString(commissionVAT)).append("\n");
    sb.append("    commissionPCT: ").append(toIndentedString(commissionPCT)).append("\n");
    sb.append("    rateComments: ").append(toIndentedString(rateComments)).append("\n");
    sb.append("    packaging: ").append(toIndentedString(packaging)).append("\n");
    sb.append("    boardCode: ").append(toIndentedString(boardCode)).append("\n");
    sb.append("    boardName: ").append(toIndentedString(boardName)).append("\n");
    sb.append("    rateBreakDown: ").append(toIndentedString(rateBreakDown)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    resident: ").append(toIndentedString(resident)).append("\n");
    sb.append("    cancellationPolicies: ").append(toIndentedString(cancellationPolicies)).append("\n");
    sb.append("    promotions: ").append(toIndentedString(promotions)).append("\n");
    sb.append("    offers: ").append(toIndentedString(offers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

