/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information describing a supplement on a rate.
 */
@JsonPropertyOrder({
  ApiRateSupplement.JSON_PROPERTY_CODE,
  ApiRateSupplement.JSON_PROPERTY_NAME,
  ApiRateSupplement.JSON_PROPERTY_FROM,
  ApiRateSupplement.JSON_PROPERTY_TO,
  ApiRateSupplement.JSON_PROPERTY_AMOUNT,
  ApiRateSupplement.JSON_PROPERTY_NIGHTS,
  ApiRateSupplement.JSON_PROPERTY_PAX_NUMBER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiRateSupplement {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_FROM = "from";
  private LocalDate from;

  public static final String JSON_PROPERTY_TO = "to";
  private LocalDate to;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Integer nights;

  public static final String JSON_PROPERTY_PAX_NUMBER = "paxNumber";
  private Integer paxNumber;

  public ApiRateSupplement() {
  }

  public ApiRateSupplement code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Internal code of the supplement.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }


  public ApiRateSupplement name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name/description of the supplement.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ApiRateSupplement from(LocalDate from) {
    
    this.from = from;
    return this;
  }

   /**
   * Date from which the discount is applied.
   * @return from
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(LocalDate from) {
    this.from = from;
  }


  public ApiRateSupplement to(LocalDate to) {
    
    this.to = to;
    return this;
  }

   /**
   * Date when the discount ends.
   * @return to
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getTo() {
    return to;
  }


  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(LocalDate to) {
    this.to = to;
  }


  public ApiRateSupplement amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Amount of the supplement.
   * @return amount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public ApiRateSupplement nights(Integer nights) {
    
    this.nights = nights;
    return this;
  }

   /**
   * Number of nights for which the supplement applies.
   * @return nights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNights() {
    return nights;
  }


  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNights(Integer nights) {
    this.nights = nights;
  }


  public ApiRateSupplement paxNumber(Integer paxNumber) {
    
    this.paxNumber = paxNumber;
    return this;
  }

   /**
   * Number of paxes that are affected by the supplement.
   * @return paxNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAX_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPaxNumber() {
    return paxNumber;
  }


  @JsonProperty(JSON_PROPERTY_PAX_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaxNumber(Integer paxNumber) {
    this.paxNumber = paxNumber;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiRateSupplement apiRateSupplement = (ApiRateSupplement) o;
    return Objects.equals(this.code, apiRateSupplement.code) &&
        Objects.equals(this.name, apiRateSupplement.name) &&
        Objects.equals(this.from, apiRateSupplement.from) &&
        Objects.equals(this.to, apiRateSupplement.to) &&
        Objects.equals(this.amount, apiRateSupplement.amount) &&
        Objects.equals(this.nights, apiRateSupplement.nights) &&
        Objects.equals(this.paxNumber, apiRateSupplement.paxNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, name, from, to, amount, nights, paxNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiRateSupplement {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("    paxNumber: ").append(toIndentedString(paxNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

