/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Filter hotels by rating and number of reviews.
 */
@JsonPropertyOrder({
  ApiReviewFilter.JSON_PROPERTY_TYPE,
  ApiReviewFilter.JSON_PROPERTY_MIN_RATE,
  ApiReviewFilter.JSON_PROPERTY_MAX_RATE,
  ApiReviewFilter.JSON_PROPERTY_MIN_REVIEW_COUNT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiReviewFilter {
  /**
   * Defines the source of the reviews.
   */
  public enum TypeEnum {
    TRIPADVISOR("TRIPADVISOR"),
    
    HOTELBEDS("HOTELBEDS");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_MIN_RATE = "minRate";
  private String minRate;

  public static final String JSON_PROPERTY_MAX_RATE = "maxRate";
  private String maxRate;

  public static final String JSON_PROPERTY_MIN_REVIEW_COUNT = "minReviewCount";
  private Integer minReviewCount;

  public ApiReviewFilter() {
  }

  public ApiReviewFilter type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Defines the source of the reviews.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ApiReviewFilter minRate(String minRate) {
    
    this.minRate = minRate;
    return this;
  }

   /**
   * Minimun review rating you want the hotels to have.
   * @return minRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinRate() {
    return minRate;
  }


  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinRate(String minRate) {
    this.minRate = minRate;
  }


  public ApiReviewFilter maxRate(String maxRate) {
    
    this.maxRate = maxRate;
    return this;
  }

   /**
   * Maximum review rating you want the hotels to have.
   * @return maxRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxRate() {
    return maxRate;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRate(String maxRate) {
    this.maxRate = maxRate;
  }


  public ApiReviewFilter minReviewCount(Integer minReviewCount) {
    
    this.minReviewCount = minReviewCount;
    return this;
  }

   /**
   * Minimum number of reviews you want the hotels to have.
   * @return minReviewCount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_REVIEW_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinReviewCount() {
    return minReviewCount;
  }


  @JsonProperty(JSON_PROPERTY_MIN_REVIEW_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinReviewCount(Integer minReviewCount) {
    this.minReviewCount = minReviewCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiReviewFilter apiReviewFilter = (ApiReviewFilter) o;
    return Objects.equals(this.type, apiReviewFilter.type) &&
        Objects.equals(this.minRate, apiReviewFilter.minRate) &&
        Objects.equals(this.maxRate, apiReviewFilter.maxRate) &&
        Objects.equals(this.minReviewCount, apiReviewFilter.minReviewCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, minRate, maxRate, minReviewCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiReviewFilter {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    minRate: ").append(toIndentedString(minRate)).append("\n");
    sb.append("    maxRate: ").append(toIndentedString(maxRate)).append("\n");
    sb.append("    minReviewCount: ").append(toIndentedString(minReviewCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

