/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Definition of a rate for an alternative date to the one used in the availability request.
 */
@JsonPropertyOrder({
  ApiShiftRate.JSON_PROPERTY_RATE_KEY,
  ApiShiftRate.JSON_PROPERTY_RATE_CLASS,
  ApiShiftRate.JSON_PROPERTY_RATE_TYPE,
  ApiShiftRate.JSON_PROPERTY_NET,
  ApiShiftRate.JSON_PROPERTY_DISCOUNT,
  ApiShiftRate.JSON_PROPERTY_DISCOUNT_P_C_T,
  ApiShiftRate.JSON_PROPERTY_SELLING_RATE,
  ApiShiftRate.JSON_PROPERTY_HOTEL_MANDATORY,
  ApiShiftRate.JSON_PROPERTY_ALLOTMENT,
  ApiShiftRate.JSON_PROPERTY_COMMISSION,
  ApiShiftRate.JSON_PROPERTY_COMMISSION_V_A_T,
  ApiShiftRate.JSON_PROPERTY_COMMISSION_P_C_T,
  ApiShiftRate.JSON_PROPERTY_CHECK_IN,
  ApiShiftRate.JSON_PROPERTY_CHECK_OUT,
  ApiShiftRate.JSON_PROPERTY_BRAND,
  ApiShiftRate.JSON_PROPERTY_RESIDENT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiShiftRate {
  public static final String JSON_PROPERTY_RATE_KEY = "rateKey";
  private String rateKey;

  public static final String JSON_PROPERTY_RATE_CLASS = "rateClass";
  private String rateClass;

  /**
   * Determines if can booked directly (BOOKABLE) or if it needs to be checked with the ‘CheckRate’ operation (RECHECK).
   */
  public enum RateTypeEnum {
    BOOKABLE("BOOKABLE"),
    
    RECHECK("RECHECK");

    private String value;

    RateTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateTypeEnum fromValue(String value) {
      for (RateTypeEnum b : RateTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_TYPE = "rateType";
  private RateTypeEnum rateType;

  public static final String JSON_PROPERTY_NET = "net";
  private String net;

  public static final String JSON_PROPERTY_DISCOUNT = "discount";
  private String discount;

  public static final String JSON_PROPERTY_DISCOUNT_P_C_T = "discountPCT";
  private String discountPCT;

  public static final String JSON_PROPERTY_SELLING_RATE = "sellingRate";
  private String sellingRate;

  public static final String JSON_PROPERTY_HOTEL_MANDATORY = "hotelMandatory";
  private Boolean hotelMandatory = false;

  public static final String JSON_PROPERTY_ALLOTMENT = "allotment";
  private Integer allotment;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private String commission;

  public static final String JSON_PROPERTY_COMMISSION_V_A_T = "commissionVAT";
  private String commissionVAT;

  public static final String JSON_PROPERTY_COMMISSION_P_C_T = "commissionPCT";
  private String commissionPCT;

  public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
  private LocalDate checkIn;

  public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
  private LocalDate checkOut;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_RESIDENT = "resident";
  private Boolean resident = false;

  public ApiShiftRate() {
  }

  public ApiShiftRate rateKey(String rateKey) {
    
    this.rateKey = rateKey;
    return this;
  }

   /**
   * Internal key that represents a combination of room type, category, board and occupancy. Is returned in Availability and used to valuate a rate and confirm a booking.
   * @return rateKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateKey() {
    return rateKey;
  }


  @JsonProperty(JSON_PROPERTY_RATE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateKey(String rateKey) {
    this.rateKey = rateKey;
  }


  public ApiShiftRate rateClass(String rateClass) {
    
    this.rateClass = rateClass;
    return this;
  }

   /**
   * Class of the rate.
   * @return rateClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateClass() {
    return rateClass;
  }


  @JsonProperty(JSON_PROPERTY_RATE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateClass(String rateClass) {
    this.rateClass = rateClass;
  }


  public ApiShiftRate rateType(RateTypeEnum rateType) {
    
    this.rateType = rateType;
    return this;
  }

   /**
   * Determines if can booked directly (BOOKABLE) or if it needs to be checked with the ‘CheckRate’ operation (RECHECK).
   * @return rateType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateTypeEnum getRateType() {
    return rateType;
  }


  @JsonProperty(JSON_PROPERTY_RATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateType(RateTypeEnum rateType) {
    this.rateType = rateType;
  }


  public ApiShiftRate net(String net) {
    
    this.net = net;
    return this;
  }

   /**
   * Net price of the rate.
   * @return net
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNet() {
    return net;
  }


  @JsonProperty(JSON_PROPERTY_NET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNet(String net) {
    this.net = net;
  }


  public ApiShiftRate discount(String discount) {
    
    this.discount = discount;
    return this;
  }

   /**
   * Profit margin that the agency would take if it sells at that recommended price.
   * @return discount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscount() {
    return discount;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscount(String discount) {
    this.discount = discount;
  }


  public ApiShiftRate discountPCT(String discountPCT) {
    
    this.discountPCT = discountPCT;
    return this;
  }

   /**
   * Percentual share of the price corresponding to the profit margin the agency would take if it sells at that recommended price.
   * @return discountPCT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNT_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscountPCT() {
    return discountPCT;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNT_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscountPCT(String discountPCT) {
    this.discountPCT = discountPCT;
  }


  public ApiShiftRate sellingRate(String sellingRate) {
    
    this.sellingRate = sellingRate;
    return this;
  }

   /**
   * Gross price of the room in case it is included.
   * @return sellingRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSellingRate() {
    return sellingRate;
  }


  @JsonProperty(JSON_PROPERTY_SELLING_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellingRate(String sellingRate) {
    this.sellingRate = sellingRate;
  }


  public ApiShiftRate hotelMandatory(Boolean hotelMandatory) {
    
    this.hotelMandatory = hotelMandatory;
    return this;
  }

   /**
   * Identifies if the rate price is recommended.
   * @return hotelMandatory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelMandatory() {
    return hotelMandatory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelMandatory(Boolean hotelMandatory) {
    this.hotelMandatory = hotelMandatory;
  }


  public ApiShiftRate allotment(Integer allotment) {
    
    this.allotment = allotment;
    return this;
  }

   /**
   * Number of rooms available for a particular room type.
   * @return allotment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLOTMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAllotment() {
    return allotment;
  }


  @JsonProperty(JSON_PROPERTY_ALLOTMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllotment(Integer allotment) {
    this.allotment = allotment;
  }


  public ApiShiftRate commission(String commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Profit margin the agency takes (commissionable model).
   * @return commission
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(String commission) {
    this.commission = commission;
  }


  public ApiShiftRate commissionVAT(String commissionVAT) {
    
    this.commissionVAT = commissionVAT;
    return this;
  }

   /**
   * Share of the commission corresponding to the Value Added Tax.
   * @return commissionVAT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommissionVAT() {
    return commissionVAT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_V_A_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionVAT(String commissionVAT) {
    this.commissionVAT = commissionVAT;
  }


  public ApiShiftRate commissionPCT(String commissionPCT) {
    
    this.commissionPCT = commissionPCT;
    return this;
  }

   /**
   * Percentual share of the price corresponding to commision.
   * @return commissionPCT
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCommissionPCT() {
    return commissionPCT;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_P_C_T)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionPCT(String commissionPCT) {
    this.commissionPCT = commissionPCT;
  }


  public ApiShiftRate checkIn(LocalDate checkIn) {
    
    this.checkIn = checkIn;
    return this;
  }

   /**
   * CheckIn date for the shift rate. This will always be different than the requested date or the dates of the not alternative rates.
   * @return checkIn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckIn() {
    return checkIn;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckIn(LocalDate checkIn) {
    this.checkIn = checkIn;
  }


  public ApiShiftRate checkOut(LocalDate checkOut) {
    
    this.checkOut = checkOut;
    return this;
  }

   /**
   * CheckIn date for the shift rate. This will always be different than the requested date or the dates of the not alternative rates.
   * @return checkOut
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getCheckOut() {
    return checkOut;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckOut(LocalDate checkOut) {
    this.checkOut = checkOut;
  }


  public ApiShiftRate brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Brand of the hotel.
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public ApiShiftRate resident(Boolean resident) {
    
    this.resident = resident;
    return this;
  }

   /**
   * Indicates if the rate is only for residents (only appears when resident rates are requested).
   * @return resident
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResident() {
    return resident;
  }


  @JsonProperty(JSON_PROPERTY_RESIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResident(Boolean resident) {
    this.resident = resident;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiShiftRate apiShiftRate = (ApiShiftRate) o;
    return Objects.equals(this.rateKey, apiShiftRate.rateKey) &&
        Objects.equals(this.rateClass, apiShiftRate.rateClass) &&
        Objects.equals(this.rateType, apiShiftRate.rateType) &&
        Objects.equals(this.net, apiShiftRate.net) &&
        Objects.equals(this.discount, apiShiftRate.discount) &&
        Objects.equals(this.discountPCT, apiShiftRate.discountPCT) &&
        Objects.equals(this.sellingRate, apiShiftRate.sellingRate) &&
        Objects.equals(this.hotelMandatory, apiShiftRate.hotelMandatory) &&
        Objects.equals(this.allotment, apiShiftRate.allotment) &&
        Objects.equals(this.commission, apiShiftRate.commission) &&
        Objects.equals(this.commissionVAT, apiShiftRate.commissionVAT) &&
        Objects.equals(this.commissionPCT, apiShiftRate.commissionPCT) &&
        Objects.equals(this.checkIn, apiShiftRate.checkIn) &&
        Objects.equals(this.checkOut, apiShiftRate.checkOut) &&
        Objects.equals(this.brand, apiShiftRate.brand) &&
        Objects.equals(this.resident, apiShiftRate.resident);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rateKey, rateClass, rateType, net, discount, discountPCT, sellingRate, hotelMandatory, allotment, commission, commissionVAT, commissionPCT, checkIn, checkOut, brand, resident);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiShiftRate {\n");
    sb.append("    rateKey: ").append(toIndentedString(rateKey)).append("\n");
    sb.append("    rateClass: ").append(toIndentedString(rateClass)).append("\n");
    sb.append("    rateType: ").append(toIndentedString(rateType)).append("\n");
    sb.append("    net: ").append(toIndentedString(net)).append("\n");
    sb.append("    discount: ").append(toIndentedString(discount)).append("\n");
    sb.append("    discountPCT: ").append(toIndentedString(discountPCT)).append("\n");
    sb.append("    sellingRate: ").append(toIndentedString(sellingRate)).append("\n");
    sb.append("    hotelMandatory: ").append(toIndentedString(hotelMandatory)).append("\n");
    sb.append("    allotment: ").append(toIndentedString(allotment)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    commissionVAT: ").append(toIndentedString(commissionVAT)).append("\n");
    sb.append("    commissionPCT: ").append(toIndentedString(commissionPCT)).append("\n");
    sb.append("    checkIn: ").append(toIndentedString(checkIn)).append("\n");
    sb.append("    checkOut: ").append(toIndentedString(checkOut)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    resident: ").append(toIndentedString(resident)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

