/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Defines the time of the stay at the hotel.
 */
@JsonPropertyOrder({
  ApiStay.JSON_PROPERTY_CHECK_IN,
  ApiStay.JSON_PROPERTY_CHECK_OUT,
  ApiStay.JSON_PROPERTY_SHIFT_DAYS,
  ApiStay.JSON_PROPERTY_ALLOW_ONLY_SHIFT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiStay {
  public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
  private LocalDate checkIn;

  public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
  private LocalDate checkOut;

  public static final String JSON_PROPERTY_SHIFT_DAYS = "shiftDays";
  private Integer shiftDays;

  public static final String JSON_PROPERTY_ALLOW_ONLY_SHIFT = "allowOnlyShift";
  private Boolean allowOnlyShift = true;

  public ApiStay() {
  }

  public ApiStay checkIn(LocalDate checkIn) {
    
    this.checkIn = checkIn;
    return this;
  }

   /**
   * Check-in date.
   * @return checkIn
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getCheckIn() {
    return checkIn;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCheckIn(LocalDate checkIn) {
    this.checkIn = checkIn;
  }


  public ApiStay checkOut(LocalDate checkOut) {
    
    this.checkOut = checkOut;
    return this;
  }

   /**
   * Check-out date.
   * @return checkOut
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getCheckOut() {
    return checkOut;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCheckOut(LocalDate checkOut) {
    this.checkOut = checkOut;
  }


  public ApiStay shiftDays(Integer shiftDays) {
    
    this.shiftDays = shiftDays;
    return this;
  }

   /**
   * Amount of days after and before the check-in to check availability, keeping the same stay duration.
   * minimum: 1
   * maximum: 5
   * @return shiftDays
  **/
  @jakarta.annotation.Nullable
 @Min(1) @Max(5)
  @JsonProperty(JSON_PROPERTY_SHIFT_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getShiftDays() {
    return shiftDays;
  }


  @JsonProperty(JSON_PROPERTY_SHIFT_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShiftDays(Integer shiftDays) {
    this.shiftDays = shiftDays;
  }


  public ApiStay allowOnlyShift(Boolean allowOnlyShift) {
    
    this.allowOnlyShift = allowOnlyShift;
    return this;
  }

   /**
   * Defines if results are returned for shiftDays even if there&#39;s no results for the searched dates.
   * @return allowOnlyShift
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLOW_ONLY_SHIFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowOnlyShift() {
    return allowOnlyShift;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_ONLY_SHIFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowOnlyShift(Boolean allowOnlyShift) {
    this.allowOnlyShift = allowOnlyShift;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiStay apiStay = (ApiStay) o;
    return Objects.equals(this.checkIn, apiStay.checkIn) &&
        Objects.equals(this.checkOut, apiStay.checkOut) &&
        Objects.equals(this.shiftDays, apiStay.shiftDays) &&
        Objects.equals(this.allowOnlyShift, apiStay.allowOnlyShift);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkIn, checkOut, shiftDays, allowOnlyShift);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiStay {\n");
    sb.append("    checkIn: ").append(toIndentedString(checkIn)).append("\n");
    sb.append("    checkOut: ").append(toIndentedString(checkOut)).append("\n");
    sb.append("    shiftDays: ").append(toIndentedString(shiftDays)).append("\n");
    sb.append("    allowOnlyShift: ").append(toIndentedString(allowOnlyShift)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

