/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Tax information.
 */
@JsonPropertyOrder({
  ApiTax.JSON_PROPERTY_INCLUDED,
  ApiTax.JSON_PROPERTY_PERCENT,
  ApiTax.JSON_PROPERTY_AMOUNT,
  ApiTax.JSON_PROPERTY_CURRENCY,
  ApiTax.JSON_PROPERTY_TYPE,
  ApiTax.JSON_PROPERTY_CLIENT_AMOUNT,
  ApiTax.JSON_PROPERTY_CLIENT_CURRENCY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiTax {
  public static final String JSON_PROPERTY_INCLUDED = "included";
  private Boolean included = false;

  public static final String JSON_PROPERTY_PERCENT = "percent";
  private String percent;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  /**
   * Type of the tax.
   */
  public enum TypeEnum {
    TAX("TAX"),
    
    FEE("FEE"),
    
    TAXESANDFEES("TAXESANDFEES");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_CLIENT_AMOUNT = "clientAmount";
  private String clientAmount;

  public static final String JSON_PROPERTY_CLIENT_CURRENCY = "clientCurrency";
  private String clientCurrency;

  public ApiTax() {
  }

  public ApiTax included(Boolean included) {
    
    this.included = included;
    return this;
  }

   /**
   * Indicates if the tax is included in the price or not.
   * @return included
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncluded() {
    return included;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncluded(Boolean included) {
    this.included = included;
  }


  public ApiTax percent(String percent) {
    
    this.percent = percent;
    return this;
  }

   /**
   * Value of the tax as a percentage.
   * @return percent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPercent() {
    return percent;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercent(String percent) {
    this.percent = percent;
  }


  public ApiTax amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Value of the tax in hotel currency if the tax is not included in the price.
   * @return amount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public ApiTax currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency of the tax amount.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public ApiTax type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of the tax.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ApiTax clientAmount(String clientAmount) {
    
    this.clientAmount = clientAmount;
    return this;
  }

   /**
   * Net amount of the tax in the client configured currency.
   * @return clientAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLIENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientAmount() {
    return clientAmount;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientAmount(String clientAmount) {
    this.clientAmount = clientAmount;
  }


  public ApiTax clientCurrency(String clientCurrency) {
    
    this.clientCurrency = clientCurrency;
    return this;
  }

   /**
   * Client configured currency.
   * @return clientCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLIENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientCurrency() {
    return clientCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientCurrency(String clientCurrency) {
    this.clientCurrency = clientCurrency;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiTax apiTax = (ApiTax) o;
    return Objects.equals(this.included, apiTax.included) &&
        Objects.equals(this.percent, apiTax.percent) &&
        Objects.equals(this.amount, apiTax.amount) &&
        Objects.equals(this.currency, apiTax.currency) &&
        Objects.equals(this.type, apiTax.type) &&
        Objects.equals(this.clientAmount, apiTax.clientAmount) &&
        Objects.equals(this.clientCurrency, apiTax.clientCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(included, percent, amount, currency, type, clientAmount, clientCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiTax {\n");
    sb.append("    included: ").append(toIndentedString(included)).append("\n");
    sb.append("    percent: ").append(toIndentedString(percent)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    clientAmount: ").append(toIndentedString(clientAmount)).append("\n");
    sb.append("    clientCurrency: ").append(toIndentedString(clientCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

