/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiTax;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information of taxes.
 */
@JsonPropertyOrder({
  ApiTaxes.JSON_PROPERTY_ALL_INCLUDED,
  ApiTaxes.JSON_PROPERTY_TAX_SCHEME,
  ApiTaxes.JSON_PROPERTY_TAXES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class ApiTaxes {
  public static final String JSON_PROPERTY_ALL_INCLUDED = "allIncluded";
  private Boolean allIncluded = false;

  /**
   * \&quot;margin\&quot;: This is an indirect tax regime for travel agencies where split of taxes is not shown in the invoices. In this case, the customer could not deduct any taxes even if the final customer is a legal entity with the right of deduction for indirect taxes. \&quot;general\&quot;: This is the indirect tax regime where the split of taxes is shown in the invoices. In this case, the booking will be invoiced with split of taxes and the customer could be able to deduct the VAT and in some countries, these taxes are reduced rates. This tax scheme offers tax advantage for business customers with the right of deduction for indirect taxes.
   */
  public enum TaxSchemeEnum {
    MARGIN("margin"),
    
    GENERAL("general");

    private String value;

    TaxSchemeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TaxSchemeEnum fromValue(String value) {
      for (TaxSchemeEnum b : TaxSchemeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TAX_SCHEME = "taxScheme";
  private TaxSchemeEnum taxScheme;

  public static final String JSON_PROPERTY_TAXES = "taxes";
  private List<ApiTax> taxes;

  public ApiTaxes() {
  }

  public ApiTaxes allIncluded(Boolean allIncluded) {
    
    this.allIncluded = allIncluded;
    return this;
  }

   /**
   * Indicates if all taxes are included or not.
   * @return allIncluded
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALL_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllIncluded() {
    return allIncluded;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllIncluded(Boolean allIncluded) {
    this.allIncluded = allIncluded;
  }


  public ApiTaxes taxScheme(TaxSchemeEnum taxScheme) {
    
    this.taxScheme = taxScheme;
    return this;
  }

   /**
   * \&quot;margin\&quot;: This is an indirect tax regime for travel agencies where split of taxes is not shown in the invoices. In this case, the customer could not deduct any taxes even if the final customer is a legal entity with the right of deduction for indirect taxes. \&quot;general\&quot;: This is the indirect tax regime where the split of taxes is shown in the invoices. In this case, the booking will be invoiced with split of taxes and the customer could be able to deduct the VAT and in some countries, these taxes are reduced rates. This tax scheme offers tax advantage for business customers with the right of deduction for indirect taxes.
   * @return taxScheme
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TAX_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TaxSchemeEnum getTaxScheme() {
    return taxScheme;
  }


  @JsonProperty(JSON_PROPERTY_TAX_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxScheme(TaxSchemeEnum taxScheme) {
    this.taxScheme = taxScheme;
  }


  public ApiTaxes taxes(List<ApiTax> taxes) {
    
    this.taxes = taxes;
    return this;
  }

  public ApiTaxes addTaxesItem(ApiTax taxesItem) {
    if (this.taxes == null) {
      this.taxes = new ArrayList<>();
    }
    this.taxes.add(taxesItem);
    return this;
  }

   /**
   * List of taxes.
   * @return taxes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiTax> getTaxes() {
    return taxes;
  }


  @JsonProperty(JSON_PROPERTY_TAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxes(List<ApiTax> taxes) {
    this.taxes = taxes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiTaxes apiTaxes = (ApiTaxes) o;
    return Objects.equals(this.allIncluded, apiTaxes.allIncluded) &&
        Objects.equals(this.taxScheme, apiTaxes.taxScheme) &&
        Objects.equals(this.taxes, apiTaxes.taxes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allIncluded, taxScheme, taxes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiTaxes {\n");
    sb.append("    allIncluded: ").append(toIndentedString(allIncluded)).append("\n");
    sb.append("    taxScheme: ").append(toIndentedString(taxScheme)).append("\n");
    sb.append("    taxes: ").append(toIndentedString(taxes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

