/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiBoards;
import travel.wink.hotelbeds.booking.sdk.model.ApiFilter;
import travel.wink.hotelbeds.booking.sdk.model.ApiGeoLocation;
import travel.wink.hotelbeds.booking.sdk.model.ApiHotelsFilter;
import travel.wink.hotelbeds.booking.sdk.model.ApiKeywordsFilter;
import travel.wink.hotelbeds.booking.sdk.model.ApiOccupancy;
import travel.wink.hotelbeds.booking.sdk.model.ApiReviewFilter;
import travel.wink.hotelbeds.booking.sdk.model.ApiRooms;
import travel.wink.hotelbeds.booking.sdk.model.ApiStay;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Request of Availability operation.
 */
@JsonPropertyOrder({
  AvailabilityRQ.JSON_PROPERTY_STAY,
  AvailabilityRQ.JSON_PROPERTY_GEOLOCATION,
  AvailabilityRQ.JSON_PROPERTY_FILTER,
  AvailabilityRQ.JSON_PROPERTY_BOARDS,
  AvailabilityRQ.JSON_PROPERTY_ROOMS,
  AvailabilityRQ.JSON_PROPERTY_DAILY_RATE,
  AvailabilityRQ.JSON_PROPERTY_SOURCE_MARKET,
  AvailabilityRQ.JSON_PROPERTY_AIF_USE,
  AvailabilityRQ.JSON_PROPERTY_PLATFORM,
  AvailabilityRQ.JSON_PROPERTY_LANGUAGE,
  AvailabilityRQ.JSON_PROPERTY_OCCUPANCIES,
  AvailabilityRQ.JSON_PROPERTY_KEYWORDS,
  AvailabilityRQ.JSON_PROPERTY_HOTELS,
  AvailabilityRQ.JSON_PROPERTY_REVIEW,
  AvailabilityRQ.JSON_PROPERTY_ACCOMMODATIONS,
  AvailabilityRQ.JSON_PROPERTY_INCLUSIONS
})
@JsonTypeName("availabilityRQ")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class AvailabilityRQ {
  public static final String JSON_PROPERTY_STAY = "stay";
  private ApiStay stay;

  public static final String JSON_PROPERTY_GEOLOCATION = "geolocation";
  private ApiGeoLocation geolocation;

  public static final String JSON_PROPERTY_FILTER = "filter";
  private ApiFilter filter;

  public static final String JSON_PROPERTY_BOARDS = "boards";
  private ApiBoards boards;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private ApiRooms rooms;

  public static final String JSON_PROPERTY_DAILY_RATE = "dailyRate";
  private Boolean dailyRate = false;

  public static final String JSON_PROPERTY_SOURCE_MARKET = "sourceMarket";
  private String sourceMarket;

  public static final String JSON_PROPERTY_AIF_USE = "aifUse";
  private Boolean aifUse = false;

  public static final String JSON_PROPERTY_PLATFORM = "platform";
  private Integer platform;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_OCCUPANCIES = "occupancies";
  private List<ApiOccupancy> occupancies = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private ApiKeywordsFilter keywords;

  public static final String JSON_PROPERTY_HOTELS = "hotels";
  private ApiHotelsFilter hotels;

  public static final String JSON_PROPERTY_REVIEW = "review";
  private List<ApiReviewFilter> review;

  public static final String JSON_PROPERTY_ACCOMMODATIONS = "accommodations";
  private List<String> accommodations;

  /**
   * Gets or Sets inclusions
   */
  public enum InclusionsEnum {
    RESIDENT_RATES("RESIDENT_RATES");

    private String value;

    InclusionsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InclusionsEnum fromValue(String value) {
      for (InclusionsEnum b : InclusionsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INCLUSIONS = "inclusions";
  private List<InclusionsEnum> inclusions;

  public AvailabilityRQ() {
  }

  public AvailabilityRQ stay(ApiStay stay) {
    
    this.stay = stay;
    return this;
  }

   /**
   * Get stay
   * @return stay
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApiStay getStay() {
    return stay;
  }


  @JsonProperty(JSON_PROPERTY_STAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStay(ApiStay stay) {
    this.stay = stay;
  }


  public AvailabilityRQ geolocation(ApiGeoLocation geolocation) {
    
    this.geolocation = geolocation;
    return this;
  }

   /**
   * Get geolocation
   * @return geolocation
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GEOLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiGeoLocation getGeolocation() {
    return geolocation;
  }


  @JsonProperty(JSON_PROPERTY_GEOLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeolocation(ApiGeoLocation geolocation) {
    this.geolocation = geolocation;
  }


  public AvailabilityRQ filter(ApiFilter filter) {
    
    this.filter = filter;
    return this;
  }

   /**
   * Get filter
   * @return filter
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiFilter getFilter() {
    return filter;
  }


  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilter(ApiFilter filter) {
    this.filter = filter;
  }


  public AvailabilityRQ boards(ApiBoards boards) {
    
    this.boards = boards;
    return this;
  }

   /**
   * Get boards
   * @return boards
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiBoards getBoards() {
    return boards;
  }


  @JsonProperty(JSON_PROPERTY_BOARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoards(ApiBoards boards) {
    this.boards = boards;
  }


  public AvailabilityRQ rooms(ApiRooms rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Get rooms
   * @return rooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiRooms getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(ApiRooms rooms) {
    this.rooms = rooms;
  }


  public AvailabilityRQ dailyRate(Boolean dailyRate) {
    
    this.dailyRate = dailyRate;
    return this;
  }

   /**
   * Displays price breakdown per each day of the hotel stay.
   * @return dailyRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DAILY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDailyRate() {
    return dailyRate;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRate(Boolean dailyRate) {
    this.dailyRate = dailyRate;
  }


  public AvailabilityRQ sourceMarket(String sourceMarket) {
    
    this.sourceMarket = sourceMarket;
    return this;
  }

   /**
   * Hotelbeds Group client source market.
   * @return sourceMarket
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_MARKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceMarket() {
    return sourceMarket;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_MARKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceMarket(String sourceMarket) {
    this.sourceMarket = sourceMarket;
  }


  public AvailabilityRQ aifUse(Boolean aifUse) {
    
    this.aifUse = aifUse;
    return this;
  }

   /**
   * Tags the request for CacheAPI users (NOTE: MANDATORY for this users when filtering by contract).
   * @return aifUse
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AIF_USE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAifUse() {
    return aifUse;
  }


  @JsonProperty(JSON_PROPERTY_AIF_USE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAifUse(Boolean aifUse) {
    this.aifUse = aifUse;
  }


  public AvailabilityRQ platform(Integer platform) {
    
    this.platform = platform;
    return this;
  }

   /**
   * Defines the platform for multiclient developer platforms.
   * @return platform
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPlatform() {
    return platform;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatform(Integer platform) {
    this.platform = platform;
  }


  public AvailabilityRQ language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * Language code that defines the language of the response. English will be used by default if this field is not informed.
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public AvailabilityRQ occupancies(List<ApiOccupancy> occupancies) {
    
    this.occupancies = occupancies;
    return this;
  }

  public AvailabilityRQ addOccupanciesItem(ApiOccupancy occupanciesItem) {
    if (this.occupancies == null) {
      this.occupancies = new ArrayList<>();
    }
    this.occupancies.add(occupanciesItem);
    return this;
  }

   /**
   * List of passenger groups for which to request availability.
   * @return occupancies
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OCCUPANCIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<ApiOccupancy> getOccupancies() {
    return occupancies;
  }


  @JsonProperty(JSON_PROPERTY_OCCUPANCIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOccupancies(List<ApiOccupancy> occupancies) {
    this.occupancies = occupancies;
  }


  public AvailabilityRQ keywords(ApiKeywordsFilter keywords) {
    
    this.keywords = keywords;
    return this;
  }

   /**
   * Get keywords
   * @return keywords
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiKeywordsFilter getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeywords(ApiKeywordsFilter keywords) {
    this.keywords = keywords;
  }


  public AvailabilityRQ hotels(ApiHotelsFilter hotels) {
    
    this.hotels = hotels;
    return this;
  }

   /**
   * Get hotels
   * @return hotels
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiHotelsFilter getHotels() {
    return hotels;
  }


  @JsonProperty(JSON_PROPERTY_HOTELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotels(ApiHotelsFilter hotels) {
    this.hotels = hotels;
  }


  public AvailabilityRQ review(List<ApiReviewFilter> review) {
    
    this.review = review;
    return this;
  }

  public AvailabilityRQ addReviewItem(ApiReviewFilter reviewItem) {
    if (this.review == null) {
      this.review = new ArrayList<>();
    }
    this.review.add(reviewItem);
    return this;
  }

   /**
   * Filter for review rating.
   * @return review
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiReviewFilter> getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(List<ApiReviewFilter> review) {
    this.review = review;
  }


  public AvailabilityRQ accommodations(List<String> accommodations) {
    
    this.accommodations = accommodations;
    return this;
  }

  public AvailabilityRQ addAccommodationsItem(String accommodationsItem) {
    if (this.accommodations == null) {
      this.accommodations = new ArrayList<>();
    }
    this.accommodations.add(accommodationsItem);
    return this;
  }

   /**
   * Filter for accomodation type.
   * @return accommodations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOMMODATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAccommodations() {
    return accommodations;
  }


  @JsonProperty(JSON_PROPERTY_ACCOMMODATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccommodations(List<String> accommodations) {
    this.accommodations = accommodations;
  }


  public AvailabilityRQ inclusions(List<InclusionsEnum> inclusions) {
    
    this.inclusions = inclusions;
    return this;
  }

  public AvailabilityRQ addInclusionsItem(InclusionsEnum inclusionsItem) {
    if (this.inclusions == null) {
      this.inclusions = new ArrayList<>();
    }
    this.inclusions.add(inclusionsItem);
    return this;
  }

   /**
   * Includes additional rates that are normally not exposed in the Availability results. NOTE: Be aware that inclusions are not filters and as such all of the regular rates are returned with the normally not included ones.
   * @return inclusions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<InclusionsEnum> getInclusions() {
    return inclusions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInclusions(List<InclusionsEnum> inclusions) {
    this.inclusions = inclusions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AvailabilityRQ availabilityRQ = (AvailabilityRQ) o;
    return Objects.equals(this.stay, availabilityRQ.stay) &&
        Objects.equals(this.geolocation, availabilityRQ.geolocation) &&
        Objects.equals(this.filter, availabilityRQ.filter) &&
        Objects.equals(this.boards, availabilityRQ.boards) &&
        Objects.equals(this.rooms, availabilityRQ.rooms) &&
        Objects.equals(this.dailyRate, availabilityRQ.dailyRate) &&
        Objects.equals(this.sourceMarket, availabilityRQ.sourceMarket) &&
        Objects.equals(this.aifUse, availabilityRQ.aifUse) &&
        Objects.equals(this.platform, availabilityRQ.platform) &&
        Objects.equals(this.language, availabilityRQ.language) &&
        Objects.equals(this.occupancies, availabilityRQ.occupancies) &&
        Objects.equals(this.keywords, availabilityRQ.keywords) &&
        Objects.equals(this.hotels, availabilityRQ.hotels) &&
        Objects.equals(this.review, availabilityRQ.review) &&
        Objects.equals(this.accommodations, availabilityRQ.accommodations) &&
        Objects.equals(this.inclusions, availabilityRQ.inclusions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stay, geolocation, filter, boards, rooms, dailyRate, sourceMarket, aifUse, platform, language, occupancies, keywords, hotels, review, accommodations, inclusions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AvailabilityRQ {\n");
    sb.append("    stay: ").append(toIndentedString(stay)).append("\n");
    sb.append("    geolocation: ").append(toIndentedString(geolocation)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    boards: ").append(toIndentedString(boards)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    dailyRate: ").append(toIndentedString(dailyRate)).append("\n");
    sb.append("    sourceMarket: ").append(toIndentedString(sourceMarket)).append("\n");
    sb.append("    aifUse: ").append(toIndentedString(aifUse)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    occupancies: ").append(toIndentedString(occupancies)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    hotels: ").append(toIndentedString(hotels)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    accommodations: ").append(toIndentedString(accommodations)).append("\n");
    sb.append("    inclusions: ").append(toIndentedString(inclusions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

