/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.booking.sdk.model.ApiBooking;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaymentData;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Request of BookingChange operation.
 */
@JsonPropertyOrder({
  BookingChangeRQ.JSON_PROPERTY_BOOKING_ID,
  BookingChangeRQ.JSON_PROPERTY_MODE,
  BookingChangeRQ.JSON_PROPERTY_PAYMENT_DATA,
  BookingChangeRQ.JSON_PROPERTY_LANGUAGE,
  BookingChangeRQ.JSON_PROPERTY_BOOKING
})
@JsonTypeName("bookingChangeRQ")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class BookingChangeRQ {
  public static final String JSON_PROPERTY_BOOKING_ID = "bookingId";
  private String bookingId;

  /**
   * Defines if the operation will be a simulation or an actual modification.
   */
  public enum ModeEnum {
    SIMULATION("SIMULATION"),
    
    UPDATE("UPDATE");

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode;

  public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
  private ApiPaymentData paymentData;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_BOOKING = "booking";
  private ApiBooking booking;

  public BookingChangeRQ() {
  }

  public BookingChangeRQ bookingId(String bookingId) {
    
    this.bookingId = bookingId;
    return this;
  }

   /**
   * Get bookingId
   * @return bookingId
   * @deprecated
  **/
  @Deprecated
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKING_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBookingId() {
    return bookingId;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingId(String bookingId) {
    this.bookingId = bookingId;
  }


  public BookingChangeRQ mode(ModeEnum mode) {
    
    this.mode = mode;
    return this;
  }

   /**
   * Defines if the operation will be a simulation or an actual modification.
   * @return mode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ModeEnum getMode() {
    return mode;
  }


  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  public BookingChangeRQ paymentData(ApiPaymentData paymentData) {
    
    this.paymentData = paymentData;
    return this;
  }

   /**
   * Get paymentData
   * @return paymentData
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiPaymentData getPaymentData() {
    return paymentData;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentData(ApiPaymentData paymentData) {
    this.paymentData = paymentData;
  }


  public BookingChangeRQ language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * Language code that defines the language of the response. English will be used by default if this field is not informed.
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public BookingChangeRQ booking(ApiBooking booking) {
    
    this.booking = booking;
    return this;
  }

   /**
   * Get booking
   * @return booking
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApiBooking getBooking() {
    return booking;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBooking(ApiBooking booking) {
    this.booking = booking;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingChangeRQ bookingChangeRQ = (BookingChangeRQ) o;
    return Objects.equals(this.bookingId, bookingChangeRQ.bookingId) &&
        Objects.equals(this.mode, bookingChangeRQ.mode) &&
        Objects.equals(this.paymentData, bookingChangeRQ.paymentData) &&
        Objects.equals(this.language, bookingChangeRQ.language) &&
        Objects.equals(this.booking, bookingChangeRQ.booking);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingId, mode, paymentData, language, booking);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingChangeRQ {\n");
    sb.append("    bookingId: ").append(toIndentedString(bookingId)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    paymentData: ").append(toIndentedString(paymentData)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    booking: ").append(toIndentedString(booking)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

