/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiBookingRoom;
import travel.wink.hotelbeds.booking.sdk.model.ApiHolder;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaymentData;
import travel.wink.hotelbeds.booking.sdk.model.ApiVoucher;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Request of Booking operation.
 */
@JsonPropertyOrder({
  BookingRQ.JSON_PROPERTY_HOLDER,
  BookingRQ.JSON_PROPERTY_PAYMENT_DATA,
  BookingRQ.JSON_PROPERTY_CLIENT_REFERENCE,
  BookingRQ.JSON_PROPERTY_CREATION_USER,
  BookingRQ.JSON_PROPERTY_REMARK,
  BookingRQ.JSON_PROPERTY_VOUCHER,
  BookingRQ.JSON_PROPERTY_TOLERANCE,
  BookingRQ.JSON_PROPERTY_LANGUAGE,
  BookingRQ.JSON_PROPERTY_ROOMS
})
@JsonTypeName("bookingRQ")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class BookingRQ {
  public static final String JSON_PROPERTY_HOLDER = "holder";
  private ApiHolder holder;

  public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
  private ApiPaymentData paymentData;

  public static final String JSON_PROPERTY_CLIENT_REFERENCE = "clientReference";
  private String clientReference;

  public static final String JSON_PROPERTY_CREATION_USER = "creationUser";
  private String creationUser;

  public static final String JSON_PROPERTY_REMARK = "remark";
  private String remark;

  public static final String JSON_PROPERTY_VOUCHER = "voucher";
  private ApiVoucher voucher;

  public static final String JSON_PROPERTY_TOLERANCE = "tolerance";
  private String tolerance;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<ApiBookingRoom> rooms;

  public BookingRQ() {
  }

  public BookingRQ holder(ApiHolder holder) {
    
    this.holder = holder;
    return this;
  }

   /**
   * Get holder
   * @return holder
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOLDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApiHolder getHolder() {
    return holder;
  }


  @JsonProperty(JSON_PROPERTY_HOLDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHolder(ApiHolder holder) {
    this.holder = holder;
  }


  public BookingRQ paymentData(ApiPaymentData paymentData) {
    
    this.paymentData = paymentData;
    return this;
  }

   /**
   * Get paymentData
   * @return paymentData
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiPaymentData getPaymentData() {
    return paymentData;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentData(ApiPaymentData paymentData) {
    this.paymentData = paymentData;
  }


  public BookingRQ clientReference(String clientReference) {
    
    this.clientReference = clientReference;
    return this;
  }

   /**
   * Internal booking reference.
   * @return clientReference
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=20)
  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getClientReference() {
    return clientReference;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientReference(String clientReference) {
    this.clientReference = clientReference;
  }


  public BookingRQ creationUser(String creationUser) {
    
    this.creationUser = creationUser;
    return this;
  }

   /**
   * Identifies the agent name of the booking. If empty, by default it will be the same than the apikey performing the booking .
   * @return creationUser
  **/
  @jakarta.annotation.Nullable
 @Size(min=1,max=50)
  @JsonProperty(JSON_PROPERTY_CREATION_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationUser() {
    return creationUser;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationUser(String creationUser) {
    this.creationUser = creationUser;
  }


  public BookingRQ remark(String remark) {
    
    this.remark = remark;
    return this;
  }

   /**
   * Free text sent to the hotelier. It can be used to request or inform of special requests to hotelier like: “Non-smoking room preferred”, “Twin bed please”, “Upper floor preferred”, “Late arrival”…. 
   * @return remark
  **/
  @jakarta.annotation.Nullable
 @Size(min=0,max=2000)
  @JsonProperty(JSON_PROPERTY_REMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRemark() {
    return remark;
  }


  @JsonProperty(JSON_PROPERTY_REMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemark(String remark) {
    this.remark = remark;
  }


  public BookingRQ voucher(ApiVoucher voucher) {
    
    this.voucher = voucher;
    return this;
  }

   /**
   * Get voucher
   * @return voucher
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VOUCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiVoucher getVoucher() {
    return voucher;
  }


  @JsonProperty(JSON_PROPERTY_VOUCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoucher(ApiVoucher voucher) {
    this.voucher = voucher;
  }


  public BookingRQ tolerance(String tolerance) {
    
    this.tolerance = tolerance;
    return this;
  }

   /**
   * Margin of price difference (as percentage) accepted when a price difference occurs between Availability/CheckRate and Booking operations. Do not use more than two decimal characters when defining tolerance. Example: to input a tolerance of 5%, you should input 5.00.  NOTE: Authorisation for the use of this tag is subject to prior written agreement with your sales manager
   * @return tolerance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOLERANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTolerance() {
    return tolerance;
  }


  @JsonProperty(JSON_PROPERTY_TOLERANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTolerance(String tolerance) {
    this.tolerance = tolerance;
  }


  public BookingRQ language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * Language code that defines the language of the response. English will be used by default if this field is not informed.
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public BookingRQ rooms(List<ApiBookingRoom> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public BookingRQ addRoomsItem(ApiBookingRoom roomsItem) {
    if (this.rooms == null) {
      this.rooms = new ArrayList<>();
    }
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * List of the rooms to be included in the booking.
   * @return rooms
  **/
  @jakarta.annotation.Nullable
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiBookingRoom> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(List<ApiBookingRoom> rooms) {
    this.rooms = rooms;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingRQ bookingRQ = (BookingRQ) o;
    return Objects.equals(this.holder, bookingRQ.holder) &&
        Objects.equals(this.paymentData, bookingRQ.paymentData) &&
        Objects.equals(this.clientReference, bookingRQ.clientReference) &&
        Objects.equals(this.creationUser, bookingRQ.creationUser) &&
        Objects.equals(this.remark, bookingRQ.remark) &&
        Objects.equals(this.voucher, bookingRQ.voucher) &&
        Objects.equals(this.tolerance, bookingRQ.tolerance) &&
        Objects.equals(this.language, bookingRQ.language) &&
        Objects.equals(this.rooms, bookingRQ.rooms);
  }

  @Override
  public int hashCode() {
    return Objects.hash(holder, paymentData, clientReference, creationUser, remark, voucher, tolerance, language, rooms);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingRQ {\n");
    sb.append("    holder: ").append(toIndentedString(holder)).append("\n");
    sb.append("    paymentData: ").append(toIndentedString(paymentData)).append("\n");
    sb.append("    clientReference: ").append(toIndentedString(clientReference)).append("\n");
    sb.append("    creationUser: ").append(toIndentedString(creationUser)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    voucher: ").append(toIndentedString(voucher)).append("\n");
    sb.append("    tolerance: ").append(toIndentedString(tolerance)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

