/*
 * Hotel Booking API
 * # APItude Hotel Booking API  Hotel Booking API is designed to book hotels in real time as fast as in two steps. It covers the complete booking process; it allows generating lists of hotels, confirming bookings, getting lists of bookings, obtaining booking information, making cancellations and modify existing bookings.  Hotel Booking API works in combination with [Hotel Content API](/documentation/hotels/content-api/api-reference/) to obtain content information from the hotels, such as pictures, description, facilities, services, etc. Please refer to the Hotel Content API documentation and IO/DOCS for related information.  Hotel Booking API has been designed for a two steps confirmation, but due the the complexity of client and providers systems a third method has been designed.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.booking.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.booking.sdk.model.ApiPax;
import travel.wink.hotelbeds.booking.sdk.model.ApiRateBookingConfirm;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information about the room and its associated rates.
 */
@JsonPropertyOrder({
  RoomBookingConfirm.JSON_PROPERTY_STATUS,
  RoomBookingConfirm.JSON_PROPERTY_ID,
  RoomBookingConfirm.JSON_PROPERTY_CODE,
  RoomBookingConfirm.JSON_PROPERTY_NAME,
  RoomBookingConfirm.JSON_PROPERTY_SUPPLIER_REFERENCE,
  RoomBookingConfirm.JSON_PROPERTY_PAXES,
  RoomBookingConfirm.JSON_PROPERTY_RATES
})
@JsonTypeName("roomBookingConfirm")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:08.331690043+07:00[Asia/Bangkok]")
public class RoomBookingConfirm {
  /**
   * Booking status of the room.
   */
  public enum StatusEnum {
    CONFIRMED("CONFIRMED"),
    
    CANCELLED("CANCELLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_ID = "id";
  private Integer id;

  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SUPPLIER_REFERENCE = "supplierReference";
  private String supplierReference;

  public static final String JSON_PROPERTY_PAXES = "paxes";
  private List<ApiPax> paxes;

  public static final String JSON_PROPERTY_RATES = "rates";
  private List<ApiRateBookingConfirm> rates;

  public RoomBookingConfirm() {
  }

  public RoomBookingConfirm status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Booking status of the room.
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public RoomBookingConfirm id(Integer id) {
    
    this.id = id;
    return this;
  }

   /**
   * Room reservation identifier.
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(Integer id) {
    this.id = id;
  }


  public RoomBookingConfirm code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Internal room code.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }


  public RoomBookingConfirm name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Room name/description.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public RoomBookingConfirm supplierReference(String supplierReference) {
    
    this.supplierReference = supplierReference;
    return this;
  }

   /**
   * Booking reference of the booking/room for external supplier bookings.
   * @return supplierReference
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierReference() {
    return supplierReference;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierReference(String supplierReference) {
    this.supplierReference = supplierReference;
  }


  public RoomBookingConfirm paxes(List<ApiPax> paxes) {
    
    this.paxes = paxes;
    return this;
  }

  public RoomBookingConfirm addPaxesItem(ApiPax paxesItem) {
    if (this.paxes == null) {
      this.paxes = new ArrayList<>();
    }
    this.paxes.add(paxesItem);
    return this;
  }

   /**
   * List of paxes for the room.
   * @return paxes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiPax> getPaxes() {
    return paxes;
  }


  @JsonProperty(JSON_PROPERTY_PAXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaxes(List<ApiPax> paxes) {
    this.paxes = paxes;
  }


  public RoomBookingConfirm rates(List<ApiRateBookingConfirm> rates) {
    
    this.rates = rates;
    return this;
  }

  public RoomBookingConfirm addRatesItem(ApiRateBookingConfirm ratesItem) {
    if (this.rates == null) {
      this.rates = new ArrayList<>();
    }
    this.rates.add(ratesItem);
    return this;
  }

   /**
   * List of rates associated to the room.
   * @return rates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiRateBookingConfirm> getRates() {
    return rates;
  }


  @JsonProperty(JSON_PROPERTY_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRates(List<ApiRateBookingConfirm> rates) {
    this.rates = rates;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomBookingConfirm roomBookingConfirm = (RoomBookingConfirm) o;
    return Objects.equals(this.status, roomBookingConfirm.status) &&
        Objects.equals(this.id, roomBookingConfirm.id) &&
        Objects.equals(this.code, roomBookingConfirm.code) &&
        Objects.equals(this.name, roomBookingConfirm.name) &&
        Objects.equals(this.supplierReference, roomBookingConfirm.supplierReference) &&
        Objects.equals(this.paxes, roomBookingConfirm.paxes) &&
        Objects.equals(this.rates, roomBookingConfirm.rates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, id, code, name, supplierReference, paxes, rates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomBookingConfirm {\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    supplierReference: ").append(toIndentedString(supplierReference)).append("\n");
    sb.append("    paxes: ").append(toIndentedString(paxes)).append("\n");
    sb.append("    rates: ").append(toIndentedString(rates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

