/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.hotelbeds.booking.sdk.api;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.hotelbeds.booking.sdk.invoker.ApiClient;
import travel.wink.hotelbeds.booking.sdk.model.BookingCancellationRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingChangeRQ;
import travel.wink.hotelbeds.booking.sdk.model.BookingChangeRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingDetailRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingListRS;
import travel.wink.hotelbeds.booking.sdk.model.BookingRQ;
import travel.wink.hotelbeds.booking.sdk.model.BookingRS;

public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec bookingRequestCreation(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        BookingRQ postBody = body;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling booking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (contentType != null) {
            headerParams.add("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Apikey", "Xsignature"};
        ParameterizedTypeReference<BookingRS> localVarReturnType = new ParameterizedTypeReference<BookingRS>(this){};
        return this.apiClient.invokeAPI("/bookings", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingRS> booking(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingRS> localVarReturnType = new ParameterizedTypeReference<BookingRS>(this){};
        return this.bookingRequestCreation(accept, acceptEncoding, contentType, body).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingRS>> bookingWithHttpInfo(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingRS> localVarReturnType = new ParameterizedTypeReference<BookingRS>(this){};
        return this.bookingRequestCreation(accept, acceptEncoding, contentType, body).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bookingWithResponseSpec(String accept, String acceptEncoding, String contentType, BookingRQ body) throws WebClientResponseException {
        return this.bookingRequestCreation(accept, acceptEncoding, contentType, body);
    }

    private WebClient.ResponseSpec bookingCancellationRequestCreation(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingId' when calling bookingCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingId", bookingId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "cancellationFlag", cancellationFlag));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "language", language));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Apikey", "Xsignature"};
        ParameterizedTypeReference<BookingCancellationRS> localVarReturnType = new ParameterizedTypeReference<BookingCancellationRS>(this){};
        return this.apiClient.invokeAPI("/bookings/{bookingId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingCancellationRS> bookingCancellation(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellationRS> localVarReturnType = new ParameterizedTypeReference<BookingCancellationRS>(this){};
        return this.bookingCancellationRequestCreation(accept, acceptEncoding, bookingId, cancellationFlag, language).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingCancellationRS>> bookingCancellationWithHttpInfo(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellationRS> localVarReturnType = new ParameterizedTypeReference<BookingCancellationRS>(this){};
        return this.bookingCancellationRequestCreation(accept, acceptEncoding, bookingId, cancellationFlag, language).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bookingCancellationWithResponseSpec(String accept, String acceptEncoding, String bookingId, String cancellationFlag, String language) throws WebClientResponseException {
        return this.bookingCancellationRequestCreation(accept, acceptEncoding, bookingId, cancellationFlag, language);
    }

    private WebClient.ResponseSpec bookingChangeRequestCreation(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        BookingChangeRQ postBody = body;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingId' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling bookingChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingId", bookingId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (contentType != null) {
            headerParams.add("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Apikey", "Xsignature"};
        ParameterizedTypeReference<BookingChangeRS> localVarReturnType = new ParameterizedTypeReference<BookingChangeRS>(this){};
        return this.apiClient.invokeAPI("/bookings/{bookingId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingChangeRS> bookingChange(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingChangeRS> localVarReturnType = new ParameterizedTypeReference<BookingChangeRS>(this){};
        return this.bookingChangeRequestCreation(accept, acceptEncoding, contentType, bookingId, body).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingChangeRS>> bookingChangeWithHttpInfo(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        ParameterizedTypeReference<BookingChangeRS> localVarReturnType = new ParameterizedTypeReference<BookingChangeRS>(this){};
        return this.bookingChangeRequestCreation(accept, acceptEncoding, contentType, bookingId, body).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bookingChangeWithResponseSpec(String accept, String acceptEncoding, String contentType, String bookingId, BookingChangeRQ body) throws WebClientResponseException {
        return this.bookingChangeRequestCreation(accept, acceptEncoding, contentType, bookingId, body);
    }

    private WebClient.ResponseSpec bookingDetailRequestCreation(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingDetail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingDetail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingId' when calling bookingDetail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingId", bookingId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "language", language));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Apikey", "Xsignature"};
        ParameterizedTypeReference<BookingDetailRS> localVarReturnType = new ParameterizedTypeReference<BookingDetailRS>(this){};
        return this.apiClient.invokeAPI("/bookings/{bookingId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingDetailRS> bookingDetail(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingDetailRS> localVarReturnType = new ParameterizedTypeReference<BookingDetailRS>(this){};
        return this.bookingDetailRequestCreation(accept, acceptEncoding, bookingId, language).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingDetailRS>> bookingDetailWithHttpInfo(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        ParameterizedTypeReference<BookingDetailRS> localVarReturnType = new ParameterizedTypeReference<BookingDetailRS>(this){};
        return this.bookingDetailRequestCreation(accept, acceptEncoding, bookingId, language).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bookingDetailWithResponseSpec(String accept, String acceptEncoding, String bookingId, String language) throws WebClientResponseException {
        return this.bookingDetailRequestCreation(accept, acceptEncoding, bookingId, language);
    }

    private WebClient.ResponseSpec bookingListRequestCreation(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (contentType == null) {
            throw new WebClientResponseException("Missing the required parameter 'contentType' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (from == null) {
            throw new WebClientResponseException("Missing the required parameter 'from' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (to == null) {
            throw new WebClientResponseException("Missing the required parameter 'to' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (start == null) {
            throw new WebClientResponseException("Missing the required parameter 'start' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (end == null) {
            throw new WebClientResponseException("Missing the required parameter 'end' when calling bookingList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filterType", filterType));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "status", status));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "clientReference", clientReference));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "creationUser", creationUser));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "country", country));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "destination", destination));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "hotel", hotel));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "end", end));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (contentType != null) {
            headerParams.add("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Apikey", "Xsignature"};
        ParameterizedTypeReference<BookingListRS> localVarReturnType = new ParameterizedTypeReference<BookingListRS>(this){};
        return this.apiClient.invokeAPI("/bookings", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingListRS> bookingList(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        ParameterizedTypeReference<BookingListRS> localVarReturnType = new ParameterizedTypeReference<BookingListRS>(this){};
        return this.bookingListRequestCreation(accept, acceptEncoding, contentType, from, to, start, end, filterType, status, clientReference, creationUser, country, destination, hotel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingListRS>> bookingListWithHttpInfo(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        ParameterizedTypeReference<BookingListRS> localVarReturnType = new ParameterizedTypeReference<BookingListRS>(this){};
        return this.bookingListRequestCreation(accept, acceptEncoding, contentType, from, to, start, end, filterType, status, clientReference, creationUser, country, destination, hotel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bookingListWithResponseSpec(String accept, String acceptEncoding, String contentType, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, String status, String clientReference, String creationUser, List<String> country, List<String> destination, List<Integer> hotel) throws WebClientResponseException {
        return this.bookingListRequestCreation(accept, acceptEncoding, contentType, from, to, start, end, filterType, status, clientReference, creationUser, country, destination, hotel);
    }

    private WebClient.ResponseSpec bookingreconfirmationRequestCreation(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (from == null) {
            throw new WebClientResponseException("Missing the required parameter 'from' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (to == null) {
            throw new WebClientResponseException("Missing the required parameter 'to' when calling bookingreconfirmation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "end", end));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filterType", filterType));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "clientReferences", clientReferences));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "references", references));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Apikey", "Xsignature"};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(this){};
        return this.apiClient.invokeAPI("/bookings/reconfirmations", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> bookingreconfirmation(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(this){};
        return this.bookingreconfirmationRequestCreation(accept, acceptEncoding, from, to, start, end, filterType, clientReferences, references).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> bookingreconfirmationWithHttpInfo(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(this){};
        return this.bookingreconfirmationRequestCreation(accept, acceptEncoding, from, to, start, end, filterType, clientReferences, references).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bookingreconfirmationWithResponseSpec(String accept, String acceptEncoding, Integer from, Integer to, LocalDate start, LocalDate end, String filterType, List<String> clientReferences, List<String> references) throws WebClientResponseException {
        return this.bookingreconfirmationRequestCreation(accept, acceptEncoding, from, to, start, end, filterType, clientReferences, references);
    }
}

