/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.hotelbeds.booking.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaxAvail;

@JsonPropertyOrder(value={"rooms", "adults", "children", "paxes"})
public class ApiOccupancy {
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private Integer rooms;
    public static final String JSON_PROPERTY_ADULTS = "adults";
    private Integer adults;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children;
    public static final String JSON_PROPERTY_PAXES = "paxes";
    private List<ApiPaxAvail> paxes;

    public ApiOccupancy rooms(Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRooms(Integer rooms) {
        this.rooms = rooms;
    }

    public ApiOccupancy adults(Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(Integer adults) {
        this.adults = adults;
    }

    public ApiOccupancy children(Integer children) {
        this.children = children;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChildren(Integer children) {
        this.children = children;
    }

    public ApiOccupancy paxes(List<ApiPaxAvail> paxes) {
        this.paxes = paxes;
        return this;
    }

    public ApiOccupancy addPaxesItem(ApiPaxAvail paxesItem) {
        if (this.paxes == null) {
            this.paxes = new ArrayList<ApiPaxAvail>();
        }
        this.paxes.add(paxesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="paxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApiPaxAvail> getPaxes() {
        return this.paxes;
    }

    @JsonProperty(value="paxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaxes(List<ApiPaxAvail> paxes) {
        this.paxes = paxes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiOccupancy apiOccupancy = (ApiOccupancy)o;
        return Objects.equals(this.rooms, apiOccupancy.rooms) && Objects.equals(this.adults, apiOccupancy.adults) && Objects.equals(this.children, apiOccupancy.children) && Objects.equals(this.paxes, apiOccupancy.paxes);
    }

    public int hashCode() {
        return Objects.hash(this.rooms, this.adults, this.children, this.paxes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiOccupancy {\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    paxes: ").append(this.toIndentedString(this.paxes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

