/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.hotelbeds.booking.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@JsonPropertyOrder(value={"roomId", "type", "age", "name", "surname"})
public class ApiPax {
    public static final String JSON_PROPERTY_ROOM_ID = "roomId";
    private Integer roomId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AGE = "age";
    private Integer age;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SURNAME = "surname";
    private String surname;

    public ApiPax roomId(Integer roomId) {
        this.roomId = roomId;
        return this;
    }

    @Nullable
    @Min(value=1L)
    @JsonProperty(value="roomId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=1L) Integer getRoomId() {
        return this.roomId;
    }

    @JsonProperty(value="roomId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomId(Integer roomId) {
        this.roomId = roomId;
    }

    public ApiPax type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ApiPax age(Integer age) {
        this.age = age;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=99L)
    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=99L) Integer getAge() {
        return this.age;
    }

    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAge(Integer age) {
        this.age = age;
    }

    public ApiPax name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @Size(min=1, max=50)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=50) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiPax surname(String surname) {
        this.surname = surname;
        return this;
    }

    @Nullable
    @Size(min=0, max=50)
    @JsonProperty(value="surname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=50) String getSurname() {
        return this.surname;
    }

    @JsonProperty(value="surname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSurname(String surname) {
        this.surname = surname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiPax apiPax = (ApiPax)o;
        return Objects.equals(this.roomId, apiPax.roomId) && Objects.equals((Object)this.type, (Object)apiPax.type) && Objects.equals(this.age, apiPax.age) && Objects.equals(this.name, apiPax.name) && Objects.equals(this.surname, apiPax.surname);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.roomId, this.type, this.age, this.name, this.surname});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiPax {\n");
        sb.append("    roomId: ").append(this.toIndentedString(this.roomId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    age: ").append(this.toIndentedString(this.age)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    surname: ").append(this.toIndentedString(this.surname)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        AD("AD"),
        CH("CH");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

