/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.hotelbeds.booking.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Objects;

@JsonPropertyOrder(value={"checkIn", "checkOut", "shiftDays", "allowOnlyShift"})
public class ApiStay {
    public static final String JSON_PROPERTY_CHECK_IN = "checkIn";
    private LocalDate checkIn;
    public static final String JSON_PROPERTY_CHECK_OUT = "checkOut";
    private LocalDate checkOut;
    public static final String JSON_PROPERTY_SHIFT_DAYS = "shiftDays";
    private Integer shiftDays;
    public static final String JSON_PROPERTY_ALLOW_ONLY_SHIFT = "allowOnlyShift";
    private Boolean allowOnlyShift = true;

    public ApiStay checkIn(LocalDate checkIn) {
        this.checkIn = checkIn;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="checkIn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getCheckIn() {
        return this.checkIn;
    }

    @JsonProperty(value="checkIn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCheckIn(LocalDate checkIn) {
        this.checkIn = checkIn;
    }

    public ApiStay checkOut(LocalDate checkOut) {
        this.checkOut = checkOut;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="checkOut")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getCheckOut() {
        return this.checkOut;
    }

    @JsonProperty(value="checkOut")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCheckOut(LocalDate checkOut) {
        this.checkOut = checkOut;
    }

    public ApiStay shiftDays(Integer shiftDays) {
        this.shiftDays = shiftDays;
        return this;
    }

    @Nullable
    @Min(value=1L)
    @Max(value=5L)
    @JsonProperty(value="shiftDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=1L) @Max(value=5L) Integer getShiftDays() {
        return this.shiftDays;
    }

    @JsonProperty(value="shiftDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShiftDays(Integer shiftDays) {
        this.shiftDays = shiftDays;
    }

    public ApiStay allowOnlyShift(Boolean allowOnlyShift) {
        this.allowOnlyShift = allowOnlyShift;
        return this;
    }

    @Nullable
    @JsonProperty(value="allowOnlyShift")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowOnlyShift() {
        return this.allowOnlyShift;
    }

    @JsonProperty(value="allowOnlyShift")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowOnlyShift(Boolean allowOnlyShift) {
        this.allowOnlyShift = allowOnlyShift;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiStay apiStay = (ApiStay)o;
        return Objects.equals(this.checkIn, apiStay.checkIn) && Objects.equals(this.checkOut, apiStay.checkOut) && Objects.equals(this.shiftDays, apiStay.shiftDays) && Objects.equals(this.allowOnlyShift, apiStay.allowOnlyShift);
    }

    public int hashCode() {
        return Objects.hash(this.checkIn, this.checkOut, this.shiftDays, this.allowOnlyShift);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiStay {\n");
        sb.append("    checkIn: ").append(this.toIndentedString(this.checkIn)).append("\n");
        sb.append("    checkOut: ").append(this.toIndentedString(this.checkOut)).append("\n");
        sb.append("    shiftDays: ").append(this.toIndentedString(this.shiftDays)).append("\n");
        sb.append("    allowOnlyShift: ").append(this.toIndentedString(this.allowOnlyShift)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

