/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.hotelbeds.booking.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.hotelbeds.booking.sdk.model.ApiBookingRoom;
import travel.wink.hotelbeds.booking.sdk.model.ApiHolder;
import travel.wink.hotelbeds.booking.sdk.model.ApiPaymentData;
import travel.wink.hotelbeds.booking.sdk.model.ApiVoucher;

@JsonPropertyOrder(value={"holder", "paymentData", "clientReference", "creationUser", "remark", "voucher", "tolerance", "language", "rooms"})
@JsonTypeName(value="bookingRQ")
public class BookingRQ {
    public static final String JSON_PROPERTY_HOLDER = "holder";
    private ApiHolder holder;
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private ApiPaymentData paymentData;
    public static final String JSON_PROPERTY_CLIENT_REFERENCE = "clientReference";
    private String clientReference;
    public static final String JSON_PROPERTY_CREATION_USER = "creationUser";
    private String creationUser;
    public static final String JSON_PROPERTY_REMARK = "remark";
    private String remark;
    public static final String JSON_PROPERTY_VOUCHER = "voucher";
    private ApiVoucher voucher;
    public static final String JSON_PROPERTY_TOLERANCE = "tolerance";
    private String tolerance;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private List<ApiBookingRoom> rooms;

    public BookingRQ holder(ApiHolder holder) {
        this.holder = holder;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="holder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ApiHolder getHolder() {
        return this.holder;
    }

    @JsonProperty(value="holder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHolder(ApiHolder holder) {
        this.holder = holder;
    }

    public BookingRQ paymentData(ApiPaymentData paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiPaymentData getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(ApiPaymentData paymentData) {
        this.paymentData = paymentData;
    }

    public BookingRQ clientReference(String clientReference) {
        this.clientReference = clientReference;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=20)
    @JsonProperty(value="clientReference")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=20) String getClientReference() {
        return this.clientReference;
    }

    @JsonProperty(value="clientReference")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientReference(String clientReference) {
        this.clientReference = clientReference;
    }

    public BookingRQ creationUser(String creationUser) {
        this.creationUser = creationUser;
        return this;
    }

    @Nullable
    @Size(min=1, max=50)
    @JsonProperty(value="creationUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=50) String getCreationUser() {
        return this.creationUser;
    }

    @JsonProperty(value="creationUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public BookingRQ remark(String remark) {
        this.remark = remark;
        return this;
    }

    @Nullable
    @Size(min=0, max=2000)
    @JsonProperty(value="remark")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=2000) String getRemark() {
        return this.remark;
    }

    @JsonProperty(value="remark")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BookingRQ voucher(ApiVoucher voucher) {
        this.voucher = voucher;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="voucher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiVoucher getVoucher() {
        return this.voucher;
    }

    @JsonProperty(value="voucher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVoucher(ApiVoucher voucher) {
        this.voucher = voucher;
    }

    public BookingRQ tolerance(String tolerance) {
        this.tolerance = tolerance;
        return this;
    }

    @Nullable
    @JsonProperty(value="tolerance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTolerance() {
        return this.tolerance;
    }

    @JsonProperty(value="tolerance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTolerance(String tolerance) {
        this.tolerance = tolerance;
    }

    public BookingRQ language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public BookingRQ rooms(List<ApiBookingRoom> rooms) {
        this.rooms = rooms;
        return this;
    }

    public BookingRQ addRoomsItem(ApiBookingRoom roomsItem) {
        if (this.rooms == null) {
            this.rooms = new ArrayList<ApiBookingRoom>();
        }
        this.rooms.add(roomsItem);
        return this;
    }

    @Nullable
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<ApiBookingRoom> getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRooms(List<ApiBookingRoom> rooms) {
        this.rooms = rooms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingRQ bookingRQ = (BookingRQ)o;
        return Objects.equals(this.holder, bookingRQ.holder) && Objects.equals(this.paymentData, bookingRQ.paymentData) && Objects.equals(this.clientReference, bookingRQ.clientReference) && Objects.equals(this.creationUser, bookingRQ.creationUser) && Objects.equals(this.remark, bookingRQ.remark) && Objects.equals(this.voucher, bookingRQ.voucher) && Objects.equals(this.tolerance, bookingRQ.tolerance) && Objects.equals(this.language, bookingRQ.language) && Objects.equals(this.rooms, bookingRQ.rooms);
    }

    public int hashCode() {
        return Objects.hash(this.holder, this.paymentData, this.clientReference, this.creationUser, this.remark, this.voucher, this.tolerance, this.language, this.rooms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingRQ {\n");
        sb.append("    holder: ").append(this.toIndentedString(this.holder)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    clientReference: ").append(this.toIndentedString(this.clientReference)).append("\n");
        sb.append("    creationUser: ").append(this.toIndentedString(this.creationUser)).append("\n");
        sb.append("    remark: ").append(this.toIndentedString(this.remark)).append("\n");
        sb.append("    voucher: ").append(this.toIndentedString(this.voucher)).append("\n");
        sb.append("    tolerance: ").append(this.toIndentedString(this.tolerance)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

