package travel.wink.hotelbeds.cache.sdk.api;

import travel.wink.hotelbeds.cache.sdk.invoker.ApiClient;

import java.io.File;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:24.150740956+07:00[Asia/Bangkok]")
public class OperationsApi {
    private ApiClient apiClient;

    public OperationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public OperationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * ConfirmVersions
     * Mediante el uso del parámetro versión, se le especifica al sistema el punto a partir del cual, mediante la operación UPDATE se devolverá sólo los archivos AIF modificados
     * <p><b>200</b> - A .ZIP file
     * @param version 
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec confirmVersionsRequestCreation(Integer version, String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'version' is set
        if (version == null) {
            throw new WebClientResponseException("Missing the required parameter 'version' when calling confirmVersions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'apiKey' is set
        if (apiKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'apiKey' when calling confirmVersions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'xSignature' is set
        if (xSignature == null) {
            throw new WebClientResponseException("Missing the required parameter 'xSignature' when calling confirmVersions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling confirmVersions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling confirmVersions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "version", version));

        if (apiKey != null)
        headerParams.add("Api-key", apiClient.parameterToString(apiKey));
        if (xSignature != null)
        headerParams.add("X-Signature", apiClient.parameterToString(xSignature));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            ".zip"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Xusername", "Apikey", "Xpassword" };

        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return apiClient.invokeAPI("/confirmversions", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * ConfirmVersions
     * Mediante el uso del parámetro versión, se le especifica al sistema el punto a partir del cual, mediante la operación UPDATE se devolverá sólo los archivos AIF modificados
     * <p><b>200</b> - A .ZIP file
     * @param version 
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<File> confirmVersions(Integer version, String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return confirmVersionsRequestCreation(version, apiKey, xSignature, accept, acceptEncoding).bodyToMono(localVarReturnType);
    }

    /**
     * ConfirmVersions
     * Mediante el uso del parámetro versión, se le especifica al sistema el punto a partir del cual, mediante la operación UPDATE se devolverá sólo los archivos AIF modificados
     * <p><b>200</b> - A .ZIP file
     * @param version 
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return ResponseEntity&lt;File&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<File>> confirmVersionsWithHttpInfo(Integer version, String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return confirmVersionsRequestCreation(version, apiKey, xSignature, accept, acceptEncoding).toEntity(localVarReturnType);
    }

    /**
     * ConfirmVersions
     * Mediante el uso del parámetro versión, se le especifica al sistema el punto a partir del cual, mediante la operación UPDATE se devolverá sólo los archivos AIF modificados
     * <p><b>200</b> - A .ZIP file
     * @param version 
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec confirmVersionsWithResponseSpec(Integer version, String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        return confirmVersionsRequestCreation(version, apiKey, xSignature, accept, acceptEncoding);
    }
    /**
     * FULL sin mashery
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec fULLsinmasheryRequestCreation(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'apiKey' is set
        if (apiKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'apiKey' when calling fULLsinmashery", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'xSignature' is set
        if (xSignature == null) {
            throw new WebClientResponseException("Missing the required parameter 'xSignature' when calling fULLsinmashery", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling fULLsinmashery", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling fULLsinmashery", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (apiKey != null)
        headerParams.add("Api-key", apiClient.parameterToString(apiKey));
        if (xSignature != null)
        headerParams.add("X-Signature", apiClient.parameterToString(xSignature));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            ".zip"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Xusername", "Apikey", "Xpassword" };

        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return apiClient.invokeAPI("/full", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * FULL sin mashery
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<File> fULLsinmashery(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return fULLsinmasheryRequestCreation(apiKey, xSignature, accept, acceptEncoding).bodyToMono(localVarReturnType);
    }

    /**
     * FULL sin mashery
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return ResponseEntity&lt;File&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<File>> fULLsinmasheryWithHttpInfo(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return fULLsinmasheryRequestCreation(apiKey, xSignature, accept, acceptEncoding).toEntity(localVarReturnType);
    }

    /**
     * FULL sin mashery
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec fULLsinmasheryWithResponseSpec(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        return fULLsinmasheryRequestCreation(apiKey, xSignature, accept, acceptEncoding);
    }
    /**
     * FullRates
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec fullRatesRequestCreation(String accept, String apiKey, String xSignature) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling fullRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'apiKey' is set
        if (apiKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'apiKey' when calling fullRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'xSignature' is set
        if (xSignature == null) {
            throw new WebClientResponseException("Missing the required parameter 'xSignature' when calling fullRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (apiKey != null)
        headerParams.add("Api-key", apiClient.parameterToString(apiKey));
        if (xSignature != null)
        headerParams.add("X-Signature", apiClient.parameterToString(xSignature));
        final String[] localVarAccepts = { 
            ".zip"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Xusername", "Apikey", "Xpassword" };

        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return apiClient.invokeAPI("/fullrates", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * FullRates
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<File> fullRates(String accept, String apiKey, String xSignature) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return fullRatesRequestCreation(accept, apiKey, xSignature).bodyToMono(localVarReturnType);
    }

    /**
     * FullRates
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @return ResponseEntity&lt;File&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<File>> fullRatesWithHttpInfo(String accept, String apiKey, String xSignature) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return fullRatesRequestCreation(accept, apiKey, xSignature).toEntity(localVarReturnType);
    }

    /**
     * FullRates
     * Devuelve un zip con todos los ficheros AIF diponibles por el cliente que realizar la operación.
     * <p><b>200</b> - A .ZIP file
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec fullRatesWithResponseSpec(String accept, String apiKey, String xSignature) throws WebClientResponseException {
        return fullRatesRequestCreation(accept, apiKey, xSignature);
    }
    /**
     * UpdateRates
     * Teniendo en cuenta el valor de la llamada CONFIRM, se devuelven todos los archivos que han cambiado a partir de la versión especificada.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRatesRequestCreation(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'apiKey' is set
        if (apiKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'apiKey' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'xSignature' is set
        if (xSignature == null) {
            throw new WebClientResponseException("Missing the required parameter 'xSignature' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (apiKey != null)
        headerParams.add("Api-key", apiClient.parameterToString(apiKey));
        if (xSignature != null)
        headerParams.add("X-Signature", apiClient.parameterToString(xSignature));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            ".zip"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Xusername", "Apikey", "Xpassword" };

        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return apiClient.invokeAPI("/updaterates", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * UpdateRates
     * Teniendo en cuenta el valor de la llamada CONFIRM, se devuelven todos los archivos que han cambiado a partir de la versión especificada.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return File
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<File> updateRates(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return updateRatesRequestCreation(apiKey, xSignature, accept, acceptEncoding).bodyToMono(localVarReturnType);
    }

    /**
     * UpdateRates
     * Teniendo en cuenta el valor de la llamada CONFIRM, se devuelven todos los archivos que han cambiado a partir de la versión especificada.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return ResponseEntity&lt;File&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<File>> updateRatesWithHttpInfo(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>() {};
        return updateRatesRequestCreation(apiKey, xSignature, accept, acceptEncoding).toEntity(localVarReturnType);
    }

    /**
     * UpdateRates
     * Teniendo en cuenta el valor de la llamada CONFIRM, se devuelven todos los archivos que han cambiado a partir de la versión especificada.
     * <p><b>200</b> - A .ZIP file
     * @param apiKey API Key used in the request
     * @param xSignature SHA256 hash in Hex format from your API Key, your secret plus current timestamps in seconds
     * @param accept Defines response format, posible values: application/xml, application/json
     * @param acceptEncoding Defines type of encoding used on the data
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRatesWithResponseSpec(String apiKey, String xSignature, String accept, String acceptEncoding) throws WebClientResponseException {
        return updateRatesRequestCreation(apiKey, xSignature, accept, acceptEncoding);
    }
}
