package travel.wink.hotelbeds.content.sdk.api;

import travel.wink.hotelbeds.content.sdk.invoker.ApiClient;

import travel.wink.hotelbeds.content.sdk.model.ApiHotelDetailsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelsRS;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class HotelsApi {
    private ApiClient apiClient;

    public HotelsApi() {
        this(new ApiClient());
    }

    @Autowired
    public HotelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Hotel details
     * Returns all the details associated to the Hotel.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param hotelCodes Code or codes of specific hotels from which to get details.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @return ApiHotelDetailsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec hotelWithIdDetailsUsingGETRequestCreation(String accept, String acceptEncoding, String hotelCodes, String language, Boolean useSecondaryLanguage) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling hotelWithIdDetailsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling hotelWithIdDetailsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'hotelCodes' is set
        if (hotelCodes == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelCodes' when calling hotelWithIdDetailsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelCodes", hotelCodes);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiHotelDetailsRS> localVarReturnType = new ParameterizedTypeReference<ApiHotelDetailsRS>() {};
        return apiClient.invokeAPI("/hotels/{hotelCodes}/details", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Hotel details
     * Returns all the details associated to the Hotel.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param hotelCodes Code or codes of specific hotels from which to get details.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @return ApiHotelDetailsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiHotelDetailsRS> hotelWithIdDetailsUsingGET(String accept, String acceptEncoding, String hotelCodes, String language, Boolean useSecondaryLanguage) throws WebClientResponseException {
        ParameterizedTypeReference<ApiHotelDetailsRS> localVarReturnType = new ParameterizedTypeReference<ApiHotelDetailsRS>() {};
        return hotelWithIdDetailsUsingGETRequestCreation(accept, acceptEncoding, hotelCodes, language, useSecondaryLanguage).bodyToMono(localVarReturnType);
    }

    /**
     * Hotel details
     * Returns all the details associated to the Hotel.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param hotelCodes Code or codes of specific hotels from which to get details.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @return ResponseEntity&lt;ApiHotelDetailsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiHotelDetailsRS>> hotelWithIdDetailsUsingGETWithHttpInfo(String accept, String acceptEncoding, String hotelCodes, String language, Boolean useSecondaryLanguage) throws WebClientResponseException {
        ParameterizedTypeReference<ApiHotelDetailsRS> localVarReturnType = new ParameterizedTypeReference<ApiHotelDetailsRS>() {};
        return hotelWithIdDetailsUsingGETRequestCreation(accept, acceptEncoding, hotelCodes, language, useSecondaryLanguage).toEntity(localVarReturnType);
    }

    /**
     * Hotel details
     * Returns all the details associated to the Hotel.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param hotelCodes Code or codes of specific hotels from which to get details.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec hotelWithIdDetailsUsingGETWithResponseSpec(String accept, String acceptEncoding, String hotelCodes, String language, Boolean useSecondaryLanguage) throws WebClientResponseException {
        return hotelWithIdDetailsUsingGETRequestCreation(accept, acceptEncoding, hotelCodes, language, useSecondaryLanguage);
    }
    /**
     * Hotels
     * Returns the list of currently existing hotels in Hotelbeds portfolio.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param destinationCode Filter to limit the results for an specific destination.
     * @param countryCode Filter to limit the results for an specific country.
     * @param codes Filter for a specific hotel or list of hotels.
     * @param includeHotels Use \&quot;webOnly\&quot; to include in the response hotels sellable only to websites. Use \&quot;notOnSale\&quot; to include in the response hotels without rates on sale. Both values can be combined either  this way:  ?includeHotels&#x3D;webOnly, notOnSale  or this way:  ?includeHotels&#x3D;webOnly&amp;includeHotels&#x3D;notOnSale . By default non of them is included in the response.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @param pmSRoomCode Sending this parameter as true in the /hotels operations will only return the hotels which possess at least one PMSRoomCode (useful when mapping against the original property codes).
     * @return ApiHotelsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec hotelsUsingGETRequestCreation(String accept, String acceptEncoding, String destinationCode, String countryCode, List<Integer> codes, String includeHotels, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime, Boolean pmSRoomCode) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling hotelsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling hotelsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "destinationCode", destinationCode));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "countryCode", countryCode));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "includeHotels", includeHotels));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "PMSRoomCode", pmSRoomCode));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiHotelsRS> localVarReturnType = new ParameterizedTypeReference<ApiHotelsRS>() {};
        return apiClient.invokeAPI("/hotels", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Hotels
     * Returns the list of currently existing hotels in Hotelbeds portfolio.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param destinationCode Filter to limit the results for an specific destination.
     * @param countryCode Filter to limit the results for an specific country.
     * @param codes Filter for a specific hotel or list of hotels.
     * @param includeHotels Use \&quot;webOnly\&quot; to include in the response hotels sellable only to websites. Use \&quot;notOnSale\&quot; to include in the response hotels without rates on sale. Both values can be combined either  this way:  ?includeHotels&#x3D;webOnly, notOnSale  or this way:  ?includeHotels&#x3D;webOnly&amp;includeHotels&#x3D;notOnSale . By default non of them is included in the response.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @param pmSRoomCode Sending this parameter as true in the /hotels operations will only return the hotels which possess at least one PMSRoomCode (useful when mapping against the original property codes).
     * @return ApiHotelsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiHotelsRS> hotelsUsingGET(String accept, String acceptEncoding, String destinationCode, String countryCode, List<Integer> codes, String includeHotels, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime, Boolean pmSRoomCode) throws WebClientResponseException {
        ParameterizedTypeReference<ApiHotelsRS> localVarReturnType = new ParameterizedTypeReference<ApiHotelsRS>() {};
        return hotelsUsingGETRequestCreation(accept, acceptEncoding, destinationCode, countryCode, codes, includeHotels, fields, language, from, to, useSecondaryLanguage, lastUpdateTime, pmSRoomCode).bodyToMono(localVarReturnType);
    }

    /**
     * Hotels
     * Returns the list of currently existing hotels in Hotelbeds portfolio.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param destinationCode Filter to limit the results for an specific destination.
     * @param countryCode Filter to limit the results for an specific country.
     * @param codes Filter for a specific hotel or list of hotels.
     * @param includeHotels Use \&quot;webOnly\&quot; to include in the response hotels sellable only to websites. Use \&quot;notOnSale\&quot; to include in the response hotels without rates on sale. Both values can be combined either  this way:  ?includeHotels&#x3D;webOnly, notOnSale  or this way:  ?includeHotels&#x3D;webOnly&amp;includeHotels&#x3D;notOnSale . By default non of them is included in the response.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @param pmSRoomCode Sending this parameter as true in the /hotels operations will only return the hotels which possess at least one PMSRoomCode (useful when mapping against the original property codes).
     * @return ResponseEntity&lt;ApiHotelsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiHotelsRS>> hotelsUsingGETWithHttpInfo(String accept, String acceptEncoding, String destinationCode, String countryCode, List<Integer> codes, String includeHotels, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime, Boolean pmSRoomCode) throws WebClientResponseException {
        ParameterizedTypeReference<ApiHotelsRS> localVarReturnType = new ParameterizedTypeReference<ApiHotelsRS>() {};
        return hotelsUsingGETRequestCreation(accept, acceptEncoding, destinationCode, countryCode, codes, includeHotels, fields, language, from, to, useSecondaryLanguage, lastUpdateTime, pmSRoomCode).toEntity(localVarReturnType);
    }

    /**
     * Hotels
     * Returns the list of currently existing hotels in Hotelbeds portfolio.
     * <p><b>200</b> - OK
     * <p><b>400</b> - **BAD REQUEST** - The server cannot or will not process the request due to an apparent client error.  *INVALID_REQUEST* - The request is not compliant with the specified version of the API. The message body will contain more information  *INVALID_DATA* - The JSON or XML syntax is correct, however some of the fields contain incorrect data. Please check the documentation for the allowed values and follow the message returned in order to fix this error.
     * <p><b>401</b> - **UNAUTHORIZED** - Authentication has failed or has not been provided.
     * <p><b>403</b> - **FORBIDDEN** - The credentials are correct and authorization was succesful, but access to this resource/operation is not allowed.
     * <p><b>500</b> - **INTERNAL SERVER ERROR** - An unexpected condition was encountered. Possible causes  *SYSTEM_ERROR* - These are internal server errors, please send us these errors together with the complete logs (JSON or XML requests and responses) at [apitude@hotelbeds.com]() so that our team can review them.   *CONFIGURATION_ERROR* - This type of error is produced by configuration restrictions set-up at account level. Usually this results in the inability to perform an specific operation. Here is a list of common configuration errors:  * *This apikey is not associated with a valid client*: This means that the provided apiKey belongs to an inactive client/agency. If you need information regarding the cause for this please contact our support team at [apitude@hotelbeds.com]().
     * <p><b>503</b> - **SERVICE UNAVAILABLE** - The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay. You can choose to resend the request again.  *SERVICE_OVERLOAD* - The server is currently unable to handle the request due to an overwhelming number of requests being processed. Condition which will be alleviated after some delay.
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param destinationCode Filter to limit the results for an specific destination.
     * @param countryCode Filter to limit the results for an specific country.
     * @param codes Filter for a specific hotel or list of hotels.
     * @param includeHotels Use \&quot;webOnly\&quot; to include in the response hotels sellable only to websites. Use \&quot;notOnSale\&quot; to include in the response hotels without rates on sale. Both values can be combined either  this way:  ?includeHotels&#x3D;webOnly, notOnSale  or this way:  ?includeHotels&#x3D;webOnly&amp;includeHotels&#x3D;notOnSale . By default non of them is included in the response.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @param pmSRoomCode Sending this parameter as true in the /hotels operations will only return the hotels which possess at least one PMSRoomCode (useful when mapping against the original property codes).
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec hotelsUsingGETWithResponseSpec(String accept, String acceptEncoding, String destinationCode, String countryCode, List<Integer> codes, String includeHotels, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime, Boolean pmSRoomCode) throws WebClientResponseException {
        return hotelsUsingGETRequestCreation(accept, acceptEncoding, destinationCode, countryCode, codes, includeHotels, fields, language, from, to, useSecondaryLanguage, lastUpdateTime, pmSRoomCode);
    }
}
