package travel.wink.hotelbeds.content.sdk.api;

import travel.wink.hotelbeds.content.sdk.invoker.ApiClient;

import travel.wink.hotelbeds.content.sdk.model.ApiCountriesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiDestinationsRS;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class LocationsApi {
    private ApiClient apiClient;

    public LocationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public LocationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Countries
     * Returns the list of available countries.  This is the higher level available in our destination tree. We do not allow search by country, but it&#39;s included for organizational reasons (to group destinations) and because the country codes returned are used in other levels of APItude (for example to define the sourceMarket in Availability operation of [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiCountriesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec countriesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling countriesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling countriesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiCountriesRS> localVarReturnType = new ParameterizedTypeReference<ApiCountriesRS>() {};
        return apiClient.invokeAPI("/locations/countries", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Countries
     * Returns the list of available countries.  This is the higher level available in our destination tree. We do not allow search by country, but it&#39;s included for organizational reasons (to group destinations) and because the country codes returned are used in other levels of APItude (for example to define the sourceMarket in Availability operation of [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiCountriesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiCountriesRS> countriesUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiCountriesRS> localVarReturnType = new ParameterizedTypeReference<ApiCountriesRS>() {};
        return countriesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Countries
     * Returns the list of available countries.  This is the higher level available in our destination tree. We do not allow search by country, but it&#39;s included for organizational reasons (to group destinations) and because the country codes returned are used in other levels of APItude (for example to define the sourceMarket in Availability operation of [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiCountriesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiCountriesRS>> countriesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiCountriesRS> localVarReturnType = new ParameterizedTypeReference<ApiCountriesRS>() {};
        return countriesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Countries
     * Returns the list of available countries.  This is the higher level available in our destination tree. We do not allow search by country, but it&#39;s included for organizational reasons (to group destinations) and because the country codes returned are used in other levels of APItude (for example to define the sourceMarket in Availability operation of [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec countriesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return countriesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Destinations
     * Return the list of available destinations, zones and grouping zones.   Destinations are the highest level entities in our destination tree by which availability can be searched. Please note that destination codes are not IATA codes. It is very important to understand that our &#39;destination&#39; will not always only correspond with a unique city, but usually with the main city and the area surrounding the city.   For example, the destination code NYC in the US, corresponds with the whole New York Area, so it is not limited to the city of New York, but also covers the surrounding areas, such as New Jersey and The Hamptons. Another example is BCN in Spain, which corresponds with the entire Barcelona Province; so it searches hotels located in the city of Barcelona, but also in other cities within the Province of Barcelona, such us Hospitalet de Llobregat, Terrassa and Sabadell. So when you search for availability using the destination code, you will receive results that may be located far from the main city for which you are actually searching.  It is very important to check the locations that the search retrieves to avoid booking hotels in a different location than the one requested by your customers.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes Filter to limit the results for an specific destination or list of destinations.
     * @param countryCodes Filter for a specific country of list of countries.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiDestinationsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec destinationsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, List<String> countryCodes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling destinationsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling destinationsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "countryCodes", countryCodes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiDestinationsRS> localVarReturnType = new ParameterizedTypeReference<ApiDestinationsRS>() {};
        return apiClient.invokeAPI("/locations/destinations", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Destinations
     * Return the list of available destinations, zones and grouping zones.   Destinations are the highest level entities in our destination tree by which availability can be searched. Please note that destination codes are not IATA codes. It is very important to understand that our &#39;destination&#39; will not always only correspond with a unique city, but usually with the main city and the area surrounding the city.   For example, the destination code NYC in the US, corresponds with the whole New York Area, so it is not limited to the city of New York, but also covers the surrounding areas, such as New Jersey and The Hamptons. Another example is BCN in Spain, which corresponds with the entire Barcelona Province; so it searches hotels located in the city of Barcelona, but also in other cities within the Province of Barcelona, such us Hospitalet de Llobregat, Terrassa and Sabadell. So when you search for availability using the destination code, you will receive results that may be located far from the main city for which you are actually searching.  It is very important to check the locations that the search retrieves to avoid booking hotels in a different location than the one requested by your customers.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes Filter to limit the results for an specific destination or list of destinations.
     * @param countryCodes Filter for a specific country of list of countries.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiDestinationsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiDestinationsRS> destinationsUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, List<String> countryCodes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiDestinationsRS> localVarReturnType = new ParameterizedTypeReference<ApiDestinationsRS>() {};
        return destinationsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, countryCodes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Destinations
     * Return the list of available destinations, zones and grouping zones.   Destinations are the highest level entities in our destination tree by which availability can be searched. Please note that destination codes are not IATA codes. It is very important to understand that our &#39;destination&#39; will not always only correspond with a unique city, but usually with the main city and the area surrounding the city.   For example, the destination code NYC in the US, corresponds with the whole New York Area, so it is not limited to the city of New York, but also covers the surrounding areas, such as New Jersey and The Hamptons. Another example is BCN in Spain, which corresponds with the entire Barcelona Province; so it searches hotels located in the city of Barcelona, but also in other cities within the Province of Barcelona, such us Hospitalet de Llobregat, Terrassa and Sabadell. So when you search for availability using the destination code, you will receive results that may be located far from the main city for which you are actually searching.  It is very important to check the locations that the search retrieves to avoid booking hotels in a different location than the one requested by your customers.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes Filter to limit the results for an specific destination or list of destinations.
     * @param countryCodes Filter for a specific country of list of countries.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiDestinationsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiDestinationsRS>> destinationsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, List<String> countryCodes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiDestinationsRS> localVarReturnType = new ParameterizedTypeReference<ApiDestinationsRS>() {};
        return destinationsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, countryCodes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Destinations
     * Return the list of available destinations, zones and grouping zones.   Destinations are the highest level entities in our destination tree by which availability can be searched. Please note that destination codes are not IATA codes. It is very important to understand that our &#39;destination&#39; will not always only correspond with a unique city, but usually with the main city and the area surrounding the city.   For example, the destination code NYC in the US, corresponds with the whole New York Area, so it is not limited to the city of New York, but also covers the surrounding areas, such as New Jersey and The Hamptons. Another example is BCN in Spain, which corresponds with the entire Barcelona Province; so it searches hotels located in the city of Barcelona, but also in other cities within the Province of Barcelona, such us Hospitalet de Llobregat, Terrassa and Sabadell. So when you search for availability using the destination code, you will receive results that may be located far from the main city for which you are actually searching.  It is very important to check the locations that the search retrieves to avoid booking hotels in a different location than the one requested by your customers.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes Filter to limit the results for an specific destination or list of destinations.
     * @param countryCodes Filter for a specific country of list of countries.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec destinationsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, List<String> countryCodes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return destinationsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, countryCodes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
}
