package travel.wink.hotelbeds.content.sdk.api;

import travel.wink.hotelbeds.content.sdk.invoker.ApiClient;

import travel.wink.hotelbeds.content.sdk.model.ApiAccommodationsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiBoardGroupsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiBoardsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiCategoriesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiChainsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiCurrenciesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiFacilitiesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiFacilityGroupsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiFacilityTypologiesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiGroupCategoriesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiImageTypesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiIssuesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiLanguagesRS;
import travel.wink.hotelbeds.content.sdk.model.ApiPromotionsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiRateClassRS;
import travel.wink.hotelbeds.content.sdk.model.ApiRateCommentDetailsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiRateCommentsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiRoomsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiSegmentsRS;
import travel.wink.hotelbeds.content.sdk.model.ApiTerminalsRS;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class TypesApi {
    private ApiClient apiClient;

    public TypesApi() {
        this(new ApiClient());
    }

    @Autowired
    public TypesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Accommodations
     * Returns the list of available accommodation types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiAccommodationsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec accommodationsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling accommodationsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling accommodationsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiAccommodationsRS> localVarReturnType = new ParameterizedTypeReference<ApiAccommodationsRS>() {};
        return apiClient.invokeAPI("/types/accommodations", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Accommodations
     * Returns the list of available accommodation types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiAccommodationsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiAccommodationsRS> accommodationsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiAccommodationsRS> localVarReturnType = new ParameterizedTypeReference<ApiAccommodationsRS>() {};
        return accommodationsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Accommodations
     * Returns the list of available accommodation types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiAccommodationsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiAccommodationsRS>> accommodationsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiAccommodationsRS> localVarReturnType = new ParameterizedTypeReference<ApiAccommodationsRS>() {};
        return accommodationsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Accommodations
     * Returns the list of available accommodation types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec accommodationsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return accommodationsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * BoardGroups
     * Returns the list of available board groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiBoardGroupsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec boardGroupsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling boardGroupsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling boardGroupsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiBoardGroupsRS> localVarReturnType = new ParameterizedTypeReference<ApiBoardGroupsRS>() {};
        return apiClient.invokeAPI("/types/boardgroups", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * BoardGroups
     * Returns the list of available board groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiBoardGroupsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiBoardGroupsRS> boardGroupsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiBoardGroupsRS> localVarReturnType = new ParameterizedTypeReference<ApiBoardGroupsRS>() {};
        return boardGroupsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * BoardGroups
     * Returns the list of available board groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiBoardGroupsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiBoardGroupsRS>> boardGroupsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiBoardGroupsRS> localVarReturnType = new ParameterizedTypeReference<ApiBoardGroupsRS>() {};
        return boardGroupsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * BoardGroups
     * Returns the list of available board groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec boardGroupsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return boardGroupsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Boards
     * Returns the list of available board types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiBoardsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec boardsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling boardsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling boardsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiBoardsRS> localVarReturnType = new ParameterizedTypeReference<ApiBoardsRS>() {};
        return apiClient.invokeAPI("/types/boards", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Boards
     * Returns the list of available board types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiBoardsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiBoardsRS> boardsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiBoardsRS> localVarReturnType = new ParameterizedTypeReference<ApiBoardsRS>() {};
        return boardsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Boards
     * Returns the list of available board types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiBoardsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiBoardsRS>> boardsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiBoardsRS> localVarReturnType = new ParameterizedTypeReference<ApiBoardsRS>() {};
        return boardsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Boards
     * Returns the list of available board types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec boardsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return boardsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Categories
     * Returns the list of available categories.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiCategoriesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec categoriesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling categoriesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling categoriesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiCategoriesRS> localVarReturnType = new ParameterizedTypeReference<ApiCategoriesRS>() {};
        return apiClient.invokeAPI("/types/categories", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Categories
     * Returns the list of available categories.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiCategoriesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiCategoriesRS> categoriesUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiCategoriesRS> localVarReturnType = new ParameterizedTypeReference<ApiCategoriesRS>() {};
        return categoriesUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Categories
     * Returns the list of available categories.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiCategoriesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiCategoriesRS>> categoriesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiCategoriesRS> localVarReturnType = new ParameterizedTypeReference<ApiCategoriesRS>() {};
        return categoriesUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Categories
     * Returns the list of available categories.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec categoriesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return categoriesUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Chains
     * Returns the list of available chains. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiChainsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec chainsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling chainsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling chainsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiChainsRS> localVarReturnType = new ParameterizedTypeReference<ApiChainsRS>() {};
        return apiClient.invokeAPI("/types/chains", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Chains
     * Returns the list of available chains. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiChainsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiChainsRS> chainsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiChainsRS> localVarReturnType = new ParameterizedTypeReference<ApiChainsRS>() {};
        return chainsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Chains
     * Returns the list of available chains. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiChainsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiChainsRS>> chainsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiChainsRS> localVarReturnType = new ParameterizedTypeReference<ApiChainsRS>() {};
        return chainsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Chains
     * Returns the list of available chains. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec chainsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return chainsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Classifications
     * Returns the list of available values for the rateClass.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRateClassRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec classificationsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling classificationsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling classificationsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiRateClassRS> localVarReturnType = new ParameterizedTypeReference<ApiRateClassRS>() {};
        return apiClient.invokeAPI("/types/classifications", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Classifications
     * Returns the list of available values for the rateClass.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRateClassRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiRateClassRS> classificationsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRateClassRS> localVarReturnType = new ParameterizedTypeReference<ApiRateClassRS>() {};
        return classificationsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Classifications
     * Returns the list of available values for the rateClass.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiRateClassRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiRateClassRS>> classificationsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRateClassRS> localVarReturnType = new ParameterizedTypeReference<ApiRateClassRS>() {};
        return classificationsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Classifications
     * Returns the list of available values for the rateClass.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec classificationsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return classificationsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Currencies
     * Returns the list of available currencies.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiCurrenciesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec currenciesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling currenciesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling currenciesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiCurrenciesRS> localVarReturnType = new ParameterizedTypeReference<ApiCurrenciesRS>() {};
        return apiClient.invokeAPI("/types/currencies", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Currencies
     * Returns the list of available currencies.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiCurrenciesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiCurrenciesRS> currenciesUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiCurrenciesRS> localVarReturnType = new ParameterizedTypeReference<ApiCurrenciesRS>() {};
        return currenciesUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Currencies
     * Returns the list of available currencies.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiCurrenciesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiCurrenciesRS>> currenciesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiCurrenciesRS> localVarReturnType = new ParameterizedTypeReference<ApiCurrenciesRS>() {};
        return currenciesUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Currencies
     * Returns the list of available currencies.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec currenciesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return currenciesUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Facilities
     * Returns the list of available facilities.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiFacilitiesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec facilitiesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling facilitiesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling facilitiesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiFacilitiesRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilitiesRS>() {};
        return apiClient.invokeAPI("/types/facilities", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Facilities
     * Returns the list of available facilities.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiFacilitiesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiFacilitiesRS> facilitiesUsingGET(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiFacilitiesRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilitiesRS>() {};
        return facilitiesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Facilities
     * Returns the list of available facilities.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiFacilitiesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiFacilitiesRS>> facilitiesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiFacilitiesRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilitiesRS>() {};
        return facilitiesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Facilities
     * Returns the list of available facilities.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec facilitiesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return facilitiesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Facility groups
     * Returns the list of available facility groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiFacilityGroupsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec facilitygroupsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling facilitygroupsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling facilitygroupsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiFacilityGroupsRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilityGroupsRS>() {};
        return apiClient.invokeAPI("/types/facilitygroups", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Facility groups
     * Returns the list of available facility groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiFacilityGroupsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiFacilityGroupsRS> facilitygroupsUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiFacilityGroupsRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilityGroupsRS>() {};
        return facilitygroupsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Facility groups
     * Returns the list of available facility groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiFacilityGroupsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiFacilityGroupsRS>> facilitygroupsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiFacilityGroupsRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilityGroupsRS>() {};
        return facilitygroupsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Facility groups
     * Returns the list of available facility groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec facilitygroupsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return facilitygroupsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Facility typologies
     * Returns the list of available facility typologies.Remarks: Since all fields are returned by default, there won&#39;t be any field to filter.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiFacilityTypologiesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec facilitytypologiesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling facilitytypologiesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling facilitytypologiesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiFacilityTypologiesRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilityTypologiesRS>() {};
        return apiClient.invokeAPI("/types/facilitytypologies", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Facility typologies
     * Returns the list of available facility typologies.Remarks: Since all fields are returned by default, there won&#39;t be any field to filter.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiFacilityTypologiesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiFacilityTypologiesRS> facilitytypologiesUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiFacilityTypologiesRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilityTypologiesRS>() {};
        return facilitytypologiesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Facility typologies
     * Returns the list of available facility typologies.Remarks: Since all fields are returned by default, there won&#39;t be any field to filter.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiFacilityTypologiesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiFacilityTypologiesRS>> facilitytypologiesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiFacilityTypologiesRS> localVarReturnType = new ParameterizedTypeReference<ApiFacilityTypologiesRS>() {};
        return facilitytypologiesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Facility typologies
     * Returns the list of available facility typologies.Remarks: Since all fields are returned by default, there won&#39;t be any field to filter.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec facilitytypologiesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return facilitytypologiesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Group categories
     * Returns the descriptions of the different category groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiGroupCategoriesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec groupcategoriesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling groupcategoriesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling groupcategoriesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiGroupCategoriesRS> localVarReturnType = new ParameterizedTypeReference<ApiGroupCategoriesRS>() {};
        return apiClient.invokeAPI("/types/groupcategories", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Group categories
     * Returns the descriptions of the different category groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiGroupCategoriesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiGroupCategoriesRS> groupcategoriesUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiGroupCategoriesRS> localVarReturnType = new ParameterizedTypeReference<ApiGroupCategoriesRS>() {};
        return groupcategoriesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Group categories
     * Returns the descriptions of the different category groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiGroupCategoriesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiGroupCategoriesRS>> groupcategoriesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiGroupCategoriesRS> localVarReturnType = new ParameterizedTypeReference<ApiGroupCategoriesRS>() {};
        return groupcategoriesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Group categories
     * Returns the descriptions of the different category groups.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec groupcategoriesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return groupcategoriesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Image types
     * Returns the descriptions of the different image types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiImageTypesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec imagetypesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling imagetypesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling imagetypesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiImageTypesRS> localVarReturnType = new ParameterizedTypeReference<ApiImageTypesRS>() {};
        return apiClient.invokeAPI("/types/imagetypes", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Image types
     * Returns the descriptions of the different image types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiImageTypesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiImageTypesRS> imagetypesUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiImageTypesRS> localVarReturnType = new ParameterizedTypeReference<ApiImageTypesRS>() {};
        return imagetypesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Image types
     * Returns the descriptions of the different image types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiImageTypesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiImageTypesRS>> imagetypesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiImageTypesRS> localVarReturnType = new ParameterizedTypeReference<ApiImageTypesRS>() {};
        return imagetypesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Image types
     * Returns the descriptions of the different image types.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec imagetypesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return imagetypesUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Hotel Issues
     * Repair works, facilities closed,...
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiIssuesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec issuesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling issuesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling issuesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiIssuesRS> localVarReturnType = new ParameterizedTypeReference<ApiIssuesRS>() {};
        return apiClient.invokeAPI("/types/issues", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Hotel Issues
     * Repair works, facilities closed,...
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiIssuesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiIssuesRS> issuesUsingGET(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiIssuesRS> localVarReturnType = new ParameterizedTypeReference<ApiIssuesRS>() {};
        return issuesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Hotel Issues
     * Repair works, facilities closed,...
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiIssuesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiIssuesRS>> issuesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiIssuesRS> localVarReturnType = new ParameterizedTypeReference<ApiIssuesRS>() {};
        return issuesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Hotel Issues
     * Repair works, facilities closed,...
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec issuesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return issuesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Languages
     * Returns the list of available languages.  The Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiLanguagesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec languagesUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling languagesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling languagesUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiLanguagesRS> localVarReturnType = new ParameterizedTypeReference<ApiLanguagesRS>() {};
        return apiClient.invokeAPI("/types/languages", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Languages
     * Returns the list of available languages.  The Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiLanguagesRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiLanguagesRS> languagesUsingGET(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiLanguagesRS> localVarReturnType = new ParameterizedTypeReference<ApiLanguagesRS>() {};
        return languagesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Languages
     * Returns the list of available languages.  The Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiLanguagesRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiLanguagesRS>> languagesUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiLanguagesRS> localVarReturnType = new ParameterizedTypeReference<ApiLanguagesRS>() {};
        return languagesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Languages
     * Returns the list of available languages.  The Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec languagesUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return languagesUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Promotions
     * Returns the list of available promotions.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiPromotionsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec promotionsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling promotionsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling promotionsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiPromotionsRS> localVarReturnType = new ParameterizedTypeReference<ApiPromotionsRS>() {};
        return apiClient.invokeAPI("/types/promotions", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Promotions
     * Returns the list of available promotions.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiPromotionsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiPromotionsRS> promotionsUsingGET(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiPromotionsRS> localVarReturnType = new ParameterizedTypeReference<ApiPromotionsRS>() {};
        return promotionsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Promotions
     * Returns the list of available promotions.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiPromotionsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiPromotionsRS>> promotionsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiPromotionsRS> localVarReturnType = new ParameterizedTypeReference<ApiPromotionsRS>() {};
        return promotionsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Promotions
     * Returns the list of available promotions.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param codes List of codes to filter by.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec promotionsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, List<String> codes, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return promotionsUsingGETRequestCreation(accept, acceptEncoding, fields, codes, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Rate comments
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRateCommentsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec rateCommentsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling rateCommentsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling rateCommentsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiRateCommentsRS> localVarReturnType = new ParameterizedTypeReference<ApiRateCommentsRS>() {};
        return apiClient.invokeAPI("/types/ratecomments", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Rate comments
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRateCommentsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiRateCommentsRS> rateCommentsUsingGET(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRateCommentsRS> localVarReturnType = new ParameterizedTypeReference<ApiRateCommentsRS>() {};
        return rateCommentsUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Rate comments
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiRateCommentsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiRateCommentsRS>> rateCommentsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRateCommentsRS> localVarReturnType = new ParameterizedTypeReference<ApiRateCommentsRS>() {};
        return rateCommentsUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Rate comments
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec rateCommentsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return rateCommentsUsingGETRequestCreation(accept, acceptEncoding, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Rate comment details
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking with the given date.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param date Comment date
     * @param code Code (symbol pipe should be escaped with %7C HTML encoding)
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRateCommentDetailsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec ratecommentdetailUsingGETRequestCreation(String accept, String acceptEncoding, String date, String code, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling ratecommentdetailUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling ratecommentdetailUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'date' is set
        if (date == null) {
            throw new WebClientResponseException("Missing the required parameter 'date' when calling ratecommentdetailUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new WebClientResponseException("Missing the required parameter 'code' when calling ratecommentdetailUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "date", date));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "code", code));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiRateCommentDetailsRS> localVarReturnType = new ParameterizedTypeReference<ApiRateCommentDetailsRS>() {};
        return apiClient.invokeAPI("/types/ratecommentdetails", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Rate comment details
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking with the given date.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param date Comment date
     * @param code Code (symbol pipe should be escaped with %7C HTML encoding)
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRateCommentDetailsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiRateCommentDetailsRS> ratecommentdetailUsingGET(String accept, String acceptEncoding, String date, String code, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRateCommentDetailsRS> localVarReturnType = new ParameterizedTypeReference<ApiRateCommentDetailsRS>() {};
        return ratecommentdetailUsingGETRequestCreation(accept, acceptEncoding, date, code, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Rate comment details
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking with the given date.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param date Comment date
     * @param code Code (symbol pipe should be escaped with %7C HTML encoding)
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiRateCommentDetailsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiRateCommentDetailsRS>> ratecommentdetailUsingGETWithHttpInfo(String accept, String acceptEncoding, String date, String code, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRateCommentDetailsRS> localVarReturnType = new ParameterizedTypeReference<ApiRateCommentDetailsRS>() {};
        return ratecommentdetailUsingGETRequestCreation(accept, acceptEncoding, date, code, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Rate comment details
     * Returns the descriptions of the rate comments associated with the hotel that the hotelier wants the client to read before confirming the booking with the given date.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param date Comment date
     * @param code Code (symbol pipe should be escaped with %7C HTML encoding)
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec ratecommentdetailUsingGETWithResponseSpec(String accept, String acceptEncoding, String date, String code, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return ratecommentdetailUsingGETRequestCreation(accept, acceptEncoding, date, code, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Rooms
     * Returns the list of available rooms.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRoomsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec roomsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling roomsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling roomsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiRoomsRS> localVarReturnType = new ParameterizedTypeReference<ApiRoomsRS>() {};
        return apiClient.invokeAPI("/types/rooms", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Rooms
     * Returns the list of available rooms.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiRoomsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiRoomsRS> roomsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRoomsRS> localVarReturnType = new ParameterizedTypeReference<ApiRoomsRS>() {};
        return roomsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Rooms
     * Returns the list of available rooms.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiRoomsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiRoomsRS>> roomsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiRoomsRS> localVarReturnType = new ParameterizedTypeReference<ApiRoomsRS>() {};
        return roomsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Rooms
     * Returns the list of available rooms.
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec roomsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return roomsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Segments
     * Returns the list of available segments. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiSegmentsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec segmentsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling segmentsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling segmentsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiSegmentsRS> localVarReturnType = new ParameterizedTypeReference<ApiSegmentsRS>() {};
        return apiClient.invokeAPI("/types/segments", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Segments
     * Returns the list of available segments. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiSegmentsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiSegmentsRS> segmentsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiSegmentsRS> localVarReturnType = new ParameterizedTypeReference<ApiSegmentsRS>() {};
        return segmentsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Segments
     * Returns the list of available segments. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiSegmentsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiSegmentsRS>> segmentsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiSegmentsRS> localVarReturnType = new ParameterizedTypeReference<ApiSegmentsRS>() {};
        return segmentsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Segments
     * Returns the list of available segments. 
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec segmentsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return segmentsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
    /**
     * Terminals
     * List of terminals per country/destination
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiTerminalsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec terminalsUsingGETRequestCreation(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling terminalsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acceptEncoding' is set
        if (acceptEncoding == null) {
            throw new WebClientResponseException("Missing the required parameter 'acceptEncoding' when calling terminalsUsingGET", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "codes", codes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "from", from));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "to", to));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "useSecondaryLanguage", useSecondaryLanguage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastUpdateTime", lastUpdateTime));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        final String[] localVarAccepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "Apikey", "Xsignature" };

        ParameterizedTypeReference<ApiTerminalsRS> localVarReturnType = new ParameterizedTypeReference<ApiTerminalsRS>() {};
        return apiClient.invokeAPI("/types/terminals", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Terminals
     * List of terminals per country/destination
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ApiTerminalsRS
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ApiTerminalsRS> terminalsUsingGET(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiTerminalsRS> localVarReturnType = new ParameterizedTypeReference<ApiTerminalsRS>() {};
        return terminalsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).bodyToMono(localVarReturnType);
    }

    /**
     * Terminals
     * List of terminals per country/destination
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseEntity&lt;ApiTerminalsRS&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ApiTerminalsRS>> terminalsUsingGETWithHttpInfo(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        ParameterizedTypeReference<ApiTerminalsRS> localVarReturnType = new ParameterizedTypeReference<ApiTerminalsRS>() {};
        return terminalsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime).toEntity(localVarReturnType);
    }

    /**
     * Terminals
     * List of terminals per country/destination
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad Request
     * <p><b>401</b> - Unauthorized
     * <p><b>402</b> - Payment Required
     * <p><b>500</b> - Internal Server Error
     * <p><b>503</b> - Product Exception/Service Unavailable
     * @param accept Response format, posible values are application/json and application/xml.
     * @param acceptEncoding Defines type of encoding used on the data.
     * @param codes List of codes to filter by.
     * @param fields The list of fields to be received in the response. To retrieve all the fields use ‘all’. If nothing is specified, all fields are returned. See the complete list of available fields in the response.
     * @param language The language code for the language in which you want the descriptions to be returned. If language is not specified, English will be used as default language.
     * @param from The number of the initial record to receive. If nothing is specified, 1 is the default value.
     * @param to The number of the final record to receive. If nothing is indicated, 100 is the default value.
     * @param useSecondaryLanguage Defines if you want to receive the descriptions in English if the description is not available in the language requested.
     * @param lastUpdateTime Specifying this parameter limits the results to those modified or added after the date specified. The required format is YYYY-MM-DD.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec terminalsUsingGETWithResponseSpec(String accept, String acceptEncoding, List<String> codes, List<String> fields, String language, Integer from, Integer to, Boolean useSecondaryLanguage, String lastUpdateTime) throws WebClientResponseException {
        return terminalsUsingGETRequestCreation(accept, acceptEncoding, codes, fields, language, from, to, useSecondaryLanguage, lastUpdateTime);
    }
}
