/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on an accommodation category.
 */
@JsonPropertyOrder({
  ApiCategory.JSON_PROPERTY_ACCOMMODATION_TYPE,
  ApiCategory.JSON_PROPERTY_CODE,
  ApiCategory.JSON_PROPERTY_DESCRIPTION,
  ApiCategory.JSON_PROPERTY_GROUP,
  ApiCategory.JSON_PROPERTY_SIMPLE_CODE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiCategory {
  public static final String JSON_PROPERTY_ACCOMMODATION_TYPE = "accommodationType";
  private String accommodationType;

  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private ApiContent description;

  public static final String JSON_PROPERTY_GROUP = "group";
  private String group;

  public static final String JSON_PROPERTY_SIMPLE_CODE = "simpleCode";
  private Integer simpleCode;

  public ApiCategory() {
  }

  public ApiCategory accommodationType(String accommodationType) {
    
    this.accommodationType = accommodationType;
    return this;
  }

   /**
   * Code of the type of accommodation to which the category belongs. (apartment, hotel, home, etc.).
   * @return accommodationType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOMMODATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccommodationType() {
    return accommodationType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOMMODATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccommodationType(String accommodationType) {
    this.accommodationType = accommodationType;
  }


  public ApiCategory code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Hotel star rating based on the information provided by the hotel.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }


  public ApiCategory description(ApiContent description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(ApiContent description) {
    this.description = description;
  }


  public ApiCategory group(String group) {
    
    this.group = group;
    return this;
  }

   /**
   * Code of the group to which the category belongs.
   * @return group
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGroup() {
    return group;
  }


  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroup(String group) {
    this.group = group;
  }


  public ApiCategory simpleCode(Integer simpleCode) {
    
    this.simpleCode = simpleCode;
    return this;
  }

   /**
   * Simple category code used for filtering in [Hotel Booking API](/documentation/hotels/booking-api/api-reference/) Availability.
   * @return simpleCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SIMPLE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSimpleCode() {
    return simpleCode;
  }


  @JsonProperty(JSON_PROPERTY_SIMPLE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSimpleCode(Integer simpleCode) {
    this.simpleCode = simpleCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiCategory apiCategory = (ApiCategory) o;
    return Objects.equals(this.accommodationType, apiCategory.accommodationType) &&
        Objects.equals(this.code, apiCategory.code) &&
        Objects.equals(this.description, apiCategory.description) &&
        Objects.equals(this.group, apiCategory.group) &&
        Objects.equals(this.simpleCode, apiCategory.simpleCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accommodationType, code, description, group, simpleCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiCategory {\n");
    sb.append("    accommodationType: ").append(toIndentedString(accommodationType)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    simpleCode: ").append(toIndentedString(simpleCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

