/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import travel.wink.hotelbeds.content.sdk.model.ApiGroupZone;
import travel.wink.hotelbeds.content.sdk.model.ApiZone;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on a destination of the destination tree.
 */
@JsonPropertyOrder({
  ApiDestination.JSON_PROPERTY_CODE,
  ApiDestination.JSON_PROPERTY_COUNTRY_CODE,
  ApiDestination.JSON_PROPERTY_GROUP_ZONES,
  ApiDestination.JSON_PROPERTY_ISO_CODE,
  ApiDestination.JSON_PROPERTY_NAME,
  ApiDestination.JSON_PROPERTY_ZONES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiDestination {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_GROUP_ZONES = "groupZones";
  private List<ApiGroupZone> groupZones;

  public static final String JSON_PROPERTY_ISO_CODE = "isoCode";
  private String isoCode;

  public static final String JSON_PROPERTY_NAME = "name";
  private ApiContent name;

  public static final String JSON_PROPERTY_ZONES = "zones";
  private List<ApiZone> zones;

  public ApiDestination() {
  }

  public ApiDestination code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Code of the destination.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }


  public ApiDestination countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Hotelbeds code for the country
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public ApiDestination groupZones(List<ApiGroupZone> groupZones) {
    
    this.groupZones = groupZones;
    return this;
  }

  public ApiDestination addGroupZonesItem(ApiGroupZone groupZonesItem) {
    if (this.groupZones == null) {
      this.groupZones = new ArrayList<>();
    }
    this.groupZones.add(groupZonesItem);
    return this;
  }

   /**
   * List of groups of zones.
   * @return groupZones
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GROUP_ZONES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiGroupZone> getGroupZones() {
    return groupZones;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ZONES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupZones(List<ApiGroupZone> groupZones) {
    this.groupZones = groupZones;
  }


  public ApiDestination isoCode(String isoCode) {
    
    this.isoCode = isoCode;
    return this;
  }

   /**
   * ISO Country Code.
   * @return isoCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIsoCode() {
    return isoCode;
  }


  @JsonProperty(JSON_PROPERTY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsoCode(String isoCode) {
    this.isoCode = isoCode;
  }


  public ApiDestination name(ApiContent name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(ApiContent name) {
    this.name = name;
  }


  public ApiDestination zones(List<ApiZone> zones) {
    
    this.zones = zones;
    return this;
  }

  public ApiDestination addZonesItem(ApiZone zonesItem) {
    if (this.zones == null) {
      this.zones = new ArrayList<>();
    }
    this.zones.add(zonesItem);
    return this;
  }

   /**
   * List of zones in which the destination is divided.
   * @return zones
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ZONES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiZone> getZones() {
    return zones;
  }


  @JsonProperty(JSON_PROPERTY_ZONES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZones(List<ApiZone> zones) {
    this.zones = zones;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiDestination apiDestination = (ApiDestination) o;
    return Objects.equals(this.code, apiDestination.code) &&
        Objects.equals(this.countryCode, apiDestination.countryCode) &&
        Objects.equals(this.groupZones, apiDestination.groupZones) &&
        Objects.equals(this.isoCode, apiDestination.isoCode) &&
        Objects.equals(this.name, apiDestination.name) &&
        Objects.equals(this.zones, apiDestination.zones);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, countryCode, groupZones, isoCode, name, zones);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiDestination {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    groupZones: ").append(toIndentedString(groupZones)).append("\n");
    sb.append("    isoCode: ").append(toIndentedString(isoCode)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    zones: ").append(toIndentedString(zones)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

