/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on a hotel facility.
 */
@JsonPropertyOrder({
  ApiFacility.JSON_PROPERTY_CODE,
  ApiFacility.JSON_PROPERTY_DESCRIPTION,
  ApiFacility.JSON_PROPERTY_FACILITY_GROUP_CODE,
  ApiFacility.JSON_PROPERTY_FACILITY_TYPOLOGY_CODE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiFacility {
  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private ApiContent description;

  public static final String JSON_PROPERTY_FACILITY_GROUP_CODE = "facilityGroupCode";
  private Integer facilityGroupCode;

  public static final String JSON_PROPERTY_FACILITY_TYPOLOGY_CODE = "facilityTypologyCode";
  private Integer facilityTypologyCode;

  public ApiFacility() {
  }

  public ApiFacility code(Integer code) {
    
    this.code = code;
    return this;
  }

   /**
   * Code of the facility.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public ApiFacility description(ApiContent description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(ApiContent description) {
    this.description = description;
  }


  public ApiFacility facilityGroupCode(Integer facilityGroupCode) {
    
    this.facilityGroupCode = facilityGroupCode;
    return this;
  }

   /**
   * Group the facility belongs to.
   * @return facilityGroupCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityGroupCode() {
    return facilityGroupCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityGroupCode(Integer facilityGroupCode) {
    this.facilityGroupCode = facilityGroupCode;
  }


  public ApiFacility facilityTypologyCode(Integer facilityTypologyCode) {
    
    this.facilityTypologyCode = facilityTypologyCode;
    return this;
  }

   /**
   * Typology of the facility which determines the fields to receive in the hotels operation.
   * @return facilityTypologyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_TYPOLOGY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityTypologyCode() {
    return facilityTypologyCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_TYPOLOGY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityTypologyCode(Integer facilityTypologyCode) {
    this.facilityTypologyCode = facilityTypologyCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiFacility apiFacility = (ApiFacility) o;
    return Objects.equals(this.code, apiFacility.code) &&
        Objects.equals(this.description, apiFacility.description) &&
        Objects.equals(this.facilityGroupCode, apiFacility.facilityGroupCode) &&
        Objects.equals(this.facilityTypologyCode, apiFacility.facilityTypologyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, description, facilityGroupCode, facilityTypologyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiFacility {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    facilityGroupCode: ").append(toIndentedString(facilityGroupCode)).append("\n");
    sb.append("    facilityTypologyCode: ").append(toIndentedString(facilityTypologyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

