/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.content.sdk.model.ApiAccommodation;
import travel.wink.hotelbeds.content.sdk.model.ApiBoard;
import travel.wink.hotelbeds.content.sdk.model.ApiCategory;
import travel.wink.hotelbeds.content.sdk.model.ApiChain;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import travel.wink.hotelbeds.content.sdk.model.ApiCountry;
import travel.wink.hotelbeds.content.sdk.model.ApiDestination;
import travel.wink.hotelbeds.content.sdk.model.ApiGeoLocation;
import travel.wink.hotelbeds.content.sdk.model.ApiGroupCategory;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelFacility;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelIssue;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelPhone;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelPointOfInterest;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelRoom;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelTerminal;
import travel.wink.hotelbeds.content.sdk.model.ApiImage;
import travel.wink.hotelbeds.content.sdk.model.ApiSegment;
import travel.wink.hotelbeds.content.sdk.model.ApiState;
import travel.wink.hotelbeds.content.sdk.model.ApiWildCard;
import travel.wink.hotelbeds.content.sdk.model.ApiZone;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on a hotel.
 */
@JsonPropertyOrder({
  ApiHotel.JSON_PROPERTY_S2_C,
  ApiHotel.JSON_PROPERTY_ACCOMMODATION_TYPE,
  ApiHotel.JSON_PROPERTY_ACCOMMODATION_TYPE_CODE,
  ApiHotel.JSON_PROPERTY_ADDRESS,
  ApiHotel.JSON_PROPERTY_BOARD_CODES,
  ApiHotel.JSON_PROPERTY_BOARDS,
  ApiHotel.JSON_PROPERTY_CATEGORY,
  ApiHotel.JSON_PROPERTY_CATEGORY_CODE,
  ApiHotel.JSON_PROPERTY_CATEGORY_GROUP,
  ApiHotel.JSON_PROPERTY_CATEGORY_GROUP_CODE,
  ApiHotel.JSON_PROPERTY_CHAIN,
  ApiHotel.JSON_PROPERTY_CHAIN_CODE,
  ApiHotel.JSON_PROPERTY_CITY,
  ApiHotel.JSON_PROPERTY_CODE,
  ApiHotel.JSON_PROPERTY_COORDINATES,
  ApiHotel.JSON_PROPERTY_COUNTRY,
  ApiHotel.JSON_PROPERTY_COUNTRY_CODE,
  ApiHotel.JSON_PROPERTY_DESCRIPTION,
  ApiHotel.JSON_PROPERTY_DESTINATION,
  ApiHotel.JSON_PROPERTY_DESTINATION_CODE,
  ApiHotel.JSON_PROPERTY_EMAIL,
  ApiHotel.JSON_PROPERTY_EXCLUSIVE_DEAL,
  ApiHotel.JSON_PROPERTY_FACILITIES,
  ApiHotel.JSON_PROPERTY_GIATA_CODE,
  ApiHotel.JSON_PROPERTY_IMAGES,
  ApiHotel.JSON_PROPERTY_INTEREST_POINTS,
  ApiHotel.JSON_PROPERTY_ISSUES,
  ApiHotel.JSON_PROPERTY_LAST_UPDATE,
  ApiHotel.JSON_PROPERTY_LICENSE,
  ApiHotel.JSON_PROPERTY_NAME,
  ApiHotel.JSON_PROPERTY_PHONES,
  ApiHotel.JSON_PROPERTY_POSTAL_CODE,
  ApiHotel.JSON_PROPERTY_RANKING,
  ApiHotel.JSON_PROPERTY_ROOMS,
  ApiHotel.JSON_PROPERTY_SEGMENT_CODES,
  ApiHotel.JSON_PROPERTY_SEGMENTS,
  ApiHotel.JSON_PROPERTY_STATE,
  ApiHotel.JSON_PROPERTY_STATE_CODE,
  ApiHotel.JSON_PROPERTY_TERMINALS,
  ApiHotel.JSON_PROPERTY_WEB,
  ApiHotel.JSON_PROPERTY_WILDCARDS,
  ApiHotel.JSON_PROPERTY_ZONE,
  ApiHotel.JSON_PROPERTY_ZONE_CODE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiHotel {
  public static final String JSON_PROPERTY_S2_C = "S2C";
  private String S2C;

  public static final String JSON_PROPERTY_ACCOMMODATION_TYPE = "accommodationType";
  private ApiAccommodation accommodationType;

  public static final String JSON_PROPERTY_ACCOMMODATION_TYPE_CODE = "accommodationTypeCode";
  private String accommodationTypeCode;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private ApiContent address;

  public static final String JSON_PROPERTY_BOARD_CODES = "boardCodes";
  private List<String> boardCodes;

  public static final String JSON_PROPERTY_BOARDS = "boards";
  private List<ApiBoard> boards;

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private ApiCategory category;

  public static final String JSON_PROPERTY_CATEGORY_CODE = "categoryCode";
  private String categoryCode;

  public static final String JSON_PROPERTY_CATEGORY_GROUP = "categoryGroup";
  private ApiGroupCategory categoryGroup;

  public static final String JSON_PROPERTY_CATEGORY_GROUP_CODE = "categoryGroupCode";
  private String categoryGroupCode;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private ApiChain chain;

  public static final String JSON_PROPERTY_CHAIN_CODE = "chainCode";
  private String chainCode;

  public static final String JSON_PROPERTY_CITY = "city";
  private ApiContent city;

  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_COORDINATES = "coordinates";
  private ApiGeoLocation coordinates;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private ApiCountry country;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private ApiContent description;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private ApiDestination destination;

  public static final String JSON_PROPERTY_DESTINATION_CODE = "destinationCode";
  private String destinationCode;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_EXCLUSIVE_DEAL = "exclusiveDeal";
  private Integer exclusiveDeal;

  public static final String JSON_PROPERTY_FACILITIES = "facilities";
  private List<ApiHotelFacility> facilities;

  public static final String JSON_PROPERTY_GIATA_CODE = "giataCode";
  private Integer giataCode;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<ApiImage> images;

  public static final String JSON_PROPERTY_INTEREST_POINTS = "interestPoints";
  private List<ApiHotelPointOfInterest> interestPoints;

  public static final String JSON_PROPERTY_ISSUES = "issues";
  private List<ApiHotelIssue> issues;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private String lastUpdate;

  public static final String JSON_PROPERTY_LICENSE = "license";
  private String license;

  public static final String JSON_PROPERTY_NAME = "name";
  private ApiContent name;

  public static final String JSON_PROPERTY_PHONES = "phones";
  private List<ApiHotelPhone> phones;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_RANKING = "ranking";
  private Integer ranking;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<ApiHotelRoom> rooms;

  public static final String JSON_PROPERTY_SEGMENT_CODES = "segmentCodes";
  private List<Integer> segmentCodes;

  public static final String JSON_PROPERTY_SEGMENTS = "segments";
  private List<ApiSegment> segments;

  public static final String JSON_PROPERTY_STATE = "state";
  private ApiState state;

  public static final String JSON_PROPERTY_STATE_CODE = "stateCode";
  private String stateCode;

  public static final String JSON_PROPERTY_TERMINALS = "terminals";
  private List<ApiHotelTerminal> terminals;

  public static final String JSON_PROPERTY_WEB = "web";
  private String web;

  public static final String JSON_PROPERTY_WILDCARDS = "wildcards";
  private List<ApiWildCard> wildcards;

  public static final String JSON_PROPERTY_ZONE = "zone";
  private ApiZone zone;

  public static final String JSON_PROPERTY_ZONE_CODE = "zoneCode";
  private Integer zoneCode;

  public ApiHotel() {
  }

  public ApiHotel S2C(String S2C) {
    
    this.S2C = S2C;
    return this;
  }

   /**
   * Health &amp; Safety rating (NOTE: please bear in mind is not related to hotel category).
   * @return S2C
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_S2_C)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getS2C() {
    return S2C;
  }


  @JsonProperty(JSON_PROPERTY_S2_C)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setS2C(String S2C) {
    this.S2C = S2C;
  }


  public ApiHotel accommodationType(ApiAccommodation accommodationType) {
    
    this.accommodationType = accommodationType;
    return this;
  }

   /**
   * Get accommodationType
   * @return accommodationType
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCOMMODATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiAccommodation getAccommodationType() {
    return accommodationType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOMMODATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccommodationType(ApiAccommodation accommodationType) {
    this.accommodationType = accommodationType;
  }


  public ApiHotel accommodationTypeCode(String accommodationTypeCode) {
    
    this.accommodationTypeCode = accommodationTypeCode;
    return this;
  }

   /**
   * Code of the type of accommodation. It will indicate the type of the hotel (apartment, hotel, home, etc.).
   * @return accommodationTypeCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOMMODATION_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccommodationTypeCode() {
    return accommodationTypeCode;
  }


  @JsonProperty(JSON_PROPERTY_ACCOMMODATION_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccommodationTypeCode(String accommodationTypeCode) {
    this.accommodationTypeCode = accommodationTypeCode;
  }


  public ApiHotel address(ApiContent address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(ApiContent address) {
    this.address = address;
  }


  public ApiHotel boardCodes(List<String> boardCodes) {
    
    this.boardCodes = boardCodes;
    return this;
  }

  public ApiHotel addBoardCodesItem(String boardCodesItem) {
    if (this.boardCodes == null) {
      this.boardCodes = new ArrayList<>();
    }
    this.boardCodes.add(boardCodesItem);
    return this;
  }

   /**
   * List of codes of board types offered at the hotel.
   * @return boardCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOARD_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBoardCodes() {
    return boardCodes;
  }


  @JsonProperty(JSON_PROPERTY_BOARD_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardCodes(List<String> boardCodes) {
    this.boardCodes = boardCodes;
  }


  public ApiHotel boards(List<ApiBoard> boards) {
    
    this.boards = boards;
    return this;
  }

  public ApiHotel addBoardsItem(ApiBoard boardsItem) {
    if (this.boards == null) {
      this.boards = new ArrayList<>();
    }
    this.boards.add(boardsItem);
    return this;
  }

   /**
   * List of boards offered at the hotel.
   * @return boards
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiBoard> getBoards() {
    return boards;
  }


  @JsonProperty(JSON_PROPERTY_BOARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoards(List<ApiBoard> boards) {
    this.boards = boards;
  }


  public ApiHotel category(ApiCategory category) {
    
    this.category = category;
    return this;
  }

   /**
   * Get category
   * @return category
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiCategory getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategory(ApiCategory category) {
    this.category = category;
  }


  public ApiHotel categoryCode(String categoryCode) {
    
    this.categoryCode = categoryCode;
    return this;
  }

   /**
   * Hotel rating based on the information provided by the hotel.
   * @return categoryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryCode() {
    return categoryCode;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }


  public ApiHotel categoryGroup(ApiGroupCategory categoryGroup) {
    
    this.categoryGroup = categoryGroup;
    return this;
  }

   /**
   * Get categoryGroup
   * @return categoryGroup
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CATEGORY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiGroupCategory getCategoryGroup() {
    return categoryGroup;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryGroup(ApiGroupCategory categoryGroup) {
    this.categoryGroup = categoryGroup;
  }


  public ApiHotel categoryGroupCode(String categoryGroupCode) {
    
    this.categoryGroupCode = categoryGroupCode;
    return this;
  }

   /**
   * Group name of the category to which the hotel belongs.
   * @return categoryGroupCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategoryGroupCode() {
    return categoryGroupCode;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryGroupCode(String categoryGroupCode) {
    this.categoryGroupCode = categoryGroupCode;
  }


  public ApiHotel chain(ApiChain chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Get chain
   * @return chain
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiChain getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(ApiChain chain) {
    this.chain = chain;
  }


  public ApiHotel chainCode(String chainCode) {
    
    this.chainCode = chainCode;
    return this;
  }

   /**
   * Code of the chain that the hotel belongs to.
   * @return chainCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChainCode() {
    return chainCode;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChainCode(String chainCode) {
    this.chainCode = chainCode;
  }


  public ApiHotel city(ApiContent city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(ApiContent city) {
    this.city = city;
  }


  public ApiHotel code(Integer code) {
    
    this.code = code;
    return this;
  }

   /**
   * Hotelbeds internal hotel code.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public ApiHotel coordinates(ApiGeoLocation coordinates) {
    
    this.coordinates = coordinates;
    return this;
  }

   /**
   * Get coordinates
   * @return coordinates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COORDINATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiGeoLocation getCoordinates() {
    return coordinates;
  }


  @JsonProperty(JSON_PROPERTY_COORDINATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoordinates(ApiGeoLocation coordinates) {
    this.coordinates = coordinates;
  }


  public ApiHotel country(ApiCountry country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiCountry getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(ApiCountry country) {
    this.country = country;
  }


  public ApiHotel countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Code of the country where the hotel is located.
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public ApiHotel description(ApiContent description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(ApiContent description) {
    this.description = description;
  }


  public ApiHotel destination(ApiDestination destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiDestination getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(ApiDestination destination) {
    this.destination = destination;
  }


  public ApiHotel destinationCode(String destinationCode) {
    
    this.destinationCode = destinationCode;
    return this;
  }

   /**
   * Code of the destination of the hotel location.
   * @return destinationCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationCode() {
    return destinationCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationCode(String destinationCode) {
    this.destinationCode = destinationCode;
  }


  public ApiHotel email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Hotel e-mail address. More than one email can be returned, separated by \&quot;;\&quot; characters.
   * @return email
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }


  public ApiHotel exclusiveDeal(Integer exclusiveDeal) {
    
    this.exclusiveDeal = exclusiveDeal;
    return this;
  }

   /**
   * The value follows a qualitative scale, the number 1 being always the top priority/preferential, and the rest of the product defined by our commercial departments. As of today, the possible values are:   1: Identifies preferential product with exclusive conditions.    2: Identifies the rest of our top hotels.    3: Identifies the rest of the hotels.  In case new values are added in the future, a proper communication campaign will be carried out to inform you. 
   * @return exclusiveDeal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXCLUSIVE_DEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExclusiveDeal() {
    return exclusiveDeal;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUSIVE_DEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExclusiveDeal(Integer exclusiveDeal) {
    this.exclusiveDeal = exclusiveDeal;
  }


  public ApiHotel facilities(List<ApiHotelFacility> facilities) {
    
    this.facilities = facilities;
    return this;
  }

  public ApiHotel addFacilitiesItem(ApiHotelFacility facilitiesItem) {
    if (this.facilities == null) {
      this.facilities = new ArrayList<>();
    }
    this.facilities.add(facilitiesItem);
    return this;
  }

   /**
   * List of facilities, amenities and installations in the hotel.
   * @return facilities
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FACILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelFacility> getFacilities() {
    return facilities;
  }


  @JsonProperty(JSON_PROPERTY_FACILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilities(List<ApiHotelFacility> facilities) {
    this.facilities = facilities;
  }


  public ApiHotel giataCode(Integer giataCode) {
    
    this.giataCode = giataCode;
    return this;
  }

   /**
   * Giata code of the hotel. Will only be returned if the client has agreement with Giata.
   * @return giataCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GIATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGiataCode() {
    return giataCode;
  }


  @JsonProperty(JSON_PROPERTY_GIATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGiataCode(Integer giataCode) {
    this.giataCode = giataCode;
  }


  public ApiHotel images(List<ApiImage> images) {
    
    this.images = images;
    return this;
  }

  public ApiHotel addImagesItem(ApiImage imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * List of hotel pictures.
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiImage> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<ApiImage> images) {
    this.images = images;
  }


  public ApiHotel interestPoints(List<ApiHotelPointOfInterest> interestPoints) {
    
    this.interestPoints = interestPoints;
    return this;
  }

  public ApiHotel addInterestPointsItem(ApiHotelPointOfInterest interestPointsItem) {
    if (this.interestPoints == null) {
      this.interestPoints = new ArrayList<>();
    }
    this.interestPoints.add(interestPointsItem);
    return this;
  }

   /**
   * List of points of interest close to the hotel.
   * @return interestPoints
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTEREST_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelPointOfInterest> getInterestPoints() {
    return interestPoints;
  }


  @JsonProperty(JSON_PROPERTY_INTEREST_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterestPoints(List<ApiHotelPointOfInterest> interestPoints) {
    this.interestPoints = interestPoints;
  }


  public ApiHotel issues(List<ApiHotelIssue> issues) {
    
    this.issues = issues;
    return this;
  }

  public ApiHotel addIssuesItem(ApiHotelIssue issuesItem) {
    if (this.issues == null) {
      this.issues = new ArrayList<>();
    }
    this.issues.add(issuesItem);
    return this;
  }

   /**
   * List of issues affecting the hotel.
   * @return issues
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ISSUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelIssue> getIssues() {
    return issues;
  }


  @JsonProperty(JSON_PROPERTY_ISSUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssues(List<ApiHotelIssue> issues) {
    this.issues = issues;
  }


  public ApiHotel lastUpdate(String lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Date of the last update in the information of the hotel.
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(String lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public ApiHotel license(String license) {
    
    this.license = license;
    return this;
  }

   /**
   * Accommodation registration number.
   * @return license
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LICENSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicense() {
    return license;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicense(String license) {
    this.license = license;
  }


  public ApiHotel name(ApiContent name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(ApiContent name) {
    this.name = name;
  }


  public ApiHotel phones(List<ApiHotelPhone> phones) {
    
    this.phones = phones;
    return this;
  }

  public ApiHotel addPhonesItem(ApiHotelPhone phonesItem) {
    if (this.phones == null) {
      this.phones = new ArrayList<>();
    }
    this.phones.add(phonesItem);
    return this;
  }

   /**
   * List of contact phones of the hotel.
   * @return phones
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PHONES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelPhone> getPhones() {
    return phones;
  }


  @JsonProperty(JSON_PROPERTY_PHONES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhones(List<ApiHotelPhone> phones) {
    this.phones = phones;
  }


  public ApiHotel postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Hotel address postal code.
   * @return postalCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public ApiHotel ranking(Integer ranking) {
    
    this.ranking = ranking;
    return this;
  }

   /**
   * Hotelbeds internal sorting ranking (NOTE: please bear in mind is not related to hotel category).
   * @return ranking
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RANKING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRanking() {
    return ranking;
  }


  @JsonProperty(JSON_PROPERTY_RANKING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRanking(Integer ranking) {
    this.ranking = ranking;
  }


  public ApiHotel rooms(List<ApiHotelRoom> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public ApiHotel addRoomsItem(ApiHotelRoom roomsItem) {
    if (this.rooms == null) {
      this.rooms = new ArrayList<>();
    }
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * List of available rooms types at the hotel.
   * @return rooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelRoom> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(List<ApiHotelRoom> rooms) {
    this.rooms = rooms;
  }


  public ApiHotel segmentCodes(List<Integer> segmentCodes) {
    
    this.segmentCodes = segmentCodes;
    return this;
  }

  public ApiHotel addSegmentCodesItem(Integer segmentCodesItem) {
    if (this.segmentCodes == null) {
      this.segmentCodes = new ArrayList<>();
    }
    this.segmentCodes.add(segmentCodesItem);
    return this;
  }

   /**
   * List of the internal segment codes.
   * @return segmentCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getSegmentCodes() {
    return segmentCodes;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCodes(List<Integer> segmentCodes) {
    this.segmentCodes = segmentCodes;
  }


  public ApiHotel segments(List<ApiSegment> segments) {
    
    this.segments = segments;
    return this;
  }

  public ApiHotel addSegmentsItem(ApiSegment segmentsItem) {
    if (this.segments == null) {
      this.segments = new ArrayList<>();
    }
    this.segments.add(segmentsItem);
    return this;
  }

   /**
   * List of segments.
   * @return segments
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiSegment> getSegments() {
    return segments;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegments(List<ApiSegment> segments) {
    this.segments = segments;
  }


  public ApiHotel state(ApiState state) {
    
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiState getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(ApiState state) {
    this.state = state;
  }


  public ApiHotel stateCode(String stateCode) {
    
    this.stateCode = stateCode;
    return this;
  }

   /**
   * Internal code of the state.
   * @return stateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStateCode() {
    return stateCode;
  }


  @JsonProperty(JSON_PROPERTY_STATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStateCode(String stateCode) {
    this.stateCode = stateCode;
  }


  public ApiHotel terminals(List<ApiHotelTerminal> terminals) {
    
    this.terminals = terminals;
    return this;
  }

  public ApiHotel addTerminalsItem(ApiHotelTerminal terminalsItem) {
    if (this.terminals == null) {
      this.terminals = new ArrayList<>();
    }
    this.terminals.add(terminalsItem);
    return this;
  }

   /**
   * List of terminals associated to the hotel and their distance to the hotel.
   * @return terminals
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelTerminal> getTerminals() {
    return terminals;
  }


  @JsonProperty(JSON_PROPERTY_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerminals(List<ApiHotelTerminal> terminals) {
    this.terminals = terminals;
  }


  public ApiHotel web(String web) {
    
    this.web = web;
    return this;
  }

   /**
   * Website URL of the hotel or the chain.
   * @return web
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWeb() {
    return web;
  }


  @JsonProperty(JSON_PROPERTY_WEB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWeb(String web) {
    this.web = web;
  }


  public ApiHotel wildcards(List<ApiWildCard> wildcards) {
    
    this.wildcards = wildcards;
    return this;
  }

  public ApiHotel addWildcardsItem(ApiWildCard wildcardsItem) {
    if (this.wildcards == null) {
      this.wildcards = new ArrayList<>();
    }
    this.wildcards.add(wildcardsItem);
    return this;
  }

   /**
   * List of wildcard rooms.
   * @return wildcards
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_WILDCARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiWildCard> getWildcards() {
    return wildcards;
  }


  @JsonProperty(JSON_PROPERTY_WILDCARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWildcards(List<ApiWildCard> wildcards) {
    this.wildcards = wildcards;
  }


  public ApiHotel zone(ApiZone zone) {
    
    this.zone = zone;
    return this;
  }

   /**
   * Get zone
   * @return zone
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiZone getZone() {
    return zone;
  }


  @JsonProperty(JSON_PROPERTY_ZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZone(ApiZone zone) {
    this.zone = zone;
  }


  public ApiHotel zoneCode(Integer zoneCode) {
    
    this.zoneCode = zoneCode;
    return this;
  }

   /**
   * Internal zone code, where the hotel is located.
   * @return zoneCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getZoneCode() {
    return zoneCode;
  }


  @JsonProperty(JSON_PROPERTY_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoneCode(Integer zoneCode) {
    this.zoneCode = zoneCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotel apiHotel = (ApiHotel) o;
    return Objects.equals(this.S2C, apiHotel.S2C) &&
        Objects.equals(this.accommodationType, apiHotel.accommodationType) &&
        Objects.equals(this.accommodationTypeCode, apiHotel.accommodationTypeCode) &&
        Objects.equals(this.address, apiHotel.address) &&
        Objects.equals(this.boardCodes, apiHotel.boardCodes) &&
        Objects.equals(this.boards, apiHotel.boards) &&
        Objects.equals(this.category, apiHotel.category) &&
        Objects.equals(this.categoryCode, apiHotel.categoryCode) &&
        Objects.equals(this.categoryGroup, apiHotel.categoryGroup) &&
        Objects.equals(this.categoryGroupCode, apiHotel.categoryGroupCode) &&
        Objects.equals(this.chain, apiHotel.chain) &&
        Objects.equals(this.chainCode, apiHotel.chainCode) &&
        Objects.equals(this.city, apiHotel.city) &&
        Objects.equals(this.code, apiHotel.code) &&
        Objects.equals(this.coordinates, apiHotel.coordinates) &&
        Objects.equals(this.country, apiHotel.country) &&
        Objects.equals(this.countryCode, apiHotel.countryCode) &&
        Objects.equals(this.description, apiHotel.description) &&
        Objects.equals(this.destination, apiHotel.destination) &&
        Objects.equals(this.destinationCode, apiHotel.destinationCode) &&
        Objects.equals(this.email, apiHotel.email) &&
        Objects.equals(this.exclusiveDeal, apiHotel.exclusiveDeal) &&
        Objects.equals(this.facilities, apiHotel.facilities) &&
        Objects.equals(this.giataCode, apiHotel.giataCode) &&
        Objects.equals(this.images, apiHotel.images) &&
        Objects.equals(this.interestPoints, apiHotel.interestPoints) &&
        Objects.equals(this.issues, apiHotel.issues) &&
        Objects.equals(this.lastUpdate, apiHotel.lastUpdate) &&
        Objects.equals(this.license, apiHotel.license) &&
        Objects.equals(this.name, apiHotel.name) &&
        Objects.equals(this.phones, apiHotel.phones) &&
        Objects.equals(this.postalCode, apiHotel.postalCode) &&
        Objects.equals(this.ranking, apiHotel.ranking) &&
        Objects.equals(this.rooms, apiHotel.rooms) &&
        Objects.equals(this.segmentCodes, apiHotel.segmentCodes) &&
        Objects.equals(this.segments, apiHotel.segments) &&
        Objects.equals(this.state, apiHotel.state) &&
        Objects.equals(this.stateCode, apiHotel.stateCode) &&
        Objects.equals(this.terminals, apiHotel.terminals) &&
        Objects.equals(this.web, apiHotel.web) &&
        Objects.equals(this.wildcards, apiHotel.wildcards) &&
        Objects.equals(this.zone, apiHotel.zone) &&
        Objects.equals(this.zoneCode, apiHotel.zoneCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(S2C, accommodationType, accommodationTypeCode, address, boardCodes, boards, category, categoryCode, categoryGroup, categoryGroupCode, chain, chainCode, city, code, coordinates, country, countryCode, description, destination, destinationCode, email, exclusiveDeal, facilities, giataCode, images, interestPoints, issues, lastUpdate, license, name, phones, postalCode, ranking, rooms, segmentCodes, segments, state, stateCode, terminals, web, wildcards, zone, zoneCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotel {\n");
    sb.append("    S2C: ").append(toIndentedString(S2C)).append("\n");
    sb.append("    accommodationType: ").append(toIndentedString(accommodationType)).append("\n");
    sb.append("    accommodationTypeCode: ").append(toIndentedString(accommodationTypeCode)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    boardCodes: ").append(toIndentedString(boardCodes)).append("\n");
    sb.append("    boards: ").append(toIndentedString(boards)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    categoryCode: ").append(toIndentedString(categoryCode)).append("\n");
    sb.append("    categoryGroup: ").append(toIndentedString(categoryGroup)).append("\n");
    sb.append("    categoryGroupCode: ").append(toIndentedString(categoryGroupCode)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    chainCode: ").append(toIndentedString(chainCode)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    coordinates: ").append(toIndentedString(coordinates)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationCode: ").append(toIndentedString(destinationCode)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    exclusiveDeal: ").append(toIndentedString(exclusiveDeal)).append("\n");
    sb.append("    facilities: ").append(toIndentedString(facilities)).append("\n");
    sb.append("    giataCode: ").append(toIndentedString(giataCode)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    interestPoints: ").append(toIndentedString(interestPoints)).append("\n");
    sb.append("    issues: ").append(toIndentedString(issues)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    license: ").append(toIndentedString(license)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    phones: ").append(toIndentedString(phones)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    ranking: ").append(toIndentedString(ranking)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    segmentCodes: ").append(toIndentedString(segmentCodes)).append("\n");
    sb.append("    segments: ").append(toIndentedString(segments)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    stateCode: ").append(toIndentedString(stateCode)).append("\n");
    sb.append("    terminals: ").append(toIndentedString(terminals)).append("\n");
    sb.append("    web: ").append(toIndentedString(web)).append("\n");
    sb.append("    wildcards: ").append(toIndentedString(wildcards)).append("\n");
    sb.append("    zone: ").append(toIndentedString(zone)).append("\n");
    sb.append("    zoneCode: ").append(toIndentedString(zoneCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

